/*
 * Decompiled with CFR 0.152.
 */
package utils.jnlpbuilder;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.persistence.database.DatabaseConnection;
import au.com.ordermate.persistence.database.datasourcefactory.ConfigDataSourceFactory;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import ordermate.OrderMate;
import ordermate.database.misc.application.Application;
import ordermate.database.misc.application.ApplicationConfig;
import ordermate.jnlp.JNLPBuilder;
import ordermate.startup.LoggerSetupTask;

class BootstrapJNLPBuilder {
    private static final String APPLICATION = "application";
    private static final String STARTING_MEMORY = "starting_memory";
    private static final String MAXIMUM_MEMORY = "maximum_memory";

    BootstrapJNLPBuilder() {
    }

    public static void main(String[] args) {
        new LoggerSetupTask("JNLPBuilder").run();
        String application = Application.Servermate.name();
        String path = null;
        if (args.length > 1) {
            application = args[0];
            path = args[1];
        }
        BootstrapJNLPBuilder build = new BootstrapJNLPBuilder();
        if (!application.equals("ALL")) {
            build.createNewJNLP(application, path);
        } else {
            for (Application nextApplication : Application.values()) {
                build.createNewJNLP(nextApplication.name(), path);
            }
        }
    }

    private void createNewJNLP(String appName, String path) {
        ApplicationConfig config = null;
        Application app = Application.valueOf((String)appName);
        OrderMate.LOG.info("Creating application jnlp for:" + appName + " to:" + path);
        if (app == null) {
            OrderMate.LOG.warn("Cannot create application config for:" + appName + ". It's foreign to me.");
        } else {
            try {
                Config.readConfigData((String)"ServerMateConfig.ini");
                config = this.createApplicationConfig(app);
            }
            catch (IOException ex) {
                OrderMate.LOG.warn("Couldn't read in the ServerMateConfig.ini file", (Throwable)ex);
            }
        }
        if (config == null) {
            OrderMate.LOG.warn("Couldn't create Application config, jnlp will not be created.");
            return;
        }
        OrderMate.LOG.info("Everything ok to create the JNLP.");
        JNLPBuilder builder = new JNLPBuilder();
        builder.createJNLPFile(config, path);
        if (Application.Servermate.equals((Object)config.getApplication())) {
            // empty if block
        }
    }

    private ApplicationConfig createApplicationConfig(Application app) {
        DatabaseConnection connection = this.connectToDB();
        if (connection == null) {
            OrderMate.LOG.warn("Couldn't create database connection to access system_application_config.");
            return null;
        }
        ApplicationConfig config = this.extractJuicyData(connection, app);
        try {
            connection.getDBConnection().close();
        }
        catch (SQLException ex) {
            OrderMate.LOG.warn("Could not close off the database connection.", (Throwable)ex);
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatabaseConnection connectToDB() {
        ResultSet rs;
        DatabaseConnection connection = new DatabaseConnection(ConfigDataSourceFactory.getInstance());
        try {
            rs = connection.executeQuery("SELECT * FROM system_application_config");
        }
        catch (SQLException ex) {
            OrderMate.LOG.warn("Cannot execute query for applicationConfig:", (Throwable)ex);
            return null;
        }
        try {
            if (rs.next()) {
                ResultSetMetaData RSMD = rs.getMetaData();
                int count = RSMD.getColumnCount();
                ArrayList<String> columns = new ArrayList<String>(count);
                for (int i = 0; i < count; ++i) {
                    columns.add(RSMD.getColumnName(i + 1).toLowerCase());
                }
                if (columns.contains(APPLICATION) && columns.contains(STARTING_MEMORY) && columns.contains(MAXIMUM_MEMORY)) {
                    DatabaseConnection databaseConnection = connection;
                    return databaseConnection;
                }
                OrderMate.LOG.warn("Couldn't find required columns");
            }
        }
        catch (SQLException ex) {
            OrderMate.LOG.warn("Problem examining the system_application_config table:", (Throwable)ex);
        }
        finally {
            try {
                OrderMate.LOG.info("Closing off result set.");
                rs.close();
            }
            catch (SQLException ex) {
                OrderMate.LOG.error("Couldn't close of the result set:", (Throwable)ex);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApplicationConfig extractJuicyData(DatabaseConnection con, Application app) {
        StringBuilder SB = new StringBuilder("SELECT ");
        SB.append(APPLICATION).append(", ").append(STARTING_MEMORY).append(", ").append(MAXIMUM_MEMORY).append("\n FROM system_application_config WHERE ").append(APPLICATION).append(" = '").append(app.name()).append("'");
        ApplicationConfig config = null;
        ResultSet rs = null;
        try {
            rs = con.executeQuery(SB.toString());
            rs.next();
            config = new ApplicationConfig();
            int startingMemory = rs.getInt(STARTING_MEMORY);
            int maximumMemory = rs.getInt(MAXIMUM_MEMORY);
            config.setApplication(app);
            config.setStartingMemory(startingMemory);
            config.setMaximumMemory(maximumMemory);
        }
        catch (SQLException ex) {
            OrderMate.LOG.warn("Problem with querying system_application_config:", (Throwable)ex);
        }
        finally {
            if (rs != null) {
                try {
                    OrderMate.LOG.info("Closing off result set.");
                    rs.close();
                }
                catch (SQLException ex) {
                    OrderMate.LOG.warn("Just couldn't close off the result set after querying the system_application_config:", (Throwable)ex);
                }
            }
        }
        return config;
    }
}

