/*
 * Decompiled with CFR 0.152.
 */
package utils.installer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import utils.installer.GroovyInstallerGui;
import utils.installer.MysqlUpgrade;
import utils.installer.ShellExecutor;
import utils.installer.firewall.StandardFirewallRules;

public class GroovyInstaller
implements Observer {
    public static final String LOG_NAME = "GroovyInstaller";
    private static final Logger LOG = Logger.getLogger("GroovyInstaller");
    public static final String MYSQL_UPGRADE_ARG = "MYSQL_UPGRADE";
    public static final String STD_FIREWALL_ARG = "STD_FIREWALL";
    private static final String[] ALL_ARGS = new String[]{"MYSQL_UPGRADE", "STD_FIREWALL"};
    private final ShellExecutor executor = new ShellExecutor();
    private final GroovyInstallerGui gui = new GroovyInstallerGui();

    public static void main(String[] args) throws Exception {
        GroovyInstaller.configureLogging();
        GroovyInstaller installer = new GroovyInstaller();
        try {
            installer.handleArgs(args);
        }
        catch (Throwable ex) {
            installer.gui.stopPulseTimer();
            LOG.log(Level.SEVERE, "An error occurred in the groovy installer, returning 1, args were: " + Arrays.toString(args), ex);
            Thread.sleep(10000L);
            System.exit(1);
        }
        try {
            installer.gui.stopPulseTimer();
            installer.gui.setDefaultCloseOperation(3);
            Thread.sleep(10000L);
        }
        catch (Exception exception) {
        }
        finally {
            System.exit(0);
        }
    }

    private static void configureLogging() throws IOException {
        FileHandler handler = new FileHandler("C:\\OM-LOGS\\GroovyInstaller.log", true);
        handler.setFormatter(new SimpleFormatter());
        LOG.addHandler(handler);
        LOG.addHandler(new ConsoleHandler());
    }

    public GroovyInstaller() {
        this.executor.addObserver(this);
    }

    protected void handleArgs(String ... args) {
        String usageErrorMsg = "Usage : GroovyInstaller requires an argument, one of:\n" + Arrays.toString(ALL_ARGS);
        if (args.length != 1) {
            this.update(null, usageErrorMsg);
            throw new IllegalArgumentException(usageErrorMsg);
        }
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        if (argList.contains(MYSQL_UPGRADE_ARG)) {
            argList.remove(MYSQL_UPGRADE_ARG);
            new MysqlUpgrade(this.executor).exec();
        } else if (argList.contains(STD_FIREWALL_ARG)) {
            argList.remove(STD_FIREWALL_ARG);
            new StandardFirewallRules().addRules(this.executor);
        }
        this.gui.setDefaultCloseOperation(3);
        if (!argList.isEmpty()) {
            throw new IllegalArgumentException(usageErrorMsg);
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        this.gui.addTextLine(arg + "");
    }
}

