/*
 * Decompiled with CFR 0.152.
 */
package utils.installer;

import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class GroovyInstallerGui
extends JFrame {
    private final JTextArea console;
    private Timer repaintTimer;
    private float alpha = 0.5f;
    private int count = 0;

    public final void stopPulseTimer() {
        this.repaintTimer.stop();
        this.setAlpha(0.0f);
        this.repaint();
    }

    GroovyInstallerGui() {
        this.setTitle("OrderMate Updater");
        this.setDefaultCloseOperation(0);
        this.setPreferredSize(new Dimension(660, 520));
        this.setLocation(0, 60);
        JScrollPane scrollPane = this.createScrollPane();
        scrollPane.setViewport(this.createViewPort());
        this.console = this.createTextArea();
        this.createRepaintTimer();
        scrollPane.setViewportView(this.console);
        scrollPane.getViewport().setOpaque(false);
        this.setIconImage(this.getImage().getImage());
        this.getContentPane().add(scrollPane);
        this.pack();
        this.setVisible(true);
    }

    private JTextArea createTextArea() {
        JTextArea area = new JTextArea(25, 45);
        area.setEditable(false);
        area.setOpaque(false);
        return area;
    }

    private JScrollPane createScrollPane() {
        return new JScrollPane();
    }

    private JViewport createViewPort() {
        final Image imageBlur = this.getImage().getImage();
        final Image imageNorm = this.getImageNorm().getImage();
        return new JViewport(){

            @Override
            public void paintComponent(Graphics g) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setComposite(AlphaComposite.SrcOver.derive(GroovyInstallerGui.this.getAlpha()));
                g2.drawImage(imageNorm, 0, 0, null);
                g2.setComposite(AlphaComposite.SrcOver.derive(1.0f - GroovyInstallerGui.this.getAlpha()));
                g2.drawImage(imageBlur, 0, 0, null);
                super.paintComponent(g);
            }
        };
    }

    private void createRepaintTimer() {
        this.repaintTimer = new Timer(50, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroovyInstallerGui.this.setAlpha(Math.abs((float)Math.sin((float)GroovyInstallerGui.this.count++ / 20.0f)));
                GroovyInstallerGui.this.console.repaint();
            }
        });
        this.repaintTimer.start();
    }

    private ImageIcon getImage() {
        return new ImageIcon(GroovyInstallerGui.class.getResource("/utils/installer/images/smallomwatermarkblur.jpg"));
    }

    private ImageIcon getImageNorm() {
        return new ImageIcon(GroovyInstallerGui.class.getResource("/utils/installer/images/smallomwatermark.jpg"));
    }

    private synchronized void setAlpha(float a) {
        this.alpha = a;
    }

    private synchronized float getAlpha() {
        return this.alpha;
    }

    public void addTextLine(final String toAdd) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String text = GroovyInstallerGui.this.console.getText();
                text = text + "\n";
                text = text + toAdd;
                GroovyInstallerGui.this.console.setText(text);
                GroovyInstallerGui.this.console.repaint();
            }
        });
    }
}

