/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.version;

import au.com.ordermate.version.VersionStability;

public class OMVersion
implements Comparable<OMVersion> {
    private final int major;
    private final int subMajor;
    private final int minor;
    private final String revision;
    private final VersionStability stability;
    private final String versionString;

    public OMVersion(int maj, int subMaj, int min, VersionStability stab, String rev) {
        this.major = maj;
        this.subMajor = subMaj;
        this.minor = min;
        this.stability = stab;
        if (this.major <= 0) {
            throw new IllegalArgumentException("Cannot have a major version less than or equal to zero");
        }
        if (subMaj < 0 || this.minor < 0) {
            throw new IllegalArgumentException("Cannot have a subMajor or minor version less than zero");
        }
        if (rev == null) {
            throw new IllegalArgumentException("Revision cannot be null " + rev);
        }
        this.revision = rev.trim();
        if (stab == null) {
            throw new IllegalArgumentException("Stability cannot be null");
        }
        this.versionString = this.createVersionString();
    }

    private String createVersionString() {
        StringBuilder SB = new StringBuilder();
        SB.append(this.major).append(".").append(this.subMajor).append(".").append(this.minor);
        if (!VersionStability.Stable.equals((Object)this.stability)) {
            SB.append(" ");
        }
        SB.append(this.stability.getLabel()).append(this.revision);
        return SB.toString();
    }

    public int getMajor() {
        return this.major;
    }

    public int getSubMajor() {
        return this.subMajor;
    }

    public int getMinor() {
        return this.minor;
    }

    public String getRevision() {
        return this.revision;
    }

    public VersionStability getStability() {
        return this.stability;
    }

    public String toString() {
        return this.versionString;
    }

    public boolean equals(Object value) {
        if (value == this) {
            return true;
        }
        if (value == null) {
            return false;
        }
        if (value instanceof OMVersion) {
            OMVersion other = (OMVersion)value;
            return other.major == this.major && other.subMajor == this.subMajor && other.minor == this.minor && other.stability.equals((Object)this.stability) && this.revision.equals(other.revision);
        }
        return false;
    }

    public int hashCode() {
        return this.versionString.hashCode();
    }

    public boolean isBefore(OMVersion otherVersion) {
        return this.compareTo(otherVersion) < 0;
    }

    @Override
    public int compareTo(OMVersion o) {
        if (o.getMajor() != this.major) {
            return this.major - o.getMajor();
        }
        if (o.getSubMajor() != this.subMajor) {
            return this.subMajor - o.getSubMajor();
        }
        if (o.getMinor() != this.minor) {
            return this.minor - o.getMinor();
        }
        if (o.getStability() != this.stability) {
            int myStability = 0;
            int theirStability = 0;
            VersionStability[] stabilities = VersionStability.values();
            for (int i = 0; i < stabilities.length; ++i) {
                if (stabilities[i] == this.stability) {
                    myStability = i;
                }
                if (stabilities[i] != o.getStability()) continue;
                theirStability = i;
            }
            if (myStability != theirStability) {
                return myStability - theirStability;
            }
        }
        return this.revision.compareTo(o.getRevision());
    }
}

