/*
 * Decompiled with CFR 0.152.
 */
package ordermate.launcher;

import au.com.ordermate.OrderMateLog;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import ordermate.database.misc.application.Application;
import ordermate.launcher.LauncherConfig;

class LaunchProcess {
    final Application app;
    long time;
    final long retryDelay;
    final LauncherConfig config;
    int attempts = 1;
    LaunchState state = null;

    public LaunchProcess(Application app, long atThisTime, long retryDelay, LauncherConfig config) {
        this.app = app;
        this.time = atThisTime;
        this.config = config;
        this.retryDelay = retryDelay;
        this.state = LaunchState.Countdown;
    }

    void performLaunch() {
        this.state = LaunchState.Launching;
        boolean success = false;
        String suffix = (Object)((Object)this.app) + ".jnlp";
        if (Application.Servermate.equals((Object)this.app)) {
            success = this.tryLaunchFromServer("localhost", suffix);
        } else {
            for (String nextServer : this.config.getServers()) {
                if (!this.tryLaunchFromServer(nextServer, suffix)) continue;
                success = true;
                break;
            }
        }
        this.state = success ? LaunchState.LiftOff : LaunchState.Failed;
    }

    private boolean tryLaunchFromServer(String server, String appSuffix) {
        StringBuilder SB = new StringBuilder(server).append("/webstart/").append(appSuffix);
        String fileParam = SB.toString();
        OrderMateLog.LOG.info("Trying to launch from:" + fileParam);
        URL url = null;
        HttpURLConnection con = null;
        try {
            url = new URL("http://" + fileParam);
            con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("HEAD");
            if (con.getResponseCode() != 200) {
                OrderMateLog.LOG.error("Could not launch OrderMate : not ok response from server");
                return false;
            }
        }
        catch (Exception ex) {
            OrderMateLog.LOG.error("Could not launch OrderMate: no connection?", (Throwable)ex);
            return false;
        }
        SB = new StringBuilder(System.getProperty("java.home"));
        SB.append(File.separator).append("bin").append(File.separator).append("javaws.exe");
        String launch = SB.toString();
        OrderMateLog.LOG.info(launch + " http://" + fileParam);
        ProcessBuilder builder = new ProcessBuilder(launch, "http://" + fileParam);
        try {
            Process process = builder.start();
            int result = process.waitFor();
            OrderMateLog.LOG.error("Got result:" + result);
        }
        catch (IOException ex) {
            OrderMateLog.LOG.error("Could not launch OrderMate:", (Throwable)ex);
            return false;
        }
        catch (InterruptedException ex) {
            OrderMateLog.LOG.error("Interrupted while waiting for launch:", (Throwable)ex);
            return false;
        }
        return true;
    }

    static enum LaunchState {
        Countdown,
        Launching,
        LiftOff,
        Failed;

    }
}

