/*
 * Decompiled with CFR 0.152.
 */
package ordermate.launcher;

import au.com.ordermate.OrderMateLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.misc.application.Application;

public class LauncherConfig {
    public static final String FILE_NAME = "Launcher.cfg";
    public static final String CONFIG_FILE = "C:/Program Files/OrderMate/OrderMateTemp/Launcher.cfg";
    public static final int DEFAULT_PORT = 48202;
    private List<String> servers = new ArrayList<String>();
    private List<Application> applications = new ArrayList<Application>();
    private int servermateDelay = 30;
    private int othermateDelay = 60;
    private int port = 48202;

    public LauncherConfig() {
        for (Application app : Application.values()) {
            this.applications.add(app);
        }
        this.servers.add("localhost");
    }

    public LauncherConfig(List<Application> yourApps, List<String> yourServers) {
        this.applications = yourApps;
        this.servers = yourServers;
    }

    List<Application> getApps() {
        return this.applications;
    }

    List<String> getServers() {
        return this.servers;
    }

    public long getServermateDelay() {
        return (long)this.servermateDelay * 1000L;
    }

    public long getOthermateDelay() {
        return (long)this.othermateDelay * 1000L;
    }

    public void writeToDisk() {
        this.writeToDisk(new File(CONFIG_FILE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToDisk(File file) {
        File outFile = file;
        FileOutputStream fout = null;
        PrintWriter writer = null;
        try {
            fout = new FileOutputStream(outFile);
            writer = new PrintWriter(fout);
            writer.write("OrderMate Launcher Config\r\n");
            writer.write("Modified:" + new Date() + "\r\n");
            this.writeList(writer, "servers=", this.servers);
            this.writeList(writer, "applications=", this.applications);
            writer.write("servermate_delay=" + this.servermateDelay + "\r\n");
            writer.write("othermate_delay=" + this.othermateDelay + "\r\n");
            writer.write("port=" + this.port + "\r\n");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.flush();
                    fout.flush();
                    fout.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public void readFromDisk() {
        this.readFromDisk(new File(FILE_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFromDisk(File fromFile) {
        File file = fromFile;
        if (file.exists()) {
            OrderMate.LOG.info("Reading in config file");
            FileInputStream fin = null;
            BufferedReader reader = null;
            try {
                fin = new FileInputStream(file);
                reader = new BufferedReader(new InputStreamReader(fin));
                String line = reader.readLine();
                while (line != null) {
                    if (line.startsWith("servers=")) {
                        this.loadServers(line);
                    } else if (line.startsWith("applications=")) {
                        this.loadApplications(line);
                    } else if (line.startsWith("servermate_delay")) {
                        this.servermateDelay = this.wrangleDelay(line);
                    } else if (line.startsWith("othermate_delay")) {
                        this.othermateDelay = this.wrangleDelay(line);
                    } else if (line.startsWith("port")) {
                        try {
                            this.port = Integer.parseInt(line.substring("port=".length()));
                        }
                        catch (NumberFormatException ex) {
                            OrderMateLog.LOG.error("Cannot wrangle port");
                        }
                    }
                    line = reader.readLine();
                }
            }
            catch (IOException ex) {
                OrderMateLog.LOG.error("Error reading in config:" + ex);
            }
            finally {
                if (fin != null) {
                    try {
                        fin.close();
                    }
                    catch (IOException ex) {
                        OrderMateLog.LOG.error("Error closing off launcher config:" + ex);
                    }
                }
            }
        } else {
            OrderMate.LOG.warn("No config file found at " + fromFile);
        }
        StringBuilder SB = new StringBuilder("Config State \r\nApplications:\r\n");
        for (Application app : this.applications) {
            SB.append("- ").append(app.name()).append("\r\n");
        }
        SB.append("ServerMate Delay ").append(this.servermateDelay).append("\r\n");
        SB.append("OtherMate Delay ").append(this.servermateDelay).append("\r\n");
        SB.append("Port ").append(this.port);
        SB.append("\r\nServers:\r\n");
        for (String server : this.servers) {
            SB.append("- ").append(server).append("\r\n");
        }
        OrderMate.LOG.info(SB.toString());
    }

    private void loadServers(String value) {
        String serverString = value.substring(value.indexOf("=") + 1);
        String[] splits = serverString.split(",");
        this.servers.clear();
        for (String nextServer : splits) {
            if (nextServer == null || nextServer.trim().isEmpty()) continue;
            this.servers.add(nextServer.trim());
        }
    }

    private void loadApplications(String value) {
        String appString = value.substring(value.indexOf("=") + 1);
        String[] splits = appString.split(",");
        this.applications.clear();
        for (String nextApp : splits) {
            if (nextApp == null || nextApp.trim().isEmpty()) continue;
            try {
                this.applications.add(Application.valueOf(nextApp.trim()));
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot add application of type " + nextApp);
            }
        }
    }

    private int wrangleDelay(String line) {
        try {
            return Integer.parseInt(line.substring(line.indexOf("=") + 1));
        }
        catch (Throwable throwable) {
            return 60;
        }
    }

    private void writeList(PrintWriter writer, String name, List<? extends Object> data) {
        writer.write(name);
        for (Object object : data) {
            writer.write(String.valueOf(object));
            writer.write(",");
        }
        writer.write("\r\n");
    }

    public int getPort() {
        return this.port;
    }
}

