/*
 * Decompiled with CFR 0.152.
 */
package ordermate.launcher;

import com.sun.awt.AWTUtilities;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import ordermate.database.misc.application.Application;
import ordermate.launcher.LauncherIcons;
import ordermate.launcher.LauncherPanel;
import ordermate.launcher.OrderMateLauncher;

public class LauncherGui
implements ActionListener {
    private List<AbstractButton> buttons;
    private JFrame frame;
    private OrderMateLauncher launcher;

    public LauncherGui(OrderMateLauncher launcher) {
        this.launcher = launcher;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void showFrame() {
        if (this.frame == null) {
            this.frame = new JFrame();
            this.frame.setTitle("OrderMate Launcher");
            this.frame.setDefaultCloseOperation(1);
            this.frame.setUndecorated(true);
            this.frame.toFront();
            Image image = LauncherIcons.loadImage("/ordermate/launcher/images/splash.png");
            LauncherPanel launcherPanel = new LauncherPanel(image, this.launcher);
            this.setupButtons(launcherPanel, this.launcher.getApplicationsToLaunch());
            this.frame.getContentPane().add(launcherPanel);
            if (AWTUtilities.isTranslucencyCapable((GraphicsConfiguration)this.frame.getGraphicsConfiguration())) {
                AWTUtilities.setWindowOpaque((Window)this.frame, (boolean)false);
                AWTUtilities.setWindowOpacity((Window)this.frame, (float)1.0f);
            }
            this.frame.setSize(image.getWidth(null), image.getHeight(null));
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            this.frame.setLocation((dim.width - this.frame.getWidth()) / 2, (dim.height - this.frame.getHeight()) / 2);
        }
        this.frame.setVisible(true);
        this.frame.toFront();
    }

    public void hideFrame() {
        if (this.frame != null) {
            this.frame.setVisible(false);
        }
    }

    private void setupButtons(LauncherPanel panel, List<Application> apps) {
        this.buttons = new ArrayList<AbstractButton>();
        Image image = LauncherIcons.loadImage("/ordermate/launcher/images/buttons.png");
        for (Application app : apps) {
            JButton button = panel.addButton(app);
            button.setIcon(new ImageIcon(image));
            button.addActionListener(this);
            this.buttons.add(button);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        for (AbstractButton button : this.buttons) {
            button.setEnabled(false);
        }
        for (AbstractButton button : this.buttons) {
            if (source != button) continue;
            this.launcher.launch(button.getName());
        }
        for (AbstractButton button : this.buttons) {
            button.setEnabled(true);
        }
    }
}

