/*
 * Decompiled with CFR 0.152.
 */
package ordermate.launcher;

import au.com.ordermate.OrderMateLog;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import ordermate.OrderMate;
import ordermate.database.misc.application.Application;
import ordermate.launcher.LauncherConfig;
import ordermate.launcher.OrderMateLauncher;

public class LauncherIO {
    private static final String EXIT = "Exit";
    private static final String SHOW = "Show";
    private static final String HIDE = "Hide";
    private static final String LAUNCH = "Launch:";
    private int port = 48202;
    private final OrderMateLauncher launcher;
    private ServerSocket serverSocket;
    private LauncherIgor igor;

    public LauncherIO() {
        this.launcher = null;
    }

    LauncherIO(OrderMateLauncher theLauncher) {
        int overPort;
        this.launcher = theLauncher;
        LauncherConfig config = this.launcher.getConfig();
        if (config != null && (overPort = config.getPort()) > 0) {
            this.port = overPort;
        }
        this.createSocket();
    }

    private void createSocket() {
        boolean valid = true;
        try {
            this.serverSocket = new ServerSocket(this.port);
            this.igor = new LauncherIgor();
            Thread thread = new Thread(this.igor);
            thread.setDaemon(true);
            thread.start();
            OrderMate.LOG.info("Igor created");
        }
        catch (IOException ex) {
            valid = false;
            OrderMateLog.LOG.error("Cannot create socket, terminating:" + ex);
        }
        if (!valid) {
            this.bringUpOtherLauncherAndTerminate();
        }
    }

    private void bringUpOtherLauncherAndTerminate() {
        if (this.sendMessage(SHOW)) {
            this.launcher.exit();
        }
    }

    void close() {
        this.igor.running = false;
        try {
            this.serverSocket.close();
        }
        catch (IOException ex) {
            OrderMateLog.LOG.warn("Cannot close off socket", (Throwable)ex);
        }
    }

    public boolean showLauncher() {
        return this.sendMessage(SHOW);
    }

    public boolean launchApp(Application app, long delay) {
        return this.sendMessage(LAUNCH + app.name() + "-" + delay);
    }

    private boolean sendMessage(String toSend) {
        try {
            Socket socket = new Socket("localhost", this.port);
            socket.getOutputStream().write(toSend.getBytes());
            socket.getOutputStream().flush();
            socket.close();
            return true;
        }
        catch (Exception ex) {
            OrderMateLog.LOG.warn("Cannot connect to other launcher", (Throwable)ex);
            return false;
        }
    }

    class LauncherIgor
    implements Runnable {
        boolean running = true;

        LauncherIgor() {
        }

        @Override
        public void run() {
            while (this.running) {
                try {
                    Socket socket = LauncherIO.this.serverSocket.accept();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                    String line = reader.readLine();
                    this.doCommand(line);
                }
                catch (Exception ex) {
                    OrderMateLog.LOG.error("Error listening for requests, Mashter!", (Throwable)ex);
                }
            }
        }

        private void doCommand(String value) {
            if (value == null) {
                return;
            }
            if (LauncherIO.EXIT.equals(value)) {
                LauncherIO.this.launcher.exit();
            } else if (LauncherIO.SHOW.equals(value)) {
                LauncherIO.this.launcher.showFrame();
            } else if (LauncherIO.HIDE.equals(value)) {
                LauncherIO.this.launcher.hideFrame();
            } else if (value.startsWith(LauncherIO.LAUNCH)) {
                try {
                    String applicationData = value.substring(LauncherIO.LAUNCH.length());
                    final String app = applicationData.substring(0, applicationData.indexOf("-"));
                    final long delay = Long.parseLong(applicationData.substring(applicationData.indexOf("-") + 1));
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            LauncherIO.this.launcher.launch(app, delay);
                        }
                    }).start();
                }
                catch (Exception ex) {
                    OrderMateLog.LOG.warn("Malformed application launch string", (Throwable)ex);
                }
            }
        }
    }
}

