/*
 * Decompiled with CFR 0.152.
 */
package ordermate.launcher;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import ordermate.database.misc.application.Application;
import ordermate.launcher.LauncherIcons;
import ordermate.launcher.OrderMateLauncher;

public class LauncherPanel
extends JPanel {
    private JPanel menuPanel;
    private Image underImage;
    private JPanel buttonHolder;
    private JButton exitButton;
    private JButton hideButton;
    private OrderMateLauncher launcher;

    public LauncherPanel(Image image, OrderMateLauncher launcher) {
        super(new BorderLayout());
        this.launcher = launcher;
        this.setupMainPanel(image);
        this.setupMenuPanel();
    }

    private void setupMainPanel(Image image) {
        this.setPreferredSize(new Dimension(image.getWidth(null), image.getHeight(null)));
        this.setOpaque(false);
        this.underImage = image;
        this.buttonHolder = new JPanel(new GridLayout(2, 1, 20, 20));
        this.buttonHolder.setOpaque(false);
        JPanel flowHolder = new JPanel(new FlowLayout(1));
        this.add(Box.createRigidArea(new Dimension(200, 150)), "North");
        flowHolder.setOpaque(false);
        flowHolder.add(this.buttonHolder);
        this.add((Component)flowHolder, "Center");
    }

    private void setupMenuPanel() {
        Image image = LauncherIcons.loadImage("/ordermate/launcher/images/exit.png");
        this.exitButton = new JButton("Exit", new ImageIcon(image));
        this.exitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LauncherPanel.this.launcher.exit();
            }
        });
        this.setupButton(this.exitButton);
        image = LauncherIcons.loadImage("/ordermate/launcher/images/hide.png");
        this.hideButton = new JButton("Hide", new ImageIcon(image));
        this.hideButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LauncherPanel.this.launcher.hideFrame();
            }
        });
        this.setupButton(this.hideButton);
        JPanel bufferedHolder = new JPanel(new FlowLayout(0));
        bufferedHolder.add(Box.createHorizontalStrut(50));
        bufferedHolder.add(this.hideButton);
        bufferedHolder.add(Box.createHorizontalStrut(25));
        bufferedHolder.add(this.exitButton);
        bufferedHolder.setOpaque(false);
        this.add((Component)bufferedHolder, "South");
    }

    JButton addButton(Application app) {
        JButton button = new JButton(app.toString());
        this.setupButton(button);
        button.setName(app.toString());
        button.setPreferredSize(new Dimension(150, 100));
        this.buttonHolder.add(button);
        return button;
    }

    private void setupButton(JButton button) {
        button.setHorizontalTextPosition(0);
        button.setVerticalTextPosition(3);
        button.setBorder(null);
        button.setBackground(null);
        button.setOpaque(false);
        button.setBorderPainted(false);
        button.setContentAreaFilled(false);
        button.setFocusPainted(false);
        button.setRolloverEnabled(false);
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.underImage != null) {
            if (this.isOpaque() && this.getBackground() != null) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            g.drawImage(this.underImage, (int)(0.5 * (double)(this.getWidth() - this.underImage.getWidth(null))), (int)(0.5 * (double)(this.getHeight() - this.underImage.getHeight(null))), null);
        } else {
            super.paintComponent(g);
        }
    }
}

