/*
 * Decompiled with CFR 0.152.
 */
package ordermate.launcher;

import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.Timer;
import ordermate.OrderMate;
import ordermate.database.misc.application.Application;
import ordermate.launcher.LaunchProcess;
import ordermate.launcher.LauncherConfig;
import ordermate.launcher.LauncherGui;
import ordermate.launcher.LauncherIO;
import ordermate.startup.LoggerSetupTask;

public class OrderMateLauncher {
    private static final String LAUNCHER = "Launcher";
    private LauncherGui gui;
    private LauncherConfig config;
    private TrayIcon trayIcon;
    private LauncherIO io;
    private boolean loadFromStartup = true;
    private Map<Application, LaunchProcess> launchMap;
    private Timer timer;

    public static void main(String[] args) {
        new OrderMateLauncher();
    }

    private OrderMateLauncher() {
        new LoggerSetupTask("OrderMateLauncher").run();
        this.io = new LauncherIO(this);
        OrderMate.LOG.info("Launching OrderMate Launcher");
        this.trayIcon = new TrayIcon(new ImageIcon(OrderMateLauncher.class.getResource("/ordermate/launcher/images/launcher_icon.png")).getImage(), "OrderMate Launcher");
        this.trayIcon.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                OrderMateLauncher.this.gui.showFrame();
            }
        });
        this.trayIcon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrderMateLauncher.this.gui.showFrame();
            }
        });
        SystemTray tray = SystemTray.getSystemTray();
        try {
            tray.add(this.trayIcon);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot add tray icon to the system tray!", (Throwable)ex);
        }
        this.config = new LauncherConfig();
        this.config.readFromDisk();
        this.gui = new LauncherGui(this);
        this.launchMap = new LinkedHashMap<Application, LaunchProcess>();
        if (this.loadFromStartup) {
            if (this.config.getApps().isEmpty()) {
                OrderMate.LOG.info("No apps to auto-launch");
            } else {
                for (Application app : this.config.getApps()) {
                    if (Application.Officemate.equals((Object)app)) continue;
                    if (Application.Servermate.equals((Object)app)) {
                        OrderMate.LOG.info("Auto-Launching ServerMate in " + this.config.getServermateDelay());
                        this.doLaunch(this.config.getServermateDelay(), Application.Servermate);
                        continue;
                    }
                    OrderMate.LOG.info("Auto-Launching in " + this.config.getOthermateDelay());
                    this.doLaunch(this.config.getOthermateDelay(), app);
                }
            }
        }
    }

    List<Application> getApplicationsToLaunch() {
        return this.config.getApps();
    }

    void launch(String name) {
        this.launch(name, 0L);
    }

    void launch(String name, long delay) {
        Application app = Application.valueOf(name);
        if (app != null) {
            this.doLaunch(delay, app);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLaunch(long delay, Application app) {
        OrderMateLauncher orderMateLauncher = this;
        synchronized (orderMateLauncher) {
            this.launchMap.put(app, new LaunchProcess(app, System.currentTimeMillis() + delay, delay, this.config));
            if (this.timer == null) {
                this.timer = new Timer(1000, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        OrderMateLauncher.this.countDown();
                    }
                });
                this.timer.start();
            } else {
                this.timer.start();
            }
        }
        this.gui.hideFrame();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void countDown() {
        ArrayList<LaunchProcess> launches;
        OrderMateLauncher orderMateLauncher = this;
        synchronized (orderMateLauncher) {
            launches = new ArrayList<LaunchProcess>(this.launchMap.values());
            if (launches.isEmpty()) {
                OrderMate.LOG.info("Stopping countdown, nothing left to launch");
                this.timer.stop();
                return;
            }
        }
        StringBuilder SB = new StringBuilder("Launching: \r\n");
        long now = System.currentTimeMillis();
        for (LaunchProcess process : launches) {
            SB.append("- ").append(process.app.name());
            if (process.time <= now) {
                if (LaunchProcess.LaunchState.Countdown.equals((Object)process.state)) {
                    SB.append(" now...");
                    final LaunchProcess finalProcess = process;
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            finalProcess.performLaunch();
                        }
                    }).start();
                } else {
                    if (LaunchProcess.LaunchState.Launching.equals((Object)process.state)) {
                        SB.append(" launching...");
                    } else if (LaunchProcess.LaunchState.LiftOff.equals((Object)process.state)) {
                        SB.append(" launched!");
                    } else {
                        SB.append(" failed!");
                    }
                    if (process.attempts > 1) {
                        SB.append(" Attempts: ").append(process.attempts);
                    }
                    if (now - process.time > 10000L) {
                        if (LaunchProcess.LaunchState.LiftOff.equals((Object)process.state)) {
                            this.launchMap.remove((Object)process.app);
                        } else if (process.retryDelay > 1L && process.attempts < 20) {
                            process.state = LaunchProcess.LaunchState.Countdown;
                            ++process.attempts;
                            process.time = System.currentTimeMillis() + process.retryDelay;
                        }
                    }
                    OrderMate.LOG.info(SB.toString());
                }
            } else {
                SB.append(" in ").append((int)((process.time - now) / 1000L));
            }
            SB.append("\r\n");
        }
        this.trayIcon.displayMessage("OrderMate Launcher", SB.toString(), TrayIcon.MessageType.INFO);
    }

    public void hideFrame() {
        this.gui.hideFrame();
    }

    public LauncherConfig getConfig() {
        return this.config;
    }

    public void showFrame() {
        this.gui.showFrame();
    }

    public void exit() {
        OrderMate.LOG.info("Exiting OrderMate Launcher");
        if (this.io != null) {
            this.io.close();
        }
        System.exit(0);
    }
}

