/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.networkio.NotificationDetails;
import au.com.ordermate.simplermi.SimpleRMI;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import javax.swing.SwingUtilities;
import ordermate.OrderMate;
import ordermate.database.docket.AbstractDocket;
import ordermate.database.hardware.physical.kts.KTSDocketPrinterNetwork;
import ordermate.database.hardware.physical.kts.KTSDocketState;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.Account;
import ordermate.startup.OrderMateSetupException;
import sun.awt.AppContext;
import sun.awt.SunToolkit;
import utils.ktsmate.KTSMate;
import utils.ktsmate.docket.IncomingDocketBay;
import utils.ktsmate.docket.KTSDocket;
import utils.ktsmate.docket.KTSListController;

class KTSDocketPrinterNetworkImpl
extends UnicastRemoteObject
implements KTSDocketPrinterNetwork {
    private IncomingDocketBay docketBay;
    private KTSListController controller;
    private String printerName;

    KTSDocketPrinterNetworkImpl() throws RemoteException {
    }

    void setDocketBay(IncomingDocketBay bay) {
        this.docketBay = bay;
    }

    void setListController(KTSListController listController) {
        this.controller = listController;
    }

    void setPrinterName(String printer) {
        this.printerName = printer;
    }

    void startupDocketPrinter() throws OrderMateSetupException {
        block5: {
            if (this.docketBay != null) {
                try {
                    if (this.printerName == null) {
                        SimpleRMI.shareObject((Remote)this, (String)"Kitchen Touch Screen Docket Printer");
                        break block5;
                    }
                    if (!SimpleRMI.isSharingObject((String)this.printerName)) {
                        SimpleRMI.shareObject((Remote)this, (String)this.printerName);
                        break block5;
                    }
                    OrderMateSetupException bob = new OrderMateSetupException(null, "Another instance of " + this.printerName + " is already running! ", "Please close it before attempting to run another.", (Throwable)null, true);
                    throw bob;
                }
                catch (RemoteException ex) {
                    OrderMateLog.LOG.warn("RemoteException when sharing KTSDocketPrinterImpl.", (Throwable)ex);
                }
            }
        }
    }

    public void doPrint(AbstractDocket docket, NotificationDetails details) throws RemoteException {
        if (this.docketBay == null) {
            OrderMateLog.LOG.error("Cannot print if the incoming docket bay hasn't been set");
        } else {
            this.docketBay.doPrint(docket, details);
        }
    }

    public void changeDocketState(Account account, KTSDocketState oldState, KTSDocketState newState) throws RemoteException {
        if (this.controller != null) {
            StringBuilder SB = new StringBuilder("Moving dockets for ");
            SB.append(account.getID()).append(" from ");
            SB.append(oldState == null ? "Any" : oldState.name());
            SB.append(" to ").append(newState.name());
            OrderMate.LOG.info(SB.toString());
            if (oldState == null) {
                for (KTSDocketState nextState : KTSDocketState.values()) {
                    this.changeDocketsForAccount(account, nextState, newState);
                }
            } else {
                this.changeDocketsForAccount(account, oldState, newState);
            }
        } else {
            OrderMate.LOG.warn("No Controller set, cannot move dockets for " + account.getID());
        }
    }

    private int getChangeStateMoveToPosition() {
        int position = 0;
        if (SystemProperty.getInstance().isKtsUnholdToEndOfQueue()) {
            position = Integer.MAX_VALUE;
        }
        return position;
    }

    private void changeDocketsForAccount(Account account, KTSDocketState oldState, final KTSDocketState newState) {
        if (!oldState.equals((Object)newState)) {
            final int position = this.getChangeStateMoveToPosition();
            for (final KTSDocket nextDocket : this.controller.getDocketList(oldState)) {
                Account relevantAccount = nextDocket.getTargetAccount();
                if (relevantAccount == null) {
                    relevantAccount = nextDocket.getAccount();
                }
                if (!relevantAccount.getID().equals(account.getID())) continue;
                if (AppContext.getAppContext() == null || !SwingUtilities.isEventDispatchThread()) {
                    if (KTSMate.getAppContext() != null) {
                        SunToolkit.invokeLaterOnAppContext(KTSMate.getAppContext(), new Runnable(){

                            @Override
                            public void run() {
                                KTSDocketPrinterNetworkImpl.this.controller.changeDocketState(nextDocket, newState, position);
                            }
                        });
                        continue;
                    }
                    this.controller.changeDocketState(nextDocket, newState, position);
                    continue;
                }
                this.controller.changeDocketState(nextDocket, newState, position);
            }
        }
    }
}

