/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate;

import au.com.ordermate.OMLogUtil;
import au.com.ordermate.OrderMateLog;
import au.com.ordermate.guicore.progress.VersionSplashWindow;
import au.com.ordermate.guicore.task.BasicTask;
import au.com.ordermate.guicore.task.CompositeTask;
import au.com.ordermate.guicore.task.ProgressLogger;
import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.persistence.PersistenceClientSetupTask;
import au.com.ordermate.util.IPAddressUtils;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import ordermate.OrderMate;
import ordermate.database.hardware.physical.kts.KTSDocketPrinter;
import ordermate.database.hardware.physical.kts.KTSDocketPrinterQueries;
import ordermate.database.hardware.physical.kts.KTSProperty;
import ordermate.database.hardware.physical.kts.KTSPropertyType;
import ordermate.gui.OrderMateThemeI;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.serverconnection.PropertiesServerCheckTask;
import ordermate.signals.StandardSignal;
import ordermate.startup.ConfigurationTask;
import ordermate.startup.DeadlockLog;
import ordermate.startup.InitExecuteTaskLocalService;
import ordermate.startup.InitRebootTerminalServiceTask;
import ordermate.startup.JavaVersionCheckSetupTask;
import ordermate.startup.ManagerStartupTask;
import ordermate.startup.MemoryLog;
import ordermate.startup.OrderMateSetupException;
import ordermate.startup.ServerConnectionSetupTask;
import ordermate.startup.TimeClientSetupTask;
import ordermate.startup.UniqueTask;
import ordermate.startup.runtime.JavaRuntimeCheckTask;
import org.jfree.util.Log;
import sun.awt.AppContext;
import utils.ktsmate.KTSMateIO;
import utils.ktsmate.StartupKTSPrinterTask;
import utils.ktsmate.docket.DefaultKTSListController;
import utils.ktsmate.gui.KTSCommandDespatch;
import utils.ktsmate.gui.KTSConnectionScreen;
import utils.ktsmate.gui.KTSFrame;
import utils.ktsmate.gui.KTSUIHelper;
import utils.ktsmate.schedule.KTSScheduleAndCleanTask;
import utils.ktsmate.startup.CreateDocketDataProcessorTask;
import utils.ktsmate.startup.CreateMilestonesTask;
import utils.ktsmate.startup.EnsurePrinterAvailableTask;
import utils.ktsmate.startup.KTSConfigureRMITask;
import utils.ktsmate.startup.KTSJettyTask;
import utils.ktsmate.startup.KTSPrinterPortRangeRMIStartupTask;
import utils.ktsmate.startup.KTSRMIPortUpdateTask;
import utils.ktsmate.startup.KTSWebDependenciesTask;
import utils.ktsmate.startup.MakeKTSFrameTask;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.startup.LaFSetupTask;

public class KTSMate {
    public static final String PRODUCT_NAME = "TouchPrep XPress";
    public static final String TERMINAL_NAME = "KTS_PRINTER";
    public static final String DOCKET_LOCATION = "C:\\temp\\ktsmate\\";
    private static DefaultKTSListController listController;
    private static KTSMateIO io;
    private static KTSDocketPrinter printer;
    private static KTSFrame frame;
    private static KTSCommandDespatch commandDespatch;
    private static String user;
    private static final long MEMORY_CHECK_DELAY = 120000L;
    private static AppContext appContext;

    public static void main(String[] args) {
        user = System.getProperty("user.name");
        String identifier = "TouchPrep XPress-" + user;
        OMLogUtil.createRootLoggerWithParentDirectory((String)"KTSMate", (String)identifier);
        OrderMate.LOG.info("Starting TouchPrep XPress " + OrderMate.VERSION);
        OrderMateThemeI.Helper.setTheme((OrderMateThemeI)new OrderMateTheme());
        appContext = AppContext.getAppContext();
        StandardSignal.setAppContext((AppContext)appContext);
        CompositeTask startup = new CompositeTask("Starting TouchPrep XPress");
        ManagerStartupTask managerTask = new ManagerStartupTask("TouchPrep XPress Terminal");
        ConfigurationTask config = new ConfigurationTask("KTSMateConfig.ini");
        startup.addTask((Task)config);
        startup.addTask((Task)new KTSConfigureRMITask());
        startup.addTask((Task)new JavaVersionCheckSetupTask());
        startup.addTask((Task)new MemoryLog(identifier, 120000L));
        startup.addTask((Task)new DeadlockLog(identifier));
        startup.addTask((Task)new LaFSetupTask());
        startup.addTask((Task)new ServerConnectionSetupTask(KTSConnectionScreen.class, null, true));
        startup.addTask((Task)new EnsurePrinterAvailableTask());
        startup.addTask((Task)new KTSPrinterPortRangeRMIStartupTask().setUniqueTask(new UniqueTask(identifier, user, OrderMate.KTSMATE_RMI_PORTS)));
        startup.addTask((Task)new PersistenceClientSetupTask(false, 0));
        startup.addTask((Task)managerTask);
        startup.addTask((Task)new PropertiesServerCheckTask());
        startup.addTask((Task)new KTSRMIPortUpdateTask());
        startup.addTask((Task)new StartupKTSPrinterTask());
        startup.addTask((Task)new JavaRuntimeCheckTask(PRODUCT_NAME));
        startup.addTask((Task)new CreateMilestonesTask());
        startup.addTask((Task)new CreateDocketDataProcessorTask());
        startup.addTask((Task)new TimeClientSetupTask());
        startup.addTask((Task)new KTSWebDependenciesTask());
        startup.addTask((Task)new KTSJettyTask());
        startup.addTask((Task)new MakeKTSFrameTask());
        startup.addTask((Task)new InitRebootTerminalServiceTask());
        startup.addTask((Task)new InitExecuteTaskLocalService());
        startup.addTask((Task)new BasicTask("Scheduling Docket Cleaner", 0, (Runnable)new KTSScheduleAndCleanTask()));
        startup.taskStarted.connect((Object)new ProgressLogger(), "logProgress");
        VersionSplashWindow splash = KTSMate.createSplashWindow(startup);
        try {
            while (!startup.hasRun()) {
                try {
                    startup.runLocal();
                }
                catch (OrderMateSetupException omEx) {
                    KTSMate.handleOrderMateStartupError(omEx);
                    startup.removeTask(omEx.getFailedTask());
                }
            }
        }
        catch (Exception ex) {
            KTSMate.handleStartupError(ex);
        }
        splash.dispose();
    }

    private static VersionSplashWindow createSplashWindow(final CompositeTask startup) {
        final AtomicReference splashRef = new AtomicReference();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    VersionSplashWindow theSplashFrame = new VersionSplashWindow(startup.getTotalSubTasks() + 1, OrderMate.VERSION, KTSMate.PRODUCT_NAME);
                    startup.progress.connect((Object)theSplashFrame, "setProgress");
                    startup.statusMessage.connect((Object)theSplashFrame, "setMessage");
                    startup.taskStarted.connect((Object)theSplashFrame, "setMessage");
                    splashRef.set(theSplashFrame);
                    theSplashFrame.startSplashScreen();
                }
            });
        }
        catch (Exception ex) {
            throw new OrderMateSetupException((Task)startup, "Error displaying splash screen", new String[]{"Tap outside of the splash screen", "Call OrderMate Technical Support"}, false);
        }
        return (VersionSplashWindow)splashRef.get();
    }

    public static final DefaultKTSListController getListController() {
        if (listController == null) {
            KTSMate.getIOPath();
        }
        return listController;
    }

    public static void setPolicy() {
        if (listController == null) {
            return;
        }
        KTSProperty transfersPolicy = KTSUIHelper.getInstance().getPropertyFor("Transfer Docket", KTSPropertyType.Show);
        KTSProperty deletionsPolicy = KTSUIHelper.getInstance().getPropertyFor("Delete Docket", KTSPropertyType.Show);
        if (transfersPolicy != null) {
            listController.setTransfersPolicy(DefaultKTSListController.DocketPolicy.safeValue(transfersPolicy.getValue()));
        }
        if (deletionsPolicy != null) {
            listController.setDeletionsPolicy(DefaultKTSListController.DocketPolicy.safeValue(deletionsPolicy.getValue()));
        }
    }

    public static final KTSMateIO getIO() {
        if (io == null) {
            KTSMate.getIOPath();
        }
        return io;
    }

    public static final KTSDocketPrinter getLocalPrinter() {
        if (printer == null) {
            KTSDocketPrinter firstPrinter;
            String userName = System.getProperty("user.name");
            List<KTSDocketPrinter> localPrinters = KTSMate.getLocalPrinters();
            for (KTSDocketPrinter prt : localPrinters) {
                if (!userName.equalsIgnoreCase(prt.getUserName())) continue;
                printer = prt;
            }
            if (printer == null && localPrinters.size() == 1 && ((firstPrinter = localPrinters.get(0)).getUserName() == null || firstPrinter.getUserName().isEmpty())) {
                printer = firstPrinter;
            }
        }
        return printer;
    }

    public static List<KTSDocketPrinter> getLocalPrinters() {
        return KTSDocketPrinterQueries.getKTSPrintersForAddress((List)IPAddressUtils.getLocalAddresses(), (boolean)true);
    }

    private static void getIOPath() {
        if (printer == null) {
            KTSMate.getLocalPrinter();
        }
        StringBuilder sb = new StringBuilder(DOCKET_LOCATION);
        if (printer != null && printer.getUserName() != null && !printer.getUserName().isEmpty()) {
            String userName = printer.getUserName().replace(" ", "");
            sb.append(userName).append("\\");
        }
        OrderMate.LOG.info("DOCKET_LOCATION:" + sb.toString());
        io = KTSMateIO.getInstance(sb.toString());
        listController = DefaultKTSListController.getInstance(io);
    }

    public static final void refreshPrinter() {
        printer = null;
        KTSMate.getLocalPrinter();
        KTSUIHelper.reinitialise();
        KTSMate.setPolicy();
    }

    private static final void handleOrderMateStartupError(final OrderMateSetupException ex) {
        try {
            if (ex.isFatal()) {
                OrderMate.LOG.error("Fatal ordermate error in startup", (Throwable)ex);
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        Dialogs.displayOkDialog(ex.getHTMLMessage(), "Startup Error");
                        System.exit(-1);
                    }
                });
            } else {
                OrderMateLog.LOG.warn("Non-fatal error starting up, will continue", (Throwable)ex);
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        if (!Dialogs.displayChoiceDialog(ex.getHTMLMessage(), "Continue startup?", "Yes", "No", true)) {
                            OrderMate.LOG.warn("User chose not to continue startup");
                            System.exit(-1);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            Log.error((Object)"Error handling exception, rethrowing original", (Exception)e);
            throw new RuntimeException("Fatal runtime error when handling exception", ex);
        }
    }

    private static final void handleStartupError(final Exception ex) {
        OrderMateLog.LOG.error("Error starting up KTS:", (Throwable)ex);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(null, "An error has occurred during startup of KTSMate.\n" + ex);
                System.exit(0);
            }
        });
    }

    public static synchronized KTSFrame getFrame() {
        if (frame == null) {
            commandDespatch = new KTSCommandDespatch();
            if (SwingUtilities.isEventDispatchThread()) {
                frame = new KTSFrame();
            } else {
                throw new IllegalStateException("Must be called from EDT");
            }
        }
        return frame;
    }

    public static KTSCommandDespatch getKtsCommand() {
        return commandDespatch;
    }

    public static AppContext getAppContext() {
        return appContext;
    }

    protected static void setAppContext(AppContext context) {
        appContext = context;
    }
}

