/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.serialization.IOReferenceStrategy;
import au.com.ordermate.serialization.IdentifierGenerator;
import au.com.ordermate.serialization.ObjectResolver;
import au.com.ordermate.serialization.PersistentObjectReferenceStrategy;
import au.com.ordermate.serialization.PosDBIdentifierGenerator;
import au.com.ordermate.serialization.PropertiedObjectIO;
import ca.odell.glazedlists.EventList;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.database.PersistentObjectResolver;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.hardware.physical.kts.KTSDocketState;
import utils.ktsmate.docket.KTSDocket;
import utils.ktsmate.docket.KTSListController;
import waitermate.guikit.dialogs.Dialogs;

public class KTSMateIO {
    private static final String DOCKET_SUFFIX = ".dkt";
    private static final String LIST_SUFFIX = ".lst";
    private final String mainDir;
    private final PropertiedObjectIO<KTSDocket> io;
    private static KTSMateIO instance = null;
    private final String ktsLegacyExpFeature = "KTS Dockets Legacy";
    private static boolean legacyLoad = false;

    private KTSMateIO(String directory) {
        ExperimentalFeature feature;
        this.mainDir = directory;
        File dir = new File(this.mainDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        legacyLoad = (feature = ExperimentalFeature.find((String)"KTS Dockets Legacy")) != null && feature.getBooleanValue(Boolean.valueOf(false)) != false;
        this.io = new PropertiedObjectIO<KTSDocket>(){

            protected IdentifierGenerator createIdentifierGenerator() {
                return new PosDBIdentifierGenerator();
            }
        };
        this.io.setObjResolver((ObjectResolver)new PersistentObjectResolver());
        this.io.setReferenceStrategy((IOReferenceStrategy)new PersistentObjectReferenceStrategy(this.io));
    }

    public static KTSMateIO getInstance(String directory) {
        if (instance == null) {
            instance = new KTSMateIO(directory);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDocket(KTSDocket docket) {
        KTSDocket clone;
        if (legacyLoad) {
            this.saveDocketLegacy(docket);
            return;
        }
        KTSDocket kTSDocket = docket;
        synchronized (kTSDocket) {
            clone = new KTSDocket(docket);
        }
        StringBuilder SB = new StringBuilder(this.mainDir).append(clone.getId()).append(DOCKET_SUFFIX);
        File toWrite = new File(SB.toString());
        if (!toWrite.exists()) {
            try {
                toWrite.createNewFile();
            }
            catch (IOException ex) {
                OrderMateLog.LOG.warn("Unable to create file for KTSDocket :" + toWrite.toString(), (Throwable)ex);
            }
        }
        if (toWrite.canWrite()) {
            try {
                FileOutputStream output = new FileOutputStream(toWrite);
                this.io.writeOut((Object)docket, (OutputStream)output);
                output.flush();
                output.close();
            }
            catch (IOException ex) {
                OrderMateLog.LOG.warn("IO Problem writing the KTSDocket to the disk.", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KTSDocket loadDocket(int id) {
        if (legacyLoad) {
            return this.loadDocketLegacy(id);
        }
        KTSDocket readDocket = null;
        StringBuilder SB = new StringBuilder(this.mainDir).append(id).append(DOCKET_SUFFIX);
        File toRead = new File(SB.toString());
        FileInputStream fin = null;
        if (toRead.canRead()) {
            try {
                fin = new FileInputStream(toRead);
                readDocket = (KTSDocket)this.io.readIn((InputStream)fin);
                if (readDocket.getAccount() == null) {
                    readDocket = null;
                }
            }
            catch (Exception ex) {
                readDocket = null;
                OrderMateLog.LOG.warn("IO Problem while reading in the KTSDocket.", (Throwable)ex);
            }
            finally {
                try {
                    if (fin != null) {
                        fin.close();
                    }
                }
                catch (IOException ex) {
                    OrderMateLog.LOG.warn("Simply couldn't close off KTSDocket file when reading.", (Throwable)ex);
                }
            }
        }
        return readDocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void saveDocketLegacy(KTSDocket docket) {
        KTSDocket clone;
        KTSDocket kTSDocket = docket;
        synchronized (kTSDocket) {
            clone = new KTSDocket(docket);
        }
        StringBuilder SB = new StringBuilder(this.mainDir).append(clone.getId()).append(DOCKET_SUFFIX);
        File toWrite = new File(SB.toString());
        if (!toWrite.exists()) {
            try {
                toWrite.createNewFile();
            }
            catch (IOException ex) {
                OrderMateLog.LOG.warn("Unable to create file for KTSDocket :" + toWrite.toString(), (Throwable)ex);
            }
        }
        if (toWrite.canWrite()) {
            try {
                FileOutputStream fout = new FileOutputStream(toWrite, false);
                ObjectOutputStream out = new ObjectOutputStream(fout);
                out.writeObject(clone);
                out.flush();
                out.close();
            }
            catch (IOException ex) {
                OrderMateLog.LOG.warn("IO Problem writing the KTSDocket to the disk.", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    KTSDocket loadDocketLegacy(int id) {
        KTSDocket readDocket = null;
        StringBuilder SB = new StringBuilder(this.mainDir).append(id).append(DOCKET_SUFFIX);
        File toRead = new File(SB.toString());
        if (toRead.canRead()) {
            ObjectInputStream in = null;
            try {
                FileInputStream fin = new FileInputStream(toRead);
                in = new ObjectInputStream(fin);
                readDocket = (KTSDocket)in.readObject();
            }
            catch (IOException ex) {
                readDocket = null;
                OrderMateLog.LOG.warn("IO Problem while reading in the KTSDocket.", (Throwable)ex);
            }
            catch (ClassNotFoundException ex) {
                readDocket = null;
                OrderMateLog.LOG.warn("Class Not Found while reading in the KTSDocket.", (Throwable)ex);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ex) {
                    OrderMateLog.LOG.warn("Simply couldn't close off KTSDocket file when reading.", (Throwable)ex);
                }
            }
        }
        return readDocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveList(KTSListController listController, KTSDocketState state) {
        StringBuilder SB = new StringBuilder(this.mainDir).append(state.toString()).append(LIST_SUFFIX);
        File toWrite = new File(SB.toString());
        if (!toWrite.exists()) {
            try {
                toWrite.createNewFile();
            }
            catch (IOException ex) {
                OrderMateLog.LOG.warn("Unable to create file for KTSDocketList Meta-data :" + toWrite.toString(), (Throwable)ex);
            }
        }
        if (toWrite.canWrite()) {
            EventList<KTSDocket> docketList = null;
            try {
                FileOutputStream fout = new FileOutputStream(toWrite, false);
                DataOutputStream out = new DataOutputStream(fout);
                docketList = listController.getDocketList(state);
                docketList.getReadWriteLock().writeLock().lock();
                out.writeInt(docketList.size());
                for (KTSDocket nextDocket : docketList) {
                    out.writeInt(nextDocket.getId());
                }
                out.flush();
                out.close();
            }
            catch (IOException ex) {
                OrderMateLog.LOG.warn("IO Problem writing the KTSDocketList meta-info.", (Throwable)ex);
            }
            finally {
                if (docketList != null) {
                    docketList.getReadWriteLock().writeLock().unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadListForState(KTSListController listController, KTSDocketState state) {
        StringBuilder SB = new StringBuilder(this.mainDir).append(state).append(LIST_SUFFIX);
        File toRead = new File(SB.toString());
        int[] docketIds = null;
        ArrayList<KTSDocket> dockets = null;
        if (toRead.canRead()) {
            FilterInputStream in = null;
            try {
                FileInputStream fin = new FileInputStream(toRead);
                in = new DataInputStream(fin);
                int size = ((DataInputStream)in).readInt();
                docketIds = new int[size];
                for (int i = 0; i < size; ++i) {
                    docketIds[i] = ((DataInputStream)in).readInt();
                }
            }
            catch (IOException ex) {
                OrderMateLog.LOG.warn("IO Problem reading the KTSDocketList meta-info.", (Throwable)ex);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ex) {
                        OrderMateLog.LOG.warn("Couldn't close off KTSDocketList meta-data.", (Throwable)ex);
                    }
                }
            }
        }
        if (docketIds != null) {
            dockets = new ArrayList<KTSDocket>(docketIds.length);
            HashMap<String, Exception> exceptionMap = new HashMap<String, Exception>();
            for (int nextId : docketIds) {
                try {
                    KTSDocket docket = this.loadDocket(nextId);
                    if (docket != null) {
                        dockets.add(docket);
                    }
                }
                catch (Exception ex) {
                    OrderMate.LOG.error("Exception loading docket from file for :" + state, (Throwable)ex);
                    exceptionMap.put(ex.getMessage(), ex);
                }
                if (exceptionMap.isEmpty()) continue;
                Dialogs.displayOkDialog(this.formatExceptionMessage(exceptionMap, state.name()), "Error loading dockets");
            }
            Object object = dockets.iterator();
            while (object.hasNext()) {
                KTSDocket nextDocket = (KTSDocket)object.next();
                listController.addDocket(nextDocket);
            }
        }
    }

    protected String formatExceptionMessage(Map<String, Exception> exceptionMap, String stateName) {
        if (!exceptionMap.isEmpty()) {
            String msg = "<HTML>There were errors loading the dockets for " + stateName + ":<UL>";
            for (String exMsag : exceptionMap.keySet()) {
                msg = msg + "<LI>" + exMsag + "</LI>";
            }
            msg = msg + "<UL>Contact OrderMate Support.";
            return msg;
        }
        return "";
    }

    public void deleteDocket(KTSDocket docket) {
        StringBuilder SB = new StringBuilder(this.mainDir).append(docket.getId()).append(DOCKET_SUFFIX);
        File toDelete = new File(SB.toString());
        if (toDelete.exists()) {
            if (!toDelete.delete()) {
                OrderMateLog.LOG.warn("Couldn't delete docket file:" + toDelete);
            } else {
                OrderMateLog.LOG.info("Successfully removed docket file:" + toDelete);
            }
        }
    }

    public String getMainDir() {
        return this.mainDir;
    }
}

