/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate;

import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.guikit.NavBar;

public class KTSNavBar
extends NavBar {
    public Signal goNext = Signals.createSignal();
    public Signal goPrevious = Signals.createSignal();
    public Signal toStart = Signals.createSignal();
    public Signal toEnd = Signals.createSignal();
    private JButton nextPageButton;
    private JButton previousPageButton;
    private JLabel pageLabel;
    private JButton toStartButton;
    private JButton toEndButton;

    public KTSNavBar() {
        this.setupNav();
    }

    protected void setupNav() {
        this.nextPageButton = this.constructButton((Icon)IconLoader.get((String)"/utils/ktsmate/images/next.png"), "Next Page", "nextPageButton", this.goNext);
        this.previousPageButton = this.constructButton((Icon)IconLoader.get((String)"/utils/ktsmate/images/previous.png"), "Previous Page", "previousPageButton", this.goPrevious);
        this.pageLabel = new JLabel("No Dockets");
        this.pageLabel.setHorizontalAlignment(0);
        JPanel pagePanel = new JPanel(new BorderLayout());
        pagePanel.add((Component)this.previousPageButton, "West");
        pagePanel.add((Component)this.pageLabel, "Center");
        pagePanel.add((Component)this.nextPageButton, "East");
        this.addRight(pagePanel);
        this.toStartButton = this.constructButton((Icon)IconLoader.get((String)"/utils/ktsmate/images/toStart.png"), "Send To Start", "sendToStart", this.toStart);
        this.toEndButton = this.constructButton((Icon)IconLoader.get((String)"/utils/ktsmate/images/toEnd.png"), "Send To End", "sendToEnd", this.toEnd);
        this.toStartButton.setEnabled(false);
        this.toEndButton.setEnabled(false);
        this.addLeft(this.toStartButton);
        this.addLeft(this.toEndButton);
    }

    public void setIndexInfo(final int firstDocketIndex, final int lastDocketIndex, final int total) {
        StringBuilder SB = new StringBuilder();
        if (total == 0) {
            SB.append("No Dockets");
        } else {
            SB.append(firstDocketIndex + 1).append("-").append(lastDocketIndex + 1).append(" of ").append(total);
        }
        final String text = SB.toString();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                KTSNavBar.this.pageLabel.setText(text);
                KTSNavBar.this.nextPageButton.setEnabled(lastDocketIndex < total - 1);
                KTSNavBar.this.previousPageButton.setEnabled(firstDocketIndex > 0);
            }
        });
    }

    public void setFastMovesEnabled(boolean value) {
        this.toStartButton.setEnabled(value);
        this.toEndButton.setEnabled(value);
    }

    public JButton getNextButton() {
        return this.nextPageButton;
    }

    public JButton getPreviousButton() {
        return this.previousPageButton;
    }
}

