/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.configuration.Config;
import au.com.ordermate.guicore.task.AbstractTask;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.List;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.kts.KTSDocketPrinter;
import ordermate.database.hardware.physical.kts.KTSDocketState;
import utils.ktsmate.KTSDocketPrinterNetworkImpl;
import utils.ktsmate.KTSMate;
import utils.ktsmate.KTSMateIO;
import utils.ktsmate.docket.DefaultKTSListController;
import utils.ktsmate.docket.IncomingDocketBay;

public class StartupKTSPrinterTask
extends AbstractTask {
    private DefaultKTSListController listController;
    private KTSMateIO io;

    public String getName() {
        return "Starting Docket Printer";
    }

    protected void performTask() throws Exception {
        this.io = KTSMate.getIO();
        this.listController = KTSMate.getListController();
        List servers = Config.getStringListValue((String)"app_server");
        for (KTSDocketState[] server : servers) {
            try {
                Terminal.setupServerMate((String)server);
                break;
            }
            catch (UnknownHostException ex) {
                OrderMateLog.LOG.error("UnknownHost when searching setting Servermate Terminal:" + (String)server, (Throwable)ex);
            }
        }
        this.emitProgress();
        IncomingDocketBay incomingBay = new IncomingDocketBay(this.listController);
        for (KTSDocketState nextState : KTSDocketState.values()) {
            this.io.loadListForState(this.listController, nextState);
        }
        this.emitProgress();
        try {
            KTSDocketPrinter printer = KTSMate.getLocalPrinter();
            KTSDocketPrinterNetworkImpl impl = new KTSDocketPrinterNetworkImpl();
            impl.setDocketBay(incomingBay);
            impl.setListController(this.listController);
            if (printer != null) {
                impl.setPrinterName(printer.getLabel());
            }
            impl.startupDocketPrinter();
        }
        catch (RemoteException ex) {
            OrderMateLog.LOG.error("Cannot instantiate Remote implementation of KTSDocketPrinter.", (Throwable)ex);
            System.exit(1);
        }
        this.emitProgress();
    }

    protected int getTotalSubTasks() {
        return 3;
    }
}

