/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.docket;

import java.util.Timer;
import java.util.TimerTask;
import ordermate.database.hardware.physical.kts.KTSDocketState;
import utils.ktsmate.KTSMate;
import utils.ktsmate.KTSMateIO;
import utils.ktsmate.docket.KTSDocket;
import utils.ktsmate.docket.KTSDocketController;
import utils.ktsmate.docket.KTSListController;
import utils.ktsmate.docket.line.KTSLine;

public class DefaultKTSDocketController
implements KTSDocketController {
    private KTSDocket myDocket;
    private Timer autoCloseTimer;
    private KTSListController listController;
    private KTSMateIO myIO;

    public DefaultKTSDocketController(KTSDocket docket, KTSListController theListController, KTSMateIO yourIO) {
        this.myDocket = docket;
        this.listController = theListController;
        this.myIO = yourIO;
    }

    @Override
    public void bumpDocket() {
        if (this.myDocket.getDocketState().equals((Object)KTSDocketState.Live)) {
            this.listController.changeDocketState(this.myDocket, KTSDocketState.Bump, 0);
        }
    }

    @Override
    public void holdDocket() {
        if (this.myDocket.getDocketState().equals((Object)KTSDocketState.Live)) {
            this.listController.changeDocketState(this.myDocket, KTSDocketState.Hold, Integer.MAX_VALUE);
        }
    }

    @Override
    public void lineTapped(KTSLine line) {
        if (this.autoCloseTimer != null) {
            this.autoCloseTimer.cancel();
            this.autoCloseTimer = null;
        }
        this.toggleLineCompletion(line);
        if (this.listController.getDocketList(this.myDocket.getDocketState()) != null) {
            this.listController.changeDocketState(this.myDocket, this.myDocket.getDocketState(), this.listController.getDocketList(this.myDocket.getDocketState()).indexOf((Object)this.myDocket));
        }
        this.checkIfAllComplete();
    }

    private void toggleLineCompletion(KTSLine line) {
        line.setComplete(!line.isComplete());
        if (this.myIO != null) {
            this.myIO.saveDocket(this.myDocket);
        }
    }

    private void checkIfAllComplete() {
        int autoCloseTime;
        boolean docketIsComplete = true;
        for (KTSLine kTSLine : this.myDocket.getSummaryLines()) {
            docketIsComplete = docketIsComplete && kTSLine.isComplete();
        }
        if (docketIsComplete && (autoCloseTime = KTSMate.getLocalPrinter().getAutoCloseTime()) > 0) {
            this.autoCloseTimer = new Timer();
            this.autoCloseTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    DefaultKTSDocketController.this.bumpDocket();
                }
            }, autoCloseTime * 1000);
        }
    }
}

