/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.docket;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.DateTimeUtils;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ordermate.OrderMate;
import ordermate.database.hardware.physical.kts.KTSDocketState;
import ordermate.database.sales.Account;
import utils.ktsmate.KTSMate;
import utils.ktsmate.KTSMateIO;
import utils.ktsmate.docket.DefaultKTSDocketController;
import utils.ktsmate.docket.KTSDocket;
import utils.ktsmate.docket.KTSDocketController;
import utils.ktsmate.docket.KTSDocketControllerVendor;
import utils.ktsmate.docket.KTSDocketStateEvent;
import utils.ktsmate.docket.KTSDocketStateListener;
import utils.ktsmate.docket.KTSListController;
import utils.ktsmate.docket.line.SummaryLine;

public class DefaultKTSListController
implements KTSListController,
KTSDocketControllerVendor {
    private final Map<KTSDocketState, EventList<KTSDocket>> docketListMap;
    private final Map<KTSDocketState, Set<KTSDocket>> rushedMap;
    private final Map<KTSDocket, KTSDocketController> controllerMap;
    private int STALE_DAYS = -7;
    private int currentId = 0;
    private KTSMateIO myIO;
    private List<KTSDocketStateListener> stateListenerList;
    private boolean rushable;
    private static DefaultKTSListController instance = null;
    private DocketPolicy transferPolicy;
    private DocketPolicy deletionPolicy;

    public static DefaultKTSListController getInstance(KTSMateIO yourIO) {
        if (instance == null) {
            instance = new DefaultKTSListController(yourIO);
        }
        return instance;
    }

    private DefaultKTSListController(KTSMateIO yourIO) {
        this.myIO = yourIO;
        this.rushable = KTSMate.getLocalPrinter() != null ? KTSMate.getLocalPrinter().isRushable() : false;
        this.rushedMap = new HashMap<KTSDocketState, Set<KTSDocket>>();
        this.docketListMap = new HashMap<KTSDocketState, EventList<KTSDocket>>();
        for (KTSDocketState nextState : KTSDocketState.values()) {
            this.docketListMap.put(nextState, (EventList<KTSDocket>)new BasicEventList());
            this.rushedMap.put(nextState, new HashSet());
        }
        this.controllerMap = new HashMap<KTSDocket, KTSDocketController>();
    }

    @Override
    public EventList<KTSDocket> getDocketList(KTSDocketState state) {
        return this.docketListMap.get(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeDocketState(KTSDocket docket, KTSDocketState newState, int position) {
        if (docket == null) {
            throw new IllegalArgumentException("Cannot set a null docket when changing state.");
        }
        if (newState == null) {
            throw new IllegalArgumentException("Cannot set a docket's state to null.");
        }
        KTSDocketState currentState = docket.getDocketState();
        if (currentState.equals((Object)KTSDocketState.Bump) && newState.equals((Object)KTSDocketState.Hold)) {
            OrderMate.LOG.warn("Cannot transfer a docket directly from Bump to Hold");
            return;
        }
        if (currentState.equals((Object)KTSDocketState.Hold) && newState.equals((Object)KTSDocketState.Bump)) {
            OrderMate.LOG.warn("Cannot transfer a docket directly from Hold to Bump");
            return;
        }
        OrderMate.LOG.info("Setting Docket's state to " + currentState + " from " + newState);
        EventList<KTSDocket> oldList = this.docketListMap.get(currentState);
        oldList.getReadWriteLock().writeLock().lock();
        this.rushedChanged(docket, currentState, false);
        oldList.remove((Object)docket);
        oldList.getReadWriteLock().writeLock().unlock();
        KTSDocket kTSDocket = docket;
        synchronized (kTSDocket) {
            OrderMate.LOG.info("Saving docket " + docket.getId());
            docket.setDocketState(newState);
            docket.markTime();
            this.myIO.saveDocket(docket);
        }
        EventList<KTSDocket> newList = this.docketListMap.get(newState);
        int index = Math.max(0, position);
        newList.getReadWriteLock().writeLock().lock();
        OrderMate.LOG.info("Adjusting index to " + index);
        index = this.adjustIndex(docket, index);
        index = Math.min(index, newList.size());
        newList.add(index, (Object)docket);
        this.rushedChanged(docket, newState, true);
        newList.getReadWriteLock().writeLock().unlock();
        this.myIO.saveList(this, currentState);
        this.myIO.saveList(this, newState);
        if (newState.equals((Object)KTSDocketState.Live)) {
            this.attachDocketController(docket);
        } else {
            this.removeDocketController(docket);
        }
        OrderMate.LOG.info("All done, firing docket state event");
        this.fireDocketStateEvent(docket, currentState, newState);
    }

    private void rushedChanged(KTSDocket docket, KTSDocketState state, boolean added) {
        if (this.rushable && docket.isRushed()) {
            if (!added) {
                this.rushedMap.get(state).remove(docket);
            } else if (!KTSDocketState.Bump.equals((Object)state)) {
                this.rushedMap.get(state).add(docket);
            }
        }
    }

    private int adjustIndex(KTSDocket docket, int desiredIndex) {
        if (this.rushable && !KTSDocketState.Bump.equals((Object)docket.getDocketState())) {
            if (docket.isRushed()) {
                return Math.min(desiredIndex, this.rushedMap.get(docket.getDocketState()).size());
            }
            return Math.max(desiredIndex, this.rushedMap.get(docket.getDocketState()).size());
        }
        return desiredIndex;
    }

    @Override
    public void addDocket(KTSDocket docket) {
        boolean isNew;
        if (docket == null) {
            throw new IllegalArgumentException("Cannot add a null docket to the list");
        }
        if (docket.getDocketState() == null) {
            throw new IllegalArgumentException("Cannot add a docket to a null state list.");
        }
        if (docket.getPrintableLines() == null || docket.getPrintableLines().size() == 0) {
            this.analyseNotifiers(docket);
            this.fireDocketStateEvent(docket, KTSDocketState.Live, KTSDocketState.Live);
            OrderMateLog.LOG.info("Throwing away docket with no items upon it.");
            return;
        }
        for (KTSDocketState state : KTSDocketState.values()) {
            EventList<KTSDocket> nextStateList = this.docketListMap.get(state);
            nextStateList.getReadWriteLock().writeLock().lock();
            if (nextStateList.contains((Object)docket)) {
                nextStateList.getReadWriteLock().writeLock().unlock();
                throw new IllegalArgumentException("Cannot add a docket that is already within a list.");
            }
            nextStateList.getReadWriteLock().writeLock().unlock();
        }
        boolean bl = isNew = docket.getId() == -1;
        if (isNew) {
            docket.setId(this.currentId);
            ++this.currentId;
            if (this.currentId == Integer.MAX_VALUE) {
                this.currentId = 0;
            }
            if (!this.analyseDocket(docket)) {
                OrderMate.LOG.info("Throwing away docket - failed analysis");
                return;
            }
            int index = this.getIndexFor(docket);
            this.changeDocketState(docket, docket.getDocketState(), index);
            OrderMateLog.LOG.info("Added new Docket to state " + docket.getDocketState());
        } else {
            if (docket.getId() >= this.currentId) {
                this.currentId = docket.getId() + 1;
            }
            this.changeDocketState(docket, docket.getDocketState(), Integer.MAX_VALUE);
            OrderMateLog.LOG.info("Added old Docket to state " + docket.getDocketState());
        }
        if (KTSDocketState.Live.equals((Object)docket.getDocketState())) {
            this.attachDocketController(docket);
        }
        this.fireDocketStateEvent(docket, null, docket.getDocketState());
    }

    private void attachDocketController(KTSDocket docket) {
        if (this.controllerMap.get(docket) == null) {
            DefaultKTSDocketController controller = new DefaultKTSDocketController(docket, this, this.myIO);
            this.controllerMap.put(docket, controller);
        }
    }

    private void removeDocketController(KTSDocket docket) {
        if (this.controllerMap.get(docket) != null) {
            this.controllerMap.remove(docket);
        }
    }

    @Override
    public KTSDocketController getControllerFor(KTSDocket docket) {
        return this.controllerMap.get(docket);
    }

    private int getIndexFor(KTSDocket docket) {
        int index = Integer.MAX_VALUE;
        List<SummaryLine<?>> lines = docket.getSummaryLines();
        if (lines == null || lines.isEmpty()) {
            return index;
        }
        String state = lines.get(0).getItemState();
        if ("MOVED".equals(state)) {
            int lastTarget = this.getLastIndexForAccount(docket.getTargetAccount());
            if (lastTarget == -1) {
                int lastSource = this.getLastIndexForAccount(docket.getAccount());
                if (lastSource != -1) {
                    index = lastSource + 1;
                }
            } else {
                index = lastTarget + 1;
            }
        } else {
            for (SummaryLine<?> line : lines) {
                int lastSource;
                state = line.getItemState();
                if (!"DELETED".equals(state) && !"DELETED_WASTED".equals(state) || (lastSource = this.getLastIndexForAccount(docket.getAccount())) == -1) continue;
                index = lastSource + 1;
            }
        }
        return index;
    }

    private int getLastIndexForAccount(Account account) {
        if (account == null || account.getID() == null) {
            return -1;
        }
        EventList<KTSDocket> list = this.docketListMap.get(KTSDocketState.Live);
        list.getReadWriteLock().writeLock().lock();
        ArrayList<KTSDocket> liveList = new ArrayList<KTSDocket>((Collection<KTSDocket>)list);
        list.getReadWriteLock().writeLock().unlock();
        for (int i = liveList.size() - 1; i >= 0; --i) {
            if (!account.equals((Object)((KTSDocket)liveList.get(i)).getAccount())) continue;
            return i;
        }
        return -1;
    }

    private boolean analyseDocket(KTSDocket docket) {
        boolean passed = false;
        List<SummaryLine<?>> lines = docket.getSummaryLines();
        ArrayList linesToRemove = new ArrayList();
        for (SummaryLine<?> nextLine : lines) {
            if ("ACTIVE".equals(nextLine.getItemState())) {
                passed = true;
                continue;
            }
            if ("DELETED".equals(nextLine.getItemState())) {
                if (!this.analyseDeleted(nextLine, docket)) {
                    linesToRemove.add(nextLine);
                    continue;
                }
                passed = true;
                continue;
            }
            if ("DELETED_WASTED".equals(nextLine.getItemState())) {
                if (!this.analyseDeleted(nextLine, docket)) {
                    linesToRemove.add(nextLine);
                    continue;
                }
                passed = true;
                continue;
            }
            if (!"MOVED".equals(nextLine.getItemState())) continue;
            if (!this.analyseMoved(nextLine, docket)) {
                linesToRemove.add(nextLine);
                continue;
            }
            passed = true;
        }
        this.analyseNotifiers(docket);
        docket.removeLines(linesToRemove);
        if (docket.getSummaryLines().isEmpty()) {
            passed = false;
        }
        return passed;
    }

    private boolean analyseDeleted(SummaryLine<?> deletedLine, KTSDocket destinationDocket) {
        boolean showLine = this.deletionPolicy == null || DocketPolicy.Always.equals((Object)this.deletionPolicy);
        List<KTSDocket> affectedDockets = this.getDocketsWithSameAccount(destinationDocket);
        SalesQuantity deletedQty = deletedLine.getQuantity();
        SalesQuantity alreadyDeleted = SalesQuantity.ZERO;
        for (KTSDocket nextDocket : affectedDockets) {
            if (nextDocket.getTargetAccount() == null || !destinationDocket.getAccount().equals((Object)nextDocket.getAccount())) continue;
            List<SummaryLine<?>> summaryLines = nextDocket.getAllSummaryLines();
            for (SummaryLine<?> affectedLine : summaryLines) {
                if (!affectedLine.matchesIncomingLine(deletedLine, false)) continue;
                alreadyDeleted = alreadyDeleted.add(affectedLine.getQuantity());
            }
        }
        deletedLine.setQuantity(deletedQty.add(alreadyDeleted));
        HashSet<KTSDocket> toSave = new HashSet<KTSDocket>();
        for (KTSDocket affectedDocket : affectedDockets) {
            List<SummaryLine<?>> summaryLines = affectedDocket.getAllSummaryLines();
            for (SummaryLine<?> affectedLine : summaryLines) {
                if (!affectedLine.matchesIncomingLine(deletedLine, false)) continue;
                if (affectedLine.getOldQuantity() != null) {
                    if (alreadyDeleted.greaterThan(SalesQuantity.ZERO)) {
                        SalesQuantity diff = affectedLine.getQuantity().subtract(affectedLine.getOldQuantity());
                        alreadyDeleted = alreadyDeleted.add(diff);
                        deletedQty = deletedQty.subtract(diff);
                        if (SalesQuantity.ZERO.equals(alreadyDeleted)) continue;
                    }
                    if (deletedQty.equals(SalesQuantity.ZERO)) {
                        return false;
                    }
                }
                if (!affectedLine.getQuantity().greaterThan(0L)) continue;
                SalesQuantity difference = affectedLine.getQuantity().add(deletedQty);
                SalesQuantity toDelete = deletedQty;
                if (difference.lessThan(0L)) {
                    toDelete = affectedLine.getQuantity().negate();
                }
                affectedDocket.addDeleted(toDelete, affectedLine);
                deletedQty = deletedQty.subtract(toDelete);
                if (deletedQty.greaterThan(SalesQuantity.ZERO)) {
                    deletedQty = SalesQuantity.ZERO;
                }
                toSave.add(affectedDocket);
                if (DocketPolicy.DropIfBumped.equals((Object)this.deletionPolicy) && KTSDocketState.Bump.equals((Object)affectedDocket.getStatus())) {
                    deletedLine.setQuantity(deletedLine.getQuantity().subtract(toDelete));
                    continue;
                }
                showLine = true;
            }
            if (!SalesQuantity.ZERO.equals(deletedQty)) continue;
            break;
        }
        for (KTSDocket nextSave : toSave) {
            this.myIO.saveDocket(nextSave);
        }
        return showLine;
    }

    private boolean analyseMoved(SummaryLine<?> movedLine, KTSDocket destinationDocket) {
        boolean showLine = DocketPolicy.Always.equals((Object)this.transferPolicy);
        List<KTSDocket> affectedDockets = this.getDocketsWithSameAccount(destinationDocket);
        SalesQuantity movedQty = movedLine.getQuantity();
        if (movedQty == null) {
            return false;
        }
        SalesQuantity alreadyMoved = SalesQuantity.ZERO;
        for (KTSDocket nextDocket : affectedDockets) {
            if (nextDocket.getTargetAccount() == null || !destinationDocket.getAccount().equals((Object)nextDocket.getAccount())) continue;
            List<SummaryLine<?>> summaryLines = nextDocket.getAllSummaryLines();
            for (SummaryLine<?> affectedLine : summaryLines) {
                if (!affectedLine.matchesIncomingLine(movedLine, false)) continue;
                alreadyMoved = alreadyMoved.add(affectedLine.getQuantity());
            }
        }
        movedLine.setQuantity(movedQty.add(alreadyMoved));
        HashSet<KTSDocket> toSave = new HashSet<KTSDocket>();
        for (KTSDocket affectedDocket : affectedDockets) {
            List<SummaryLine<?>> summaryLines = affectedDocket.getAllSummaryLines();
            for (SummaryLine<?> affectedLine : summaryLines) {
                if (!affectedLine.matchesIncomingLine(movedLine, false)) continue;
                if (affectedLine.getOldQuantity() != null) {
                    if (alreadyMoved.greaterThan(SalesQuantity.ZERO)) {
                        SalesQuantity diff = affectedLine.getQuantity().subtract(affectedLine.getOldQuantity());
                        alreadyMoved = alreadyMoved.add(diff);
                        movedQty = movedQty.subtract(diff);
                        if (SalesQuantity.ZERO.equals(alreadyMoved)) continue;
                    }
                    if (movedQty.equals(SalesQuantity.ZERO)) {
                        return false;
                    }
                }
                if (!affectedLine.getQuantity().greaterThan(0L)) continue;
                SalesQuantity difference = affectedLine.getQuantity().add(movedQty);
                SalesQuantity toMove = movedQty;
                if (difference.lessThan(0L)) {
                    toMove = affectedLine.getQuantity().negate();
                }
                affectedDocket.addTransfer(toMove, affectedLine, destinationDocket.getTargetAccount());
                movedQty = movedQty.subtract(toMove);
                if (movedQty.greaterThan(SalesQuantity.ZERO)) {
                    movedQty = SalesQuantity.ZERO;
                }
                toSave.add(affectedDocket);
                if (DocketPolicy.DropIfBumped.equals((Object)this.transferPolicy) && KTSDocketState.Bump.equals((Object)affectedDocket.getStatus())) {
                    movedLine.setQuantity(movedLine.getQuantity().subtract(toMove));
                    continue;
                }
                showLine = true;
            }
            if (!SalesQuantity.ZERO.equals(movedQty)) continue;
            break;
        }
        for (KTSDocket nextSave : toSave) {
            this.myIO.saveDocket(nextSave);
        }
        movedLine.negateQuantity();
        return showLine;
    }

    private void analyseNotifiers(KTSDocket incomingDocket) {
        List<KTSDocket> similarDockets = this.getDocketsWithSameAccount(incomingDocket);
        for (KTSDocket nextDocket : similarDockets) {
            nextDocket.getSalesAccountDocket().setSalesAccount(incomingDocket.getAccount());
            nextDocket.updateNotifiers();
        }
    }

    private List<KTSDocket> getDocketsWithSameAccount(KTSDocket docket) {
        ArrayList<KTSDocket> matches = new ArrayList<KTSDocket>();
        ArrayList<KTSDocket> allDockets = new ArrayList<KTSDocket>();
        for (KTSDocketState nextState : KTSDocketState.values()) {
            EventList<KTSDocket> nextStateList = this.docketListMap.get(nextState);
            nextStateList.getReadWriteLock().writeLock().lock();
            allDockets.addAll((Collection<KTSDocket>)nextStateList);
            nextStateList.getReadWriteLock().writeLock().unlock();
        }
        Account toMatch = docket.getAccount();
        if (toMatch != null && toMatch.getID() != null) {
            for (KTSDocket nextDocket : allDockets) {
                if (nextDocket == null) continue;
                if (toMatch.getID().equals(nextDocket.getAccountID())) {
                    matches.add(nextDocket);
                    continue;
                }
                if (!toMatch.getID().equals(nextDocket.getTargetAccountID())) continue;
                matches.add(nextDocket);
            }
        }
        return matches;
    }

    @Override
    public void moveDockets(List<KTSDocket> selectedDockets, KTSDocketState state, int index) {
        EventList<KTSDocket> dockets = this.docketListMap.get(state);
        ArrayList<KTSDocket> movingDockets = new ArrayList<KTSDocket>(selectedDockets);
        for (KTSDocket nextDocket : selectedDockets) {
            if (state.equals((Object)nextDocket.getDocketState())) continue;
            movingDockets.remove(nextDocket);
        }
        dockets.getReadWriteLock().writeLock().lock();
        if (this.rushable && !KTSDocketState.Bump.equals((Object)state)) {
            ArrayList<KTSDocket> rushed = new ArrayList<KTSDocket>();
            for (KTSDocket nextDocket : selectedDockets) {
                if (!nextDocket.isRushed()) continue;
                rushed.add(nextDocket);
            }
            selectedDockets.removeAll(rushed);
            this.doMove((List<KTSDocket>)rushed, (List<KTSDocket>)dockets, index, 0, this.rushedMap.get(state).size());
        }
        this.doMove(selectedDockets, (List<KTSDocket>)dockets, index, this.rushedMap.get(state).size(), dockets.size());
        this.myIO.saveList(this, state);
        dockets.getReadWriteLock().writeLock().unlock();
    }

    private void doMove(List<KTSDocket> moveThese, List<KTSDocket> docketList, int desiredIndex, int minIndex, int maxIndex) {
        if (moveThese.isEmpty()) {
            return;
        }
        int currentIndex = Math.min(maxIndex, desiredIndex);
        docketList.removeAll(moveThese);
        maxIndex = Math.max(maxIndex - moveThese.size(), minIndex);
        if (currentIndex >= maxIndex) {
            docketList.addAll(Math.max(minIndex, maxIndex), moveThese);
        } else if (currentIndex >= minIndex) {
            docketList.addAll(Math.max(minIndex, currentIndex), moveThese);
        } else {
            docketList.addAll(Math.min(docketList.size(), minIndex), moveThese);
        }
    }

    public void deleteAllBumpedDockets() {
        OrderMate.LOG.info("Deleting all bumped dockets");
        EventList<KTSDocket> list = this.docketListMap.get(KTSDocketState.Bump);
        list.getReadWriteLock().writeLock().lock();
        ArrayList<KTSDocket> bumpedDockets = new ArrayList<KTSDocket>((Collection<KTSDocket>)list);
        list.removeAll(bumpedDockets);
        list.getReadWriteLock().writeLock().unlock();
        for (KTSDocket nextDocket : bumpedDockets) {
            this.myIO.deleteDocket(nextDocket);
        }
        this.myIO.saveList(this, KTSDocketState.Bump);
        OrderMate.LOG.info(bumpedDockets.size() + " dockets deleted");
    }

    void purge() {
        OrderMate.LOG.info("KTS-Trace: Purging dockets");
        this.clearDockets();
        String mainDir = this.myIO.getMainDir();
        File directory = new File(mainDir);
        if (directory.exists()) {
            File[] files;
            for (File nextFile : files = directory.listFiles()) {
                nextFile.delete();
            }
        }
    }

    void clearDockets() {
        for (KTSDocketState state : KTSDocketState.values()) {
            EventList<KTSDocket> list = this.docketListMap.get(state);
            list.getReadWriteLock().writeLock().lock();
            list.clear();
            list.getReadWriteLock().writeLock().unlock();
        }
        this.currentId = 0;
    }

    public void clearStaleDockets() {
        String mainDir = this.myIO.getMainDir();
        File directory = new File(mainDir);
        if (directory.exists()) {
            File[] files;
            Calendar cal = Calendar.getInstance();
            DateTimeUtils.clearTimePart((Calendar)cal);
            cal.add(5, this.STALE_DAYS);
            long cutoff = cal.getTimeInMillis();
            for (File nextFile : files = directory.listFiles()) {
                if (!nextFile.getName().endsWith(".dkt")) continue;
                try {
                    BasicFileAttributes atts = Files.readAttributes(nextFile.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                    if (cutoff <= atts.lastModifiedTime().toMillis()) continue;
                    if (nextFile.delete()) {
                        OrderMate.LOG.info("Deleting stale docket file " + nextFile + " from " + atts.lastModifiedTime());
                        continue;
                    }
                    OrderMate.LOG.warn("Couln't delete stale docket file " + nextFile + " from " + atts.lastModifiedTime());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void addDocketStateListener(KTSDocketStateListener listener) {
        if (this.stateListenerList == null) {
            this.stateListenerList = new ArrayList<KTSDocketStateListener>();
        }
        this.stateListenerList.add(listener);
    }

    @Override
    public void removeDocketStateListener(KTSDocketStateListener listener) {
        if (this.stateListenerList != null) {
            this.stateListenerList.remove(listener);
            if (this.stateListenerList.isEmpty()) {
                this.stateListenerList = null;
            }
        }
    }

    private void fireDocketStateEvent(KTSDocket docket, KTSDocketState from, KTSDocketState to) {
        if (this.stateListenerList != null && !this.stateListenerList.isEmpty()) {
            KTSDocketStateEvent event = new KTSDocketStateEvent(docket, from, to);
            for (KTSDocketStateListener listener : this.stateListenerList) {
                listener.docketStateChanged(event);
            }
        }
    }

    public void setKTSMateIO(KTSMateIO yourIO) {
        this.myIO = yourIO;
    }

    public void setRushable(boolean value) {
        this.rushable = value;
        if (!this.rushable) {
            for (Set<KTSDocket> next : this.rushedMap.values()) {
                next.clear();
            }
        }
    }

    public void setTransfersPolicy(DocketPolicy policy) {
        this.transferPolicy = policy == null ? DocketPolicy.Always : policy;
    }

    public void setDeletionsPolicy(DocketPolicy policy) {
        this.deletionPolicy = policy == null ? DocketPolicy.Always : policy;
    }

    public static enum DocketPolicy {
        Always,
        DropIfBumped;


        public static DocketPolicy safeValue(String name) {
            try {
                return DocketPolicy.valueOf(name);
            }
            catch (Exception ex) {
                return null;
            }
        }
    }
}

