/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.docket;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.gateway.Gateway;
import au.com.ordermate.gateway.GatewayNotifier;
import au.com.ordermate.gateway.GatewayProcessor;
import au.com.ordermate.networkio.IONotification;
import au.com.ordermate.networkio.NotificationDetails;
import au.com.ordermate.persistence.PersistentSession;
import au.com.ordermate.simplermi.SimpleRMI;
import au.com.ordermate.util.StringUtils;
import java.net.InetAddress;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.sound.sampled.AudioInputStream;
import ordermate.OrderMate;
import ordermate.audio.AudioUtils;
import ordermate.database.docket.AbstractDocket;
import ordermate.database.docket.SalesAccountDocket;
import ordermate.database.hardware.physical.kts.KTSDocketState;
import ordermate.database.hardware.physical.kts.KTSProperty;
import ordermate.database.hardware.physical.kts.KTSPropertyType;
import utils.ktsmate.KTSMate;
import utils.ktsmate.docket.DefaultKTSListController;
import utils.ktsmate.docket.KTSDocket;

public class IncomingDocketBay
implements GatewayNotifier<SalesAccountDocket>,
GatewayProcessor<SalesAccountDocket> {
    private final DefaultKTSListController myController;
    private final Gateway<SalesAccountDocket> gateway;
    private String audioUrl = null;
    private final Map<SalesAccountDocket, NotificationDetails> notifyMap;

    public IncomingDocketBay(DefaultKTSListController controller) {
        this.myController = controller;
        this.notifyMap = new HashMap<SalesAccountDocket, NotificationDetails>();
        this.gateway = new Gateway((GatewayProcessor)this, (GatewayNotifier)this);
        this.gateway.startService();
        for (KTSProperty property : KTSMate.getLocalPrinter().getKtsProperties()) {
            if (!KTSPropertyType.Sound.equals((Object)property.getType())) continue;
            this.audioUrl = property.getValue();
            if (!StringUtils.isEmpty((String)this.audioUrl)) continue;
            this.audioUrl = null;
        }
    }

    public void doPrint(AbstractDocket docket, NotificationDetails notifyDetails) {
        if (docket instanceof SalesAccountDocket) {
            this.notifyMap.put((SalesAccountDocket)docket, notifyDetails);
            try {
                boolean wentIn = this.gateway.putIntoQueue((Object)((SalesAccountDocket)docket));
                if (!wentIn) {
                    this.notifyError(notifyDetails);
                } else {
                    this.notifyStarted(notifyDetails);
                }
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Error putting docket into queue " + docket, (Throwable)ex);
                this.notifyError(notifyDetails);
            }
        }
    }

    public void notifyProcess(SalesAccountDocket processedValue, boolean processSuccessful) {
        NotificationDetails details = this.notifyMap.get(processedValue);
        boolean wasNotified = false;
        if (details != null) {
            wasNotified = processSuccessful ? this.notifyComplete(details) : this.notifyError(details);
        }
        this.notifyMap.remove(processedValue);
    }

    public final boolean processIncoming(SalesAccountDocket toProcess) {
        ArrayList<SalesAccountDocket> list = new ArrayList<SalesAccountDocket>(1);
        list.add(toProcess);
        new PersistentSession(list);
        KTSDocket newDocket = new KTSDocket(toProcess);
        toProcess.setXml(null);
        if (toProcess.getInitialState() != null) {
            newDocket.setDocketState(toProcess.getInitialState());
        } else {
            newDocket.setDocketState(KTSDocketState.Live);
        }
        try {
            this.myController.addDocket(newDocket);
            if (this.audioUrl != null) {
                AudioInputStream stream = AudioUtils.getStreamFromUrl((String)this.audioUrl);
                AudioUtils.playClip((AudioInputStream)stream);
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot add docket to controller:", (Throwable)ex);
            return false;
        }
        return true;
    }

    private IONotification connectNotification(NotificationDetails details) {
        IONotification notify = null;
        try {
            notify = (IONotification)SimpleRMI.getObject((InetAddress)details.getNotifyHost(), (String)details.getRMIName(), (int)details.getNotifyPort());
        }
        catch (NotBoundException e) {
            OrderMateLog.LOG.error("KTS Docket process couldn't report back to IONotification: " + details, (Throwable)e);
        }
        catch (RemoteException e) {
            OrderMateLog.LOG.error("KTS Docket process couldn't report back to IONotification: " + details, (Throwable)e);
        }
        return notify;
    }

    private boolean notifyError(NotificationDetails details) {
        if (details == null) {
            return true;
        }
        IONotification notify = this.connectNotification(details);
        boolean notified = false;
        if (notify != null) {
            try {
                notify.jobError(details.getJobID());
                notified = true;
            }
            catch (RemoteException ex) {
                OrderMateLog.LOG.warn("Problem notification of error on remote.", (Throwable)ex);
            }
        }
        return notified;
    }

    private boolean notifyComplete(NotificationDetails details) {
        if (details == null) {
            return true;
        }
        IONotification notify = this.connectNotification(details);
        boolean notified = false;
        if (notify != null) {
            try {
                notify.jobComplete(details.getJobID());
                notified = true;
            }
            catch (RemoteException ex) {
                OrderMateLog.LOG.warn("Problem notification of job complete on remote.", (Throwable)ex);
            }
        }
        return notified;
    }

    private boolean notifyStarted(NotificationDetails details) {
        if (details == null) {
            return true;
        }
        IONotification notify = this.connectNotification(details);
        boolean notified = false;
        if (notify != null) {
            try {
                notify.jobStarted(details.getJobID());
                notified = true;
            }
            catch (RemoteException ex) {
                OrderMateLog.LOG.warn("Problem notification of job started on remote.", (Throwable)ex);
            }
        }
        return notified;
    }
}

