/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.docket;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.FKReference;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.cache.CachedFKReference;
import au.com.ordermate.units.SalesQuantity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.docket.SalesAccountDocket;
import ordermate.database.hardware.DocketGrouping;
import ordermate.database.hardware.DocketSorting;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.hardware.physical.kts.KTSDocketState;
import ordermate.database.misc.Course;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.SalesItemSummary;
import ordermate.database.sales.SalesItemSummaryCreator;
import ordermate.database.sales.SalesItemSummaryCreatorNew;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.printSummary.GroupByNameIgnoreComboStrategy;
import ordermate.database.sales.printSummary.PrepDocketHelper;
import ordermate.database.sales.printSummary.PropertySummaryGroupingStrategy;
import ordermate.database.sales.printSummary.SalesItemSummaryGroup;
import ordermate.database.sales.printSummary.SummaryGroupCreator;
import ordermate.database.sales.printSummary.SummaryGroupingStrategy;
import ordermate.database.sales.printSummary.sorting.SortingStrategyVendor;
import ordermate.database.users.User;
import ordermate.database.workflow.Workflow;
import ordermate.database.workflow.action.WorkflowAction;
import ordermate.database.workflow.action.WorkflowActionSet;
import ordermate.database.workflow.action.WorkflowPrintAction;
import org.apache.commons.collections.ListUtils;
import utils.ktsmate.docket.KTSDocketEvent;
import utils.ktsmate.docket.KTSNotifier;
import utils.ktsmate.docket.line.GroupHeaderLine;
import utils.ktsmate.docket.line.KTSAdjustment;
import utils.ktsmate.docket.line.KTSLine;
import utils.ktsmate.docket.line.SummaryGroupLine;
import utils.ktsmate.docket.line.SummaryItemLine;
import utils.ktsmate.docket.line.SummaryLine;
import utils.ktsmate.docket.line.notifier.KTSNotifyPrinterLine;

public class KTSDocket
implements Serializable,
PropertiedObject {
    public static final Props Properties = new Props();
    private KTSDocketState status = KTSDocketState.Live;
    private Reference<SalesAccountDocket> salesAccountDocket = new FKReference(SalesAccountDocket.class);
    private List<KTSLine> printableLines = new ArrayList<KTSLine>();
    private List<KTSLine<KTSAdjustment>> transfers;
    private List<KTSLine<KTSAdjustment>> deletions;
    private List<KTSLine> notifications;
    private List<KTSDocketEvent> events = new ArrayList<KTSDocketEvent>();
    private int initialTime = 0;
    private int liveTime = 0;
    private int holdTime = 0;
    private Reference<Account> account = new FKReference(Account.class).collapseOnSerialize(true);
    private Reference<Account> targetAccount = new FKReference(Account.class).collapseOnSerialize(true);
    private Reference<VirtualPrinter> originalPrinter = new CachedFKReference(VirtualPrinter.class).collapseOnSerialize(true);
    private Reference<Terminal> terminal = new CachedFKReference(Terminal.class).collapseOnSerialize(true);
    private Reference<User> user = new CachedFKReference(User.class).collapseOnSerialize(true);
    private int id = -1;
    private Long modCount = 1L;
    private boolean rushed = false;
    private transient KTSLine selectedLine = null;
    private transient List<KTSLine> selectableLines = null;
    private transient List<SummaryLine<?>> summaryLines = new ArrayList();

    @Deprecated
    public KTSDocket() {
    }

    public KTSDocket(KTSDocket copy) {
        this.status = copy.getDocketState();
        this.setSalesAccountDocket(copy.getSalesAccountDocket());
        this.setOriginalPrinter(copy.getOriginalPrinter());
        this.printableLines.addAll(copy.printableLines);
        if (copy.notifications != null) {
            this.notifications = new ArrayList<KTSLine>(copy.notifications);
        }
        if (copy.transfers != null) {
            this.transfers = new ArrayList<KTSLine<KTSAdjustment>>(copy.transfers);
        }
        if (copy.deletions != null) {
            this.deletions = new ArrayList<KTSLine<KTSAdjustment>>(copy.deletions);
        }
        this.account.set(copy.account.get());
        this.targetAccount.set(copy.targetAccount.get());
        this.terminal.set(copy.terminal.get());
        this.user.set(copy.user.get());
        this.events.addAll(copy.getEvents());
        this.rushed = copy.rushed;
        this.id = copy.id;
    }

    public KTSDocket(SalesAccountDocket docket) {
        if (docket == null) {
            throw new IllegalArgumentException("A KTSDocket must have a SalesAccountDocket.");
        }
        this.setSalesAccountDocket(docket);
        this.setOriginalPrinter(docket.getOriginalPrinter());
        this.setAccount(docket.getSalesAccount());
        this.setTargetAccount(docket.getTargetAccount());
        this.setTerminal(docket.getTerminal());
        this.setUser(docket.getUser());
        this.createPrintableLines();
        this.status = KTSDocketState.Live;
        this.rushed = docket.isRushed();
        this.initialTime = docket.getInitialTime();
    }

    private List<SalesItemQuantity> determineQuantities(Account sourceAccount) {
        if (sourceAccount == null || sourceAccount.getID() == null) {
            return Collections.emptyList();
        }
        ObjectQuery query = Query.select(WorkflowPrintAction.class).equals(WorkflowPrintAction.Properties.DOCKET, this.salesAccountDocket);
        List actions = PersistenceManager.getObjectList(WorkflowPrintAction.class, (String)query.toString(), null);
        ArrayList<SalesItemQuantity> qtys = null;
        if (!actions.isEmpty()) {
            qtys = new ArrayList<SalesItemQuantity>();
            for (WorkflowPrintAction action : actions) {
                qtys.addAll(this.getAccountQuantities(sourceAccount, action.getQuantitiesToPrint()));
            }
            for (SalesItemQuantity qty : qtys) {
                qty.markAsNotPrinted();
            }
        }
        return qtys;
    }

    private void createPrintableLines() {
        this.summaryLines = null;
        Account sourceAccount = this.getAccount();
        List<SalesItemQuantity> qtys = this.determineQuantities(sourceAccount);
        if (qtys != null && qtys.isEmpty()) {
            return;
        }
        PrepDocketHelper helper = PrepDocketHelper.create((Account)sourceAccount, qtys);
        List<String> systemStates = Arrays.asList("ACTIVE", "DELETED", "DELETED_WASTED", "MOVED");
        String[] courses = Account.getCourses();
        for (int course = 0; course < courses.length; ++course) {
            for (String nextState : systemStates) {
                List interestingCourseItems = helper.getAllItems(Boolean.FALSE, nextState, course);
                if (interestingCourseItems.isEmpty()) continue;
                if (!this.getOriginalPrinter().getPrepDocketGrouping().equals(VirtualPrinter.PrepDocketGrouping.NONE.toString())) {
                    List<SalesItemSummaryGroup> groups = this.performGrouping(interestingCourseItems);
                    KTSLine headerLine = null;
                    for (SalesItemSummaryGroup group : groups) {
                        if (group.getHeaders() == null) {
                            headerLine = null;
                        } else if (headerLine == null || !ListUtils.isEqualList((Collection)((SalesItemSummaryGroup)headerLine.getData()).getIdentifiers(), (Collection)group.getIdentifiers())) {
                            headerLine = new GroupHeaderLine(group, nextState, null, null);
                            this.printableLines.add(headerLine);
                        }
                        if (group.getSummariesSize() == 1) {
                            this.addToPrintable(this.printableLines, Boolean.FALSE, group.getSummary(), nextState, headerLine);
                            continue;
                        }
                        this.addGroupToPrintable(this.printableLines, Boolean.FALSE, group, nextState, headerLine);
                    }
                    continue;
                }
                List<SalesItemSummary> allSummaries = this.findPrintableSummaries(interestingCourseItems);
                for (SalesItemSummary nextSummary : allSummaries) {
                    this.addToPrintable(this.printableLines, Boolean.FALSE, nextSummary, nextState, null);
                }
            }
        }
        this.updateNotifiers();
    }

    private void markAllWorkflowQtysNotPrinted(Account sourceAccount) {
        HashSet<SalesItemQuantity> qtys = new HashSet<SalesItemQuantity>();
        ObjectQuery query = Query.select(WorkflowPrintAction.class).equals(WorkflowPrintAction.Properties.DOCKET, this.salesAccountDocket);
        List actions = PersistenceManager.getObjectList(WorkflowPrintAction.class, (String)query.toString(), null);
        if (actions.isEmpty()) {
            return;
        }
        Workflow wf = ((WorkflowPrintAction)actions.get(0)).getActionSet().getWorkflow();
        query = Query.select(WorkflowActionSet.class).equals(WorkflowActionSet.Properties.WORKFLOW, (Object)wf);
        List actionSets = PersistenceManager.getObjectList(WorkflowActionSet.class, (String)query.toString(), null);
        for (WorkflowActionSet actionSet : actionSets) {
            List acts = actionSet.getActions();
            for (WorkflowAction act : acts) {
                if (!(act instanceof WorkflowPrintAction)) continue;
                WorkflowPrintAction printAction = (WorkflowPrintAction)act;
                qtys.addAll(this.getAccountQuantities(sourceAccount, printAction.getQuantitiesToPrint()));
            }
        }
        ArrayList qtysList = new ArrayList(qtys);
        Collections.sort(qtysList, new Comparator<SalesItemQuantity>(){

            @Override
            public int compare(SalesItemQuantity o1, SalesItemQuantity o2) {
                if (o1.getCreationTime() == null && o2.getCreationTime() == null) {
                    return 0;
                }
                if (o1.getCreationTime() == null) {
                    return 1;
                }
                if (o2.getCreationTime() == null) {
                    return -1;
                }
                return o1.getCreationTime().compareTo(o2.getCreationTime());
            }
        });
        SalesItemQuantity lastQty = (SalesItemQuantity)qtysList.get(qtysList.size() - 1);
        for (SalesItemQuantity qty : qtys) {
            if (qty.getCreationTime() == null || !qty.getCreationTime().equals(lastQty.getCreationTime())) continue;
            qty.markAsNotPrinted();
        }
    }

    void updateNotifiers() {
        KTSNotifier notifier = new KTSNotifier();
        this.notifications = new ArrayList<KTSLine>();
        this.markAllWorkflowQtysNotPrinted(this.getAccount());
        for (Course course : Course.getCourses()) {
            try {
                List<KTSLine> newNotifiers = notifier.updateNotifications(this.getOriginalPrinter(), this.getAccount(), course, this.getTerminal());
                this.notifications.addAll(newNotifiers);
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot create notifications!", (Throwable)ex);
            }
        }
        this.modCount = this.modCount + 1L;
    }

    private List<SalesItemSummary> findPrintableSummaries(List<SalesItem> items) {
        VirtualPrinter printer = this.getOriginalPrinter();
        SalesItemSummaryCreator creator = new SalesItemSummaryCreator(SortingStrategyVendor.getSortingStrategy((DocketSorting)printer.getDocketSortingPrep(), (String)printer.getDocketSortingStrategy()));
        List allSummaries = creator.getSummaries(items);
        ArrayList<SalesItemSummary> willPrints = new ArrayList<SalesItemSummary>();
        for (SalesItemSummary nextSummary : allSummaries) {
            if (!nextSummary.getSalesItem().isPrintableThrough(this.getTerminal(), this.getOriginalPrinter())) continue;
            willPrints.add(nextSummary);
        }
        allSummaries.retainAll(willPrints);
        return allSummaries;
    }

    /*
     * WARNING - void declaration
     */
    private List<SalesItemSummaryGroup> performGrouping(List<? extends SalesLineItem> items) {
        void var5_8;
        VirtualPrinter printer = this.getOriginalPrinter();
        ArrayList<SalesLineItem> toSummarise = new ArrayList<SalesLineItem>();
        for (SalesLineItem salesLineItem : items) {
            if (!salesLineItem.isPrintableThrough(this.getTerminal(), printer)) continue;
            toSummarise.add(salesLineItem);
        }
        DocketGrouping grouping = printer.getDocketGroupingPrep();
        if (grouping != null) {
            SalesItemSummaryCreatorNew creator = new SalesItemSummaryCreatorNew(PropertySummaryGroupingStrategy.createStrategyFrom((DocketGrouping)grouping), SortingStrategyVendor.getSortingStrategy((DocketSorting)printer.getDocketSortingPrep(), (String)printer.getDocketSortingStrategy()));
            List list = new SummaryGroupCreator(printer).createSummaryGroups(creator.getSummaries(toSummarise));
        } else {
            SalesItemSummaryCreator creator = new SalesItemSummaryCreator(SortingStrategyVendor.getSortingStrategy((DocketSorting)printer.getDocketSortingPrep(), (String)printer.getDocketSortingStrategy()));
            SummaryGroupingStrategy groupingStrategy = SummaryGroupCreator.getStrategy((VirtualPrinter)printer);
            if (groupingStrategy instanceof GroupByNameIgnoreComboStrategy) {
                creator.ignoreCombos().ignorePrice();
            }
            List list = new SummaryGroupCreator(printer).createSummaryGroups(creator.getSummaries(toSummarise));
        }
        return var5_8;
    }

    private SummaryItemLine addToPrintable(List<KTSLine> toAddTo, Boolean printed, SalesItemSummary theSummary, String state, KTSLine parentLine) {
        SalesQuantity qty = printed != null ? theSummary.getTotalCommittedQuantity(printed.booleanValue(), state) : theSummary.getTotalCommittedQuantity(state);
        SummaryItemLine line = null;
        if (!qty.equals(0L)) {
            line = new SummaryItemLine(theSummary, state, qty, parentLine);
            toAddTo.add(line);
        }
        return line;
    }

    private SummaryGroupLine addGroupToPrintable(List<KTSLine> toAddTo, Boolean printed, SalesItemSummaryGroup group, String state, KTSLine parent) {
        SalesQuantity qty = group.getQuantity();
        SummaryGroupLine line = null;
        if (!qty.equals(0L)) {
            line = new SummaryGroupLine(group, state, qty, parent);
            toAddTo.add(line);
        }
        return line;
    }

    public List<KTSLine> getPrintableLines() {
        return Collections.unmodifiableList(this.printableLines);
    }

    public synchronized List<SummaryLine<?>> getSummaryLines() {
        if (this.summaryLines == null || this.summaryLines.isEmpty()) {
            this.summaryLines = new ArrayList();
            for (KTSLine nextLine : this.printableLines) {
                if (!(nextLine instanceof SummaryLine) || nextLine.getParent() instanceof KTSNotifyPrinterLine) continue;
                this.summaryLines.add((SummaryLine)nextLine);
            }
        }
        return this.summaryLines;
    }

    public List<SummaryLine<?>> getAllSummaryLines() {
        ArrayList allSummaryLines = new ArrayList();
        for (SummaryLine<?> line : this.getSummaryLines()) {
            allSummaryLines.add(line);
            if (!(line instanceof SummaryGroupLine)) continue;
            allSummaryLines.addAll(((SummaryGroupLine)line).getSummaryLines());
        }
        return allSummaryLines;
    }

    public List<SalesItemSummary> getSummaries() {
        ArrayList<SalesItemSummary> summaries = new ArrayList<SalesItemSummary>();
        for (SummaryLine<?> line : this.getSummaryLines()) {
            if (line instanceof SummaryItemLine) {
                summaries.add(((SummaryItemLine)line).getData());
                continue;
            }
            if (!(line instanceof SummaryGroupLine)) continue;
            summaries.addAll(((SalesItemSummaryGroup)((SummaryGroupLine)line).getData()).getSummaries());
        }
        return Collections.unmodifiableList(summaries);
    }

    void setDocketState(KTSDocketState newState) {
        if (newState == null) {
            throw new IllegalArgumentException("Cannot set the KTSDocketState to being null");
        }
        this.status = newState;
    }

    public KTSDocketState getDocketState() {
        return this.status;
    }

    public SalesAccountDocket getSalesAccountDocket() {
        return (SalesAccountDocket)this.salesAccountDocket.get();
    }

    public boolean isRushed() {
        return this.rushed;
    }

    public void setRushed(boolean value) {
        this.rushed = value;
    }

    public void markTime() {
        this.addEvent(new KTSDocketEvent(System.currentTimeMillis(), this.status));
    }

    synchronized void addEvent(KTSDocketEvent event) {
        OrderMate.LOG.info("Adding Docket Event " + event.getState());
        this.events.add(event);
        this.updateTotalAliveTime();
    }

    public synchronized List<KTSDocketEvent> getEvents() {
        return Collections.unmodifiableList(this.events);
    }

    private void updateTotalAliveTime() {
        this.liveTime = 0;
        this.holdTime = 0;
        long lastTime = 0L;
        KTSDocketState lastState = null;
        for (KTSDocketEvent nextEvent : this.events) {
            if (KTSDocketState.Live.equals(lastState)) {
                this.liveTime += (int)(nextEvent.getTime() - lastTime);
            } else if (KTSDocketState.Hold.equals(lastState)) {
                this.holdTime += (int)(nextEvent.getTime() - lastTime);
            }
            lastState = nextEvent.getState();
            lastTime = nextEvent.getTime();
        }
    }

    public int getInitialTime() {
        return this.initialTime;
    }

    public void setInitialTime(int value) {
        this.initialTime = value;
    }

    public int getNonBumpedTime() {
        return this.holdTime + this.liveTime;
    }

    public int getHoldTime() {
        return this.holdTime;
    }

    public int getLiveTime() {
        return this.liveTime;
    }

    public synchronized KTSDocketEvent getLastEvent() {
        if (!this.events.isEmpty()) {
            return this.events.get(this.events.size() - 1);
        }
        return null;
    }

    public void setId(int value) {
        if (this.id != -1) {
            throw new IllegalStateException("Cannot rename id once it has been set.");
        }
        this.id = value;
    }

    public int getId() {
        return this.id;
    }

    public void addDeleted(SalesQuantity amount, SummaryLine<?> line) {
        if (this.deletions == null) {
            this.deletions = new ArrayList<KTSLine<KTSAdjustment>>();
        }
        if (line instanceof SummaryItemLine) {
            this.deletions.add(new KTSLine<KTSAdjustment>(new KTSAdjustment(amount, "DELETED", null), null));
        }
        this.adjustQuantity(line, amount);
    }

    public void addTransfer(SalesQuantity amount, SummaryLine<?> line, Account destination) {
        if (this.transfers == null) {
            this.transfers = new ArrayList<KTSLine<KTSAdjustment>>();
        }
        boolean needsNew = true;
        for (KTSLine<KTSAdjustment> xfer : this.transfers) {
            if (!xfer.getData().getDestinationAccount().equals((Object)destination)) continue;
            needsNew = false;
            xfer.getData().setQuantity(xfer.getData().getQuantity().add(amount));
        }
        if (needsNew && line instanceof SummaryItemLine) {
            this.transfers.add(new KTSLine<KTSAdjustment>(new KTSAdjustment(amount, "MOVED", destination), null));
        }
        this.adjustQuantity(line, amount);
    }

    private void adjustQuantity(SummaryLine<?> line, SalesQuantity qty) {
        if (this.transfers == null && this.deletions == null) {
            return;
        }
        this.modCount = this.modCount + 1L;
        SalesQuantity newQty = line.getQuantity();
        newQty = newQty.add(qty);
        line.setNewQty(newQty);
    }

    public List<KTSLine<KTSAdjustment>> getDeletions() {
        return this.deletions;
    }

    public List<KTSLine<KTSAdjustment>> getTransfers() {
        return this.transfers;
    }

    public List<KTSLine> getNotifications() {
        return this.notifications;
    }

    private List<SalesItemQuantity> getAccountQuantities(Account account, List<SalesItemQuantity> quantities) {
        if (account == null) {
            return Collections.emptyList();
        }
        ArrayList<SalesItemQuantity> qtys = new ArrayList<SalesItemQuantity>(quantities.size());
        HashMap<Long, SalesItemQuantity> qtyMap = new HashMap<Long, SalesItemQuantity>();
        for (SalesLineItem item : account.getAllItems()) {
            for (SalesItemQuantity qty : item.getSalesItemQuantities()) {
                qtyMap.put(qty.getID(), qty);
            }
            for (SalesItem theItem : item.getSalesItems()) {
                for (SalesItemQuantity qty : theItem.getSalesItemQuantities()) {
                    qtyMap.put(qty.getID(), qty);
                }
            }
        }
        for (SalesItemQuantity qty : quantities) {
            SalesItemQuantity accountQty = (SalesItemQuantity)qtyMap.get(qty.getID());
            if (accountQty == null) continue;
            qtys.add(accountQty);
        }
        return qtys;
    }

    public String toString() {
        StringBuilder output = new StringBuilder("[");
        for (KTSLine line : this.printableLines) {
            output.append(line.toString() + ",");
        }
        return output.toString();
    }

    public Long getModCount() {
        return this.modCount;
    }

    public KTSLine getSelectedLine() {
        return this.selectedLine;
    }

    public void selectNextLine(boolean down) {
        int index;
        this.initSelectableLines();
        KTSLine currentLine = this.selectedLine;
        if (down) {
            if (this.selectedLine == null) {
                this.selectedLine = this.selectableLines.get(0);
            } else {
                int index2 = this.selectableLines.indexOf(this.selectedLine);
                if (index2 < this.selectableLines.size() - 1) {
                    this.selectedLine = this.selectableLines.get(index2 + 1);
                }
            }
        } else if (this.selectedLine != null && (index = this.selectableLines.indexOf(this.selectedLine)) > 0) {
            this.selectedLine = this.selectableLines.get(index - 1);
        }
        if (currentLine != null) {
            currentLine.setHighlighted(false);
        }
        if (this.selectedLine != null) {
            this.selectedLine.setHighlighted(true);
        }
    }

    private void initSelectableLines() {
        if (this.selectableLines == null) {
            this.selectableLines = new ArrayList<KTSLine>();
            for (KTSLine line : this.printableLines) {
                this.addSelectables(line);
            }
        }
    }

    private void addSelectables(KTSLine theLine) {
        if (theLine.getData() != null && theLine.getData() instanceof SalesItemSummary) {
            this.selectableLines.add(theLine);
            for (KTSLine childLine : theLine.getChildren()) {
                this.addSelectables(childLine);
            }
        }
    }

    public void deselectLine() {
        KTSLine line = this.getSelectedLine();
        if (line != null) {
            line.setHighlighted(false);
        }
        this.selectedLine = null;
    }

    public Props getProperties() {
        return Properties;
    }

    public <T> T getPropertyValue(PropertiedObject.Property<T> prop) {
        return (T)PropertiedObject.PropsHelper.getPropertyValue((PropertiedObject)this, prop);
    }

    public Account getTargetAccount() {
        return (Account)this.targetAccount.get();
    }

    public void setTargetAccount(Account targetAccount) {
        this.targetAccount.set((PersistentObjectI)targetAccount);
    }

    public Account getAccount() {
        return (Account)this.account.get();
    }

    protected void setAccount(Account account) {
        this.account.set((PersistentObjectI)account);
    }

    public VirtualPrinter getOriginalPrinter() {
        return (VirtualPrinter)this.originalPrinter.get();
    }

    protected void setOriginalPrinter(VirtualPrinter value) {
        this.originalPrinter.set((PersistentObjectI)value);
    }

    public Terminal getTerminal() {
        return (Terminal)this.terminal.get();
    }

    protected void setTerminal(Terminal terminal) {
        this.terminal.set((PersistentObjectI)terminal);
    }

    public User getUser() {
        return (User)this.user.get();
    }

    protected void setUser(User user) {
        this.user.set((PersistentObjectI)user);
    }

    protected KTSDocketState getStatus() {
        return this.status;
    }

    protected void setStatus(KTSDocketState status) {
        this.status = status;
    }

    protected List<KTSLine> getSelectableLines() {
        return this.selectableLines;
    }

    protected void setSelectableLines(List<KTSLine> selectableLines) {
        this.selectableLines = selectableLines;
    }

    public void setSalesAccountDocket(SalesAccountDocket salesAccountDocket) {
        this.salesAccountDocket.set((PersistentObjectI)salesAccountDocket);
    }

    protected void setPrintableLines(List<KTSLine> printableLines) {
        this.printableLines = printableLines;
    }

    protected void setTransfers(List<KTSLine<KTSAdjustment>> transfers) {
        this.transfers = transfers;
    }

    protected void setDeletions(List<KTSLine<KTSAdjustment>> deletions) {
        this.deletions = deletions;
    }

    protected void setNotifications(List<KTSLine> notifications) {
        this.notifications = notifications;
    }

    protected void setEvents(List<KTSDocketEvent> events) {
        this.events = events;
    }

    protected void setLiveTime(int liveTime) {
        this.liveTime = liveTime;
    }

    protected void setHoldTime(int holdTime) {
        this.holdTime = holdTime;
    }

    protected void setModCount(Long modCount) {
        this.modCount = modCount;
    }

    protected void setSelectedLine(KTSLine selectedLine) {
        this.selectedLine = selectedLine;
    }

    protected void setSummaryLines(List<SummaryLine<?>> summaryLines) {
        this.summaryLines = summaryLines;
    }

    public void collapse() {
        boolean no = true;
        if (no) {
            OrderMate.LOG.info("Not Collapsing");
            return;
        }
        OrderMate.LOG.info("Collapsing: " + this.getStatus());
        this.account.collapse();
        this.targetAccount.collapse();
        this.user.collapse();
        this.terminal.collapse();
        this.originalPrinter.collapse();
        this.salesAccountDocket.collapse();
        for (KTSLine line : this.getPrintableLines()) {
            line.collapse();
        }
    }

    public Long getAccountID() {
        return this.account == null ? null : this.account.getID();
    }

    public Long getTargetAccountID() {
        return this.targetAccount == null ? null : this.targetAccount.getID();
    }

    public void removeLines(List<SummaryLine<?>> linesToRemove) {
        if (this.printableLines != null) {
            this.printableLines.removeAll(linesToRemove);
        }
        if (this.summaryLines != null) {
            this.summaryLines.removeAll(linesToRemove);
        }
    }

    public static class Props
    extends PropertiedObject.Props {
        public PropertiedObject.Property<KTSDocketState> STATUS;
        public PropertiedObject.Property<SalesAccountDocket> SALES_ACCOUNT_DOCKET;
        public PropertiedObject.Property<KTSLine> PRINTABLE_LINES;
        public PropertiedObject.Property<KTSLine> TRANSFERS;
        public PropertiedObject.Property<KTSLine> DELETIONS;
        public PropertiedObject.Property<KTSLine> NOTIFICATIONS;
        public PropertiedObject.Property<KTSDocketEvent> EVENTS;
        public PropertiedObject.Property<Integer> INITIAL_TIME;
        public PropertiedObject.Property<Integer> LIVE_TIME;
        public PropertiedObject.Property<Integer> HOLD_TIME;
        public PropertiedObject.Property<Integer> ID;
        public PropertiedObject.Property<Integer> MOD_COUNT;
        public PropertiedObject.Property<Boolean> RUSHED;
        public PropertiedObject.Property<KTSLine> SELECTED_LINE;
        public PropertiedObject.Property<KTSLine> SELECTABLE_LINES;
        public PropertiedObject.Property<Account> ACCOUNT;
        public PropertiedObject.Property<Terminal> TERMINAL;
        public PropertiedObject.Property<User> USER;
        public PropertiedObject.Property<Account> TARGET_ACCOUNT;
        public PropertiedObject.Property<VirtualPrinter> ORIGINAL_PRINTER;
    }
}

