/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.docket.data;

import au.com.ordermate.gateway.Gateway;
import au.com.ordermate.gateway.GatewayNotifier;
import au.com.ordermate.gateway.GatewayProcessor;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import utils.ktsmate.docket.KTSDocket;
import utils.ktsmate.docket.KTSDocketStateEvent;
import utils.ktsmate.docket.KTSDocketStateListener;
import utils.ktsmate.docket.KTSListController;
import utils.ktsmate.docket.data.KTSDocketDataProcessor;

public class DocketDataMonitor
implements GatewayNotifier<KTSDocket>,
KTSDocketStateListener {
    private static final int RETRY_TIME = 60000;
    private static final int PUT_TIMEOUT = 500;
    private static DocketDataMonitor instance;
    private Gateway<KTSDocket> myGateway;
    private Timer retryTimer;
    private Set<KTSDocket> retrySet = new HashSet<KTSDocket>();

    public static synchronized void createInstance(KTSListController controller) {
        if (instance != null) {
            throw new IllegalStateException("Cannot instantiate the DocketDataMonitor more than once.");
        }
        instance = new DocketDataMonitor();
        controller.addDocketStateListener(instance);
    }

    private DocketDataMonitor() {
        this.myGateway = new Gateway((GatewayProcessor)new KTSDocketDataProcessor(), (GatewayNotifier)this);
        this.myGateway.setPutTimeout(500);
        this.myGateway.startService();
        this.retryTimer = new Timer();
        this.retryTimer.schedule((TimerTask)new RetryQueueWorker(), 60000L, 60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyProcess(KTSDocket processedValue, boolean processSuccessful) {
        if (processSuccessful) {
            Set<KTSDocket> set = this.retrySet;
            synchronized (set) {
                this.retrySet.remove(processedValue);
            }
        }
    }

    @Override
    public void docketStateChanged(KTSDocketStateEvent event) {
        if (event.getFromState() == event.getToState()) {
            return;
        }
        this.sendForProcessing(event.getDocket());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendForProcessing(KTSDocket docket) {
        Set<KTSDocket> set = this.retrySet;
        synchronized (set) {
            this.retrySet.add(docket);
        }
        if (!this.myGateway.putIntoQueue((Object)docket)) {
            this.notifyProcess(docket, false);
        }
    }

    class RetryQueueWorker
    extends TimerTask {
        RetryQueueWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashSet needToProcess;
            Set set = DocketDataMonitor.this.retrySet;
            synchronized (set) {
                if (DocketDataMonitor.this.retrySet.size() <= 0) {
                    return;
                }
                needToProcess = new HashSet();
                needToProcess.addAll(DocketDataMonitor.this.retrySet);
            }
            for (KTSDocket docket : needToProcess) {
                DocketDataMonitor.this.sendForProcessing(docket);
            }
        }
    }
}

