/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.docket.data;

import au.com.ordermate.gateway.GatewayProcessor;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.ArrayList;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.docket.SalesAccountDocket;
import ordermate.database.hardware.physical.kts.KTSDocketData;
import ordermate.database.hardware.physical.kts.KTSDocketState;
import utils.ktsmate.KTSMate;
import utils.ktsmate.docket.KTSDocket;
import utils.ktsmate.docket.KTSDocketEvent;

public class KTSDocketDataProcessor
implements GatewayProcessor<KTSDocket> {
    public boolean processIncoming(KTSDocket toProcess) {
        KTSDocketData data = null;
        try {
            SalesAccountDocket docket = toProcess.getSalesAccountDocket();
            if (docket == null) {
                OrderMate.LOG.warn("Cannot get KTS Data, no longer exists for " + toProcess.getId());
                return true;
            }
            data = (KTSDocketData)PersistenceManager.getObject(KTSDocketData.class, (String)Query.select(KTSDocketData.class).equals(KTSDocketData.Properties.SALES_ACCOUNT_DOCKET, (Object)docket).limit(1).toString(), null);
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Cannot get KTS Data, retrying.", (Throwable)ex);
            return false;
        }
        if (data == null) {
            data = new KTSDocketData(KTSMate.getLocalPrinter(), toProcess.getSalesAccountDocket());
        }
        try {
            this.fillData(toProcess, data);
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Couldn't fill in the docketData.", (Throwable)ex);
            return false;
        }
        try {
            data.save();
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Couldn't save the docketdata.", (Throwable)ex);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillData(KTSDocket docket, KTSDocketData data) throws Exception {
        ArrayList<KTSDocketEvent> eventList;
        KTSDocketState state;
        KTSDocket kTSDocket = docket;
        synchronized (kTSDocket) {
            state = docket.getDocketState();
            data.setInitialTime(docket.getInitialTime());
            data.setTimeLive(docket.getLiveTime());
            data.setTimeHold(docket.getHoldTime());
            eventList = new ArrayList<KTSDocketEvent>(docket.getEvents());
        }
        data.setWentLive(this.countEvents(KTSDocketState.Live, eventList));
        data.setWentHold(this.countEvents(KTSDocketState.Hold, eventList));
        data.setWentBump(this.countEvents(KTSDocketState.Bump, eventList));
        data.setState(state);
        data.setKtsId(docket.getId());
    }

    private int countEvents(KTSDocketState state, List<KTSDocketEvent> events) {
        int count = 0;
        KTSDocketState lastState = null;
        for (KTSDocketEvent event : events) {
            if (lastState != event.getState() && state.equals((Object)event.getState())) {
                ++count;
            }
            lastState = event.getState();
        }
        return count;
    }
}

