/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.docket.line;

import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.cache.CachedFKReference;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class KTSLine<T>
implements Serializable,
PropertiedObject {
    public static final Props Properties = new Props();
    private boolean complete;
    private boolean highlighted;
    private KTSLine parent;
    private List<KTSLine> children;
    private T data;
    private Reference ref;

    @Deprecated
    public KTSLine() {
    }

    public KTSLine(T yourData, KTSLine yourParent) {
        this.complete = false;
        this.highlighted = false;
        this.parent = yourParent;
        this.data = yourData;
        if (this.data != null && this.data instanceof PersistentObjectI) {
            this.ref = new CachedFKReference(this.data.getClass());
            this.ref.set((PersistentObjectI)this.data);
        }
        this.children = this.createChildren();
        this.children = this.children == null ? Collections.emptyList() : Collections.unmodifiableList(this.children);
    }

    protected List<KTSLine> createChildren() {
        return Collections.emptyList();
    }

    public final List<KTSLine> getChildren() {
        return this.children;
    }

    public void setChildren(List<KTSLine> value) {
        this.children = value;
    }

    public boolean isDeleted() {
        if (this.parent != null) {
            return this.parent.isDeleted();
        }
        return false;
    }

    public boolean isComplete() {
        if (!this.complete) {
            if (this.parent != null) {
                return this.parent.isComplete();
            }
            return false;
        }
        return true;
    }

    public void setComplete(boolean value) {
        if (!value && this.isComplete()) {
            this.complete = value;
            if (this.parent != null) {
                if (this.parent.isComplete()) {
                    List<KTSLine> peers = this.parent.getChildren();
                    for (KTSLine nextPeer : peers) {
                        if (nextPeer == this) continue;
                        nextPeer.setComplete(true);
                    }
                }
                this.parent.setComplete(false);
            }
        } else {
            this.complete = value;
            if (!this.complete && this.parent != null) {
                this.parent.setComplete(this.complete);
            }
        }
    }

    public KTSLine getParent() {
        return this.parent;
    }

    public void setParent(KTSLine value) {
        this.parent = value;
    }

    public T getData() {
        if (this.ref != null) {
            return (T)this.ref.get();
        }
        return this.data;
    }

    public void setData(T value) {
        this.data = value;
        if (this.data != null && this.data instanceof PersistentObjectI) {
            if (this.ref == null) {
                this.ref = new CachedFKReference(this.data.getClass());
            }
            this.ref.set((PersistentObjectI)this.data);
            this.data = null;
        }
    }

    public void setHighlighted(boolean value) {
        this.highlighted = value;
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    public Props getProperties() {
        return Properties;
    }

    public <T> T getPropertyValue(PropertiedObject.Property<T> prop) {
        return (T)PropertiedObject.PropsHelper.getPropertyValue((PropertiedObject)this, prop);
    }

    public void collapse() {
        if (this.ref != null) {
            this.data = null;
            this.ref.collapse();
        }
        if (this.getChildren() != null) {
            for (KTSLine child : this.getChildren()) {
                child.collapse();
            }
        }
    }

    public static class Props
    extends PropertiedObject.Props {
        public PropertiedObject.Property<Boolean> COMPLETE;
        public PropertiedObject.Property<Boolean> HIGHLIGHTED;
        public PropertiedObject.Property<KTSLine> PARENT;
        public PropertiedObject.Property<KTSLine> CHILDREN;
        public PropertiedObject.Property DATA;
    }
}

