/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.docket.line;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ordermate.database.sales.AbstractSalesRemove;
import ordermate.database.sales.SalesAdd;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesOption;
import ordermate.database.sales.SalesOptionComparator;
import utils.ktsmate.docket.line.BarrenKTSLine;
import utils.ktsmate.docket.line.KTSLine;

public class SalesComponentLine
extends KTSLine<SalesComponent> {
    private List<KTSLine<SalesOption>> options;
    private List<KTSLine<SalesAdd>> pluses;
    private List<KTSLine<AbstractSalesRemove>> minuses;

    @Deprecated
    public SalesComponentLine() {
    }

    public SalesComponentLine(SalesComponent yourData, KTSLine parent) {
        super(yourData, parent);
    }

    @Override
    public void setChildren(List<KTSLine> value) {
        this.options = new ArrayList<KTSLine<SalesOption>>();
        this.pluses = new ArrayList<KTSLine<SalesAdd>>();
        this.minuses = new ArrayList<KTSLine<AbstractSalesRemove>>();
        super.setChildren(value);
        for (KTSLine line : value) {
            if (line.getData() instanceof SalesOption) {
                this.options.add(line);
                continue;
            }
            if (line.getData() instanceof SalesAdd) {
                this.pluses.add(line);
                continue;
            }
            if (!(line.getData() instanceof AbstractSalesRemove)) continue;
            this.minuses.add(line);
        }
    }

    @Override
    protected List<KTSLine> createChildren() {
        List removesList;
        List addsList;
        SalesComponent component = (SalesComponent)this.getData();
        this.options = new ArrayList<KTSLine<SalesOption>>();
        this.pluses = new ArrayList<KTSLine<SalesAdd>>();
        this.minuses = new ArrayList<KTSLine<AbstractSalesRemove>>();
        ArrayList<KTSLine> subLines = new ArrayList<KTSLine>();
        List optionsList = component.getCurrentOptions();
        if (optionsList.size() > 0) {
            ArrayList printableOptions = new ArrayList(optionsList);
            for (SalesOption option : optionsList) {
                if (option.isPrintable()) continue;
                printableOptions.remove(option);
            }
            if (!printableOptions.isEmpty()) {
                Collections.sort(printableOptions, new SalesOptionComparator(component.getUnit()));
                this.addAll(printableOptions, this.options);
            }
        }
        if ((addsList = component.getCurrentPluses()).size() > 0) {
            this.addAll(addsList, this.pluses);
        }
        if ((removesList = component.getCurrentMinuses()).size() > 0) {
            this.addAll(removesList, this.minuses);
        }
        subLines.addAll(this.options);
        subLines.addAll(this.pluses);
        subLines.addAll(this.minuses);
        return subLines;
    }

    protected List<KTSLine<SalesOption>> getOptions() {
        return this.options;
    }

    protected void setOptions(List<KTSLine<SalesOption>> options) {
        this.options = options;
    }

    protected List<KTSLine<SalesAdd>> getPluses() {
        return this.pluses;
    }

    protected void setPluses(List<KTSLine<SalesAdd>> pluses) {
        this.pluses = pluses;
    }

    protected List<KTSLine<AbstractSalesRemove>> getMinuses() {
        return this.minuses;
    }

    protected void setMinuses(List<KTSLine<AbstractSalesRemove>> minuses) {
        this.minuses = minuses;
    }

    private <P> void addAll(List<P> toAdd, List<KTSLine<P>> toAddTo) {
        for (P next : toAdd) {
            toAddTo.add(new BarrenKTSLine<P>(next, this));
        }
    }

    public List<KTSLine<SalesOption>> getOptionLines() {
        return this.options;
    }

    public List<KTSLine<SalesAdd>> getPlusLines() {
        return this.pluses;
    }

    public List<KTSLine<AbstractSalesRemove>> getMinusLines() {
        return this.minuses;
    }

    @Override
    public KTSLine.Props getProperties() {
        return Properties;
    }
}

