/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.docket.line;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.units.SalesQuantity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import ordermate.database.sales.SalesItemSummary;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.printSummary.SalesItemSummaryGroup;
import ordermate.internationalization.Internationalization;
import utils.ktsmate.docket.line.KTSLine;
import utils.ktsmate.docket.line.SummaryItemLine;
import utils.ktsmate.docket.line.SummaryLine;

public class SummaryGroupLine
extends SummaryLine<SalesItemSummaryGroup> {
    public static final Props Properties = new Props();
    private List<SummaryItemLine> summaryLines;

    protected void setSummaryLines(List<SummaryItemLine> summaryLines) {
        this.summaryLines = summaryLines;
    }

    @Deprecated
    public SummaryGroupLine() {
    }

    public SummaryGroupLine(SalesItemSummaryGroup yourData, String theItemState, SalesQuantity qty, KTSLine yourParent) {
        super(yourData, theItemState, qty, yourParent);
    }

    @Override
    protected List<KTSLine> createChildren() {
        this.summaryLines = new ArrayList<SummaryItemLine>();
        ArrayList<KTSLine> children = new ArrayList<KTSLine>();
        for (SalesItemSummary summary : ((SalesItemSummaryGroup)this.getData()).getSummaries()) {
            SummaryItemLine summaryLine = new SummaryItemLine(summary, "ACTIVE", summary.getTotalCommittedQuantity(false, "ACTIVE"), (KTSLine)this);
            children.add(summaryLine);
            this.summaryLines.add(summaryLine);
        }
        return children;
    }

    private SalesQuantity getTotalCommittedQuantity(boolean printed, String itemState, int seat) {
        SalesQuantity quantity = SalesQuantity.ZERO;
        for (SummaryItemLine summaryItemLine : this.summaryLines) {
            quantity = quantity.add(summaryItemLine.getData().getTotalCommittedQuantity(printed, itemState, seat));
        }
        return quantity;
    }

    @Override
    public String getSeats() {
        HashSet<Integer> seatNumbers = new HashSet<Integer>();
        for (SummaryItemLine summaryItemLine : this.summaryLines) {
            seatNumbers.addAll(summaryItemLine.getData().getSeatNumbers());
        }
        return this.getSeatNumbersAsString(true, true, false, null, seatNumbers);
    }

    private String getSeatNumbersAsString(boolean incQty, boolean incOnlyMultipleSeats, boolean printed, String state, Set<Integer> seatNumbers) {
        if (!incQty && incOnlyMultipleSeats) {
            throw new IllegalArgumentException("invOnlyMultipleSeats cannot be true unless incQty is true");
        }
        StringBuffer seatString = new StringBuffer();
        if (seatNumbers.size() > 1) {
            seatString.append(Internationalization.getLiteralFor((String)"COVERS") + " (");
        } else {
            seatString.append(Internationalization.getLiteralFor((String)"COVER") + " (");
        }
        Iterator<Integer> seatIterator = seatNumbers.iterator();
        while (seatIterator.hasNext()) {
            Integer seatNumber = seatIterator.next();
            boolean existsForThisSeat = state == null || this.getTotalCommittedQuantity(printed, state, seatNumber).greaterThan(0L);
            if (!existsForThisSeat) continue;
            if (seatNumber == 0) {
                seatString.append("ALL");
            } else {
                seatString.append(seatNumber);
            }
            SalesQuantity totalCommitedQuantity = this.getTotalCommittedQuantity(printed, state, seatNumber);
            if (incQty && (incOnlyMultipleSeats && totalCommitedQuantity.greaterThan(1L) || !incOnlyMultipleSeats)) {
                seatString.append("x");
                seatString.append(totalCommitedQuantity);
            }
            if (!seatIterator.hasNext()) continue;
            seatString.append(',');
        }
        seatString.append(')');
        return seatString.toString();
    }

    @Override
    public List<SalesItemSummary> getSummaries() {
        if (this.getData() != null) {
            return ((SalesItemSummaryGroup)this.getData()).getSummaries();
        }
        return Collections.emptyList();
    }

    public List<SummaryItemLine> getSummaryLines() {
        return this.summaryLines;
    }

    @Override
    public boolean matchesIncomingLine(SummaryLine<?> line, boolean strictMatch) {
        if (line instanceof SummaryGroupLine) {
            SummaryGroupLine groupLine = (SummaryGroupLine)line;
            if (strictMatch) {
                return this.summaryLines.get(0).getData().getSalesItem().equals((Object)groupLine.getSummaryLines().get(0).getData().getSalesItem());
            }
            return this.summaryLines.get(0).getData().getSalesItem().isEquivalentTo((SalesLineItem)groupLine.getSummaryLines().get(0).getData().getSalesItem());
        }
        for (SummaryItemLine child : this.summaryLines) {
            if (!child.matchesIncomingLine(line, strictMatch)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Props getProperties() {
        return Properties;
    }

    public static class Props
    extends SummaryLine.Props {
        public PropertiedObject.Property<SummaryItemLine> SUMMARY_LINES;
    }
}

