/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.docket.line;

import au.com.ordermate.persistence.FKReference;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.units.SalesQuantity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemSummary;
import ordermate.database.sales.SalesLineItem;
import utils.ktsmate.docket.line.KTSLine;
import utils.ktsmate.docket.line.SalesComponentLine;
import utils.ktsmate.docket.line.SummaryLine;

public class SummaryItemLine
extends SummaryLine<SalesItemSummary> {
    public static final Props Properties = new Props();
    private List<SalesComponentLine> components;
    private KTSLine<String> notes;
    private int course;
    private String seats;
    private Reference<SalesItem> salesItem = new FKReference(SalesItem.class);

    @Deprecated
    public SummaryItemLine() {
    }

    public SummaryItemLine(SalesItemSummary yourData, String theItemState, SalesQuantity yourQty) {
        this(yourData, theItemState, yourQty, (KTSLine)null);
        this.salesItem.set((PersistentObjectI)yourData.getSalesItem());
        this.course = yourData.getSalesItem().getCourse();
        this.seats = yourData.getSeatNumbersAsString(true, true, false, null);
    }

    public SummaryItemLine(SalesItemSummary yourData, String theItemState, SalesQuantity yourQty, KTSLine parent) {
        super(yourData, theItemState, yourQty, parent);
        this.salesItem.set((PersistentObjectI)yourData.getSalesItem());
        this.course = yourData.getSalesItem().getCourse();
        this.seats = yourData.getSeatNumbersAsString(true, true, false, null);
    }

    @Override
    protected List<KTSLine> createChildren() {
        SalesItemSummary mySummary = this.getData();
        ArrayList<KTSLine> subLines = new ArrayList<KTSLine>();
        List componentsList = mySummary.getSalesItem().getComponentList();
        this.components = new ArrayList<SalesComponentLine>();
        for (SalesComponent nextComponent : componentsList) {
            SalesComponentLine nextLine = new SalesComponentLine(nextComponent, (KTSLine)this);
            this.components.add(nextLine);
            subLines.add(nextLine);
        }
        if (mySummary.getSalesItem().getNotes() != null && !mySummary.getSalesItem().getNotes().isEmpty()) {
            this.notes = new KTSLine<String>(mySummary.getSalesItem().getNotes(), this);
            subLines.add(this.notes);
        }
        return subLines;
    }

    @Override
    public List<SalesItemSummary> getSummaries() {
        return Collections.singletonList(this.getData());
    }

    @Override
    public SalesItemSummary getData() {
        SalesItemSummary summary = (SalesItemSummary)super.getData();
        if (summary == null) {
            summary = new SalesItemSummary();
            summary.absorbSalesItem(this.getSalesItem());
            this.setData(summary);
        }
        return summary;
    }

    @Override
    public void setData(SalesItemSummary value) {
        super.setData(value);
        if (value != null) {
            this.salesItem.set((PersistentObjectI)value.getSalesItem());
        }
    }

    public List<SalesComponentLine> getSalesComponentLines() {
        return this.components;
    }

    public KTSLine<String> getNotes() {
        return this.notes;
    }

    public String toString() {
        return this.getData().toString();
    }

    protected List<SalesComponentLine> getComponents() {
        return this.components;
    }

    protected void setComponents(List<SalesComponentLine> components) {
        this.components = components;
    }

    protected void setNotes(KTSLine<String> notes) {
        this.notes = notes;
    }

    @Override
    public boolean matchesIncomingLine(SummaryLine<?> line, boolean strictMatch) {
        if (line instanceof SummaryItemLine) {
            if (!line.getSummaries().isEmpty()) {
                if (strictMatch) {
                    return this.getSalesItem().equals((Object)line.getSummaries().get(0).getSalesItem());
                }
                return this.getSalesItem().isEquivalentTo((SalesLineItem)line.getSummaries().get(0).getSalesItem());
            }
            return false;
        }
        return false;
    }

    @Override
    public Props getProperties() {
        return Properties;
    }

    public int getCourse() {
        return this.course;
    }

    public void setCourse(int course) {
        this.course = course;
    }

    public SalesItem getSalesItem() {
        return (SalesItem)this.salesItem.get();
    }

    public void setSalesItem(SalesItem value) {
        this.salesItem.set((PersistentObjectI)value);
    }

    @Override
    public String getSeats() {
        return this.seats;
    }

    public void setSeats(String seats) {
        this.seats = seats;
    }

    @Override
    public void collapse() {
        this.setData(null);
        this.salesItem.collapse();
        super.collapse();
    }

    public static class Props
    extends SummaryLine.Props {
        public PropertiedObject.Property<SalesComponentLine> COMPONENTS;
        public PropertiedObject.Property<KTSLine> NOTES;
        public PropertiedObject.Property<String> SEATS;
        public PropertiedObject.Property<Integer> COURSE;
    }
}

