/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.docket.line;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.units.SalesQuantity;
import java.util.List;
import ordermate.database.sales.SalesItemSummary;
import utils.ktsmate.docket.line.KTSLine;

public abstract class SummaryLine<T>
extends KTSLine<T> {
    public static final Props Properties = new Props();
    private String itemState;
    private SalesQuantity oldQuantity;
    private SalesQuantity quantity;

    public void setItemState(String itemState) {
        this.itemState = itemState;
    }

    public void setOldQuantity(SalesQuantity oldQuantity) {
        this.oldQuantity = oldQuantity;
    }

    public void setQuantity(SalesQuantity quantity) {
        this.quantity = quantity;
    }

    @Deprecated
    public SummaryLine() {
    }

    public SummaryLine(T yourData, String theItemState, SalesQuantity yourQty, KTSLine parent) {
        super(yourData, parent);
        this.itemState = theItemState;
        this.quantity = yourQty;
    }

    @Override
    public boolean isDeleted() {
        return this.quantity.equals(0L);
    }

    public String getItemState() {
        return this.itemState;
    }

    public SalesQuantity getQuantity() {
        return this.quantity;
    }

    public SalesQuantity getOldQuantity() {
        return this.oldQuantity;
    }

    public void setNewQty(SalesQuantity value) {
        if (this.oldQuantity == null) {
            this.oldQuantity = this.quantity;
        }
        this.quantity = value;
    }

    public void negateQuantity() {
        if (this.quantity != null) {
            this.quantity = this.quantity.negate();
        }
    }

    @Override
    public Props getProperties() {
        return Properties;
    }

    public String getSeats() {
        return "";
    }

    public abstract List<SalesItemSummary> getSummaries();

    public abstract boolean matchesIncomingLine(SummaryLine<?> var1, boolean var2);

    public static class Props
    extends KTSLine.Props {
        public PropertiedObject.Property<String> ITEM_STATE;
        public PropertiedObject.Property<SalesQuantity> OLD_QUANTITY;
        public PropertiedObject.Property<SalesQuantity> QUANTITY;
    }
}

