/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.gui;

import au.com.ordermate.util.image.IconLoader;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class ConfigPopupDrawer
extends JPanel {
    public Signal exit = Signals.createSignal();
    public Signal colours = Signals.createSignal();
    public Signal fonts = Signals.createSignal();
    public Signal timers = Signals.createSignal();
    public Signal general = Signals.createSignal();
    public Signal summary = Signals.createSignal();
    private JButton exitButton;
    private JButton generalButton;
    private JButton timersButton;
    private JButton fontsButton;
    private JButton coloursButton;
    private JButton summaryButton;
    private List<JButton> buttons = new ArrayList<JButton>();
    private JButton focussedButton = null;

    public ConfigPopupDrawer() {
        this.setupComponents();
        this.setOpaque(true);
    }

    private void setupComponents() {
        this.setLayout(new GridLayout(6, 1, 5, 5));
        this.generalButton = this.createButton("General", "/utils/ktsmate/images/general.png", this.general);
        this.buttons.add(this.generalButton);
        this.timersButton = this.createButton("Timers", "/utils/ktsmate/images/timers.png", this.timers);
        this.buttons.add(this.timersButton);
        this.fontsButton = this.createButton("Fonts", "/utils/ktsmate/images/fonts.png", this.fonts);
        this.buttons.add(this.fontsButton);
        this.coloursButton = this.createButton("Colours", "/utils/ktsmate/images/colours.png", this.colours);
        this.buttons.add(this.coloursButton);
        this.summaryButton = this.createButton("Summary", "/utils/ktsmate/images/desktop.png", this.summary);
        this.buttons.add(this.summaryButton);
        this.exitButton = this.createButton("Exit", "/utils/ktsmate/images/exit.png", this.exit);
        this.buttons.add(this.exitButton);
    }

    private JButton createButton(String label, String icon, final Signal signal) {
        JButton button = new JButton(label, IconLoader.get((String)icon));
        OrderMateTheme.setupTransparentButton((AbstractButton)button);
        button.setBorder(new LineBorder(Color.RED, 2));
        button.setBorderPainted(false);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                signal.emit();
            }
        });
        this.add(button);
        return button;
    }

    public void focusFirstButton() {
        if (this.focussedButton != null) {
            this.focussedButton.setBorderPainted(false);
        }
        this.focussedButton = this.buttons.get(0);
        this.focussedButton.setBorderPainted(true);
    }

    public void cycleFocus(boolean up) {
        if (this.focussedButton != null) {
            this.focussedButton.setBorderPainted(false);
        }
        int index = this.buttons.indexOf(this.focussedButton);
        if (up) {
            if (index == 0) {
                index = this.buttons.size();
            }
            --index;
        } else {
            if (index == this.buttons.size() - 1) {
                index = -1;
            }
            ++index;
        }
        this.focussedButton = this.buttons.get(index);
        this.focussedButton.setBorderPainted(true);
        this.focussedButton.repaint();
    }

    public void fireFocussedButton() {
        if (this.focussedButton != null) {
            this.focussedButton.doClick();
        }
    }

    JButton getExitButton() {
        return this.exitButton;
    }

    JButton getGeneralButton() {
        return this.generalButton;
    }

    JButton getTimersButton() {
        return this.timersButton;
    }

    JButton getFontsButton() {
        return this.fontsButton;
    }

    JButton getColoursButton() {
        return this.coloursButton;
    }

    JButton getSummaryButton() {
        return this.summaryButton;
    }
}

