/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class DragPainter {
    private JComponent parentComponent;
    private final Color ghostColor = new Color(128, 128, 128, 128);
    private JLabel dragImage;
    private JComponent draggedRenderer;
    private Point dragPoint;
    private Point offset;

    public DragPainter(JComponent parent) {
        this.parentComponent = parent;
    }

    public void paint(Graphics g) {
        if (this.dragImage != null) {
            if (this.draggedRenderer != null) {
                g.setColor(this.ghostColor);
                g.fillRect(this.draggedRenderer.getX(), this.draggedRenderer.getY(), this.draggedRenderer.getWidth(), this.draggedRenderer.getHeight());
            }
            g.translate(this.dragImage.getX(), this.dragImage.getY());
            this.dragImage.paint(g);
            g.translate(-this.dragImage.getX(), -this.dragImage.getY());
        }
    }

    public void dragComponent(JComponent comp, Point point) {
        if (this.dragImage == null) {
            this.draggedRenderer = comp;
            if (this.draggedRenderer != null) {
                this.offset = new Point((int)(point.getX() - (double)this.draggedRenderer.getX()), (int)(point.getY() - (double)this.draggedRenderer.getY()));
                this.dragPoint = point;
                BufferedImage BI = new BufferedImage(this.draggedRenderer.getWidth(), this.draggedRenderer.getHeight(), 1);
                Graphics2D g2 = BI.createGraphics();
                this.draggedRenderer.paint(g2);
                BI.flush();
                ImageIcon icon = new ImageIcon(BI);
                g2.dispose();
                this.dragImage = new JLabel(icon);
                this.dragImage.setOpaque(false);
                this.dragImage.setPreferredSize(new Dimension(BI.getWidth(), BI.getHeight()));
                this.dragImage.setSize(this.dragImage.getPreferredSize());
                this.repaintDragImage();
            }
        } else if (comp == null) {
            if (this.dragImage != null) {
                this.dragImage = null;
                this.parentComponent.repaint();
                this.draggedRenderer = null;
            }
        } else {
            this.dragPoint = point;
            this.repaintDragImage();
        }
    }

    private void repaintDragImage() {
        if (this.dragImage == null) {
            return;
        }
        int oldX = this.dragImage.getX();
        int oldY = this.dragImage.getY();
        this.dragImage.setLocation(this.dragPoint.x - this.offset.x, this.dragPoint.y - this.offset.y);
        this.dragImage.validate();
        this.parentComponent.repaint(Math.max(0, Math.min(oldX, this.dragImage.getX())), Math.max(0, Math.min(oldY, this.dragImage.getY())), Math.max(oldX, this.dragImage.getX()) + this.dragImage.getWidth(), Math.max(oldY, this.dragImage.getY()) + this.dragImage.getHeight());
    }
}

