/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.gui;

import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import ordermate.database.hardware.physical.kts.KTSCommand;
import ordermate.database.hardware.physical.kts.KTSDocketPrinter;
import ordermate.signals.Signal;
import utils.ktsmate.KTSMate;

public class KTSCommandDespatch
implements KeyEventDispatcher {
    public Map<Integer, KTSCommand> commandMap;
    public Map<Integer, KTSCommand> shiftCommandMap;
    public Stack<Signal<KTSCommand, ?, ?, ?, ?>> signals;

    public KTSCommandDespatch() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
        this.commandMap = new HashMap<Integer, KTSCommand>();
        this.shiftCommandMap = new HashMap<Integer, KTSCommand>();
        this.signals = new Stack();
    }

    public void pushSignal(Signal<KTSCommand, ?, ?, ?, ?> signal) {
        if (signal != null && !this.signals.contains(signal)) {
            this.signals.push(signal);
        }
    }

    public void popSignal() {
        this.signals.pop();
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        int keyPressed;
        if (e.getID() == 401 && (keyPressed = e.getKeyCode()) != 16) {
            if (e.isShiftDown()) {
                return this.doCommandWith(keyPressed, this.shiftCommandMap, e.getModifiers());
            }
            return this.doCommandWith(keyPressed, this.commandMap, e.getModifiers());
        }
        return true;
    }

    private boolean doCommandWith(int keyPressed, Map<Integer, KTSCommand> commands, int modifiers) {
        Signal<KTSCommand, ?, ?, ?, ?> signal;
        KTSDocketPrinter printer = KTSMate.getLocalPrinter();
        KTSCommand command = null;
        if (commands.containsKey(keyPressed)) {
            command = commands.get(keyPressed);
        } else {
            command = printer.getCommandForChar(keyPressed, modifiers);
            commands.put(keyPressed, command);
        }
        if (command != null && !this.signals.isEmpty() && (signal = this.signals.peek()) != null) {
            signal.emit((Object)command);
        }
        return true;
    }
}

