/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.gui;

import au.com.ordermate.guicore.task.CompositeTask;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import ordermate.OrderMate;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.serverconnection.ConnectionManagerScreen;
import utils.ktsmate.KTSMate;
import waitermate.guikit.task.RestartKTSMateTask;

public class KTSConnectionScreen
extends JPanel
implements ActionListener,
ConnectionManagerScreen {
    private JLabel retryLabel;
    private boolean showing;
    private boolean allTasksStarted = false;
    private static final Dimension size = new Dimension(600, 100);
    private WaitAndRestartTask waitAndRestartTask;

    public KTSConnectionScreen() {
        CompositeTask.allTasksStarted.connect((Object)this, "setAllTasksStarted");
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.getBackground().getAlpha() > 1) {
            g.setColor(this.getBackground());
            Rectangle clip = g.getClipBounds();
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
        }
        super.paintComponent(g);
    }

    public void setAllTasksStarted() {
        this.allTasksStarted = true;
    }

    public void setNumRetries(String server, int numRetry) {
        this.setPreferredSize(size);
        this.setSize(size);
        this.validate();
        this.repaint();
        String text = "Disconnected from server. Tried to connect to " + server + " " + numRetry;
        text = numRetry == 1 ? text + " time" : text + " times";
        this.retryLabel.setText(text);
    }

    public void showConnectionInterface() {
        this.setup();
        if (!this.showing && this.allTasksStarted) {
            this.showing = true;
            KTSMate.getFrame().showDisconnectionPanel(this);
            this.setVisible(true);
        }
    }

    private void setup() {
        this.setLayout(new BorderLayout());
        if (this.retryLabel == null) {
            this.retryLabel = new JLabel();
            this.add((Component)this.retryLabel, "South");
        }
        this.retryLabel.setText("Disconnected from Server - retrying...");
        this.retryLabel.setBackground(new Color(255, 100, 0, 120));
        this.retryLabel.setHorizontalAlignment(0);
        this.retryLabel.setFont(this.retryLabel.getFont().deriveFont(14));
        this.setOpaque(false);
        this.setBackground(new Color(120, 100, 80, 180));
        this.retryLabel.setVisible(true);
        this.retryLabel.setOpaque(true);
        this.retryLabel.setFont(OrderMateTheme.getLargeFont());
        this.retryLabel.setBorder(new LineBorder(new Color(255, 100, 0), 5));
        this.retryLabel.setPreferredSize(size);
    }

    public void hideConnectionInterface() {
        if (this.showing) {
            OrderMate.LOG.info("Hide connection interface");
            KTSMate.getFrame().showDisconnectionPanel(null);
            this.setVisible(false);
            this.showing = false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public void displayVersionWarningDialog(String serverVersion) {
        if (this.waitAndRestartTask == null) {
            this.waitAndRestartTask = new WaitAndRestartTask();
            Timer timer = new Timer();
            timer.schedule((TimerTask)this.waitAndRestartTask, 60000L);
            JOptionPane.showMessageDialog(null, "Server version " + serverVersion + " does not match the version " + OrderMate.VERSION, "Server version mismatch", 2);
            this.waitAndRestartTask.run();
        }
    }

    public void connectedToServer(boolean isRedundant, String connectedServer) {
    }

    class WaitAndRestartTask
    extends TimerTask {
        WaitAndRestartTask() {
        }

        @Override
        public void run() {
            try {
                new RestartKTSMateTask().runLocal();
            }
            catch (Exception e) {
                OrderMate.LOG.error("Could not restart KTSMate, terminating");
                System.exit(0);
            }
        }
    }
}

