/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.gui;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.pipeline.GenericPipe;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.EventList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import ordermate.OrderMate;
import ordermate.database.hardware.physical.kts.KTSCommand;
import ordermate.database.hardware.physical.kts.KTSDocketState;
import ordermate.database.sales.SalesItemSummary;
import ordermate.database.sales.printSummary.collecting.SalesItemSummaryCollection;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import utils.ktsmate.KTSMate;
import utils.ktsmate.docket.DefaultKTSListController;
import utils.ktsmate.docket.KTSDocket;
import utils.ktsmate.docket.KTSDocketStateEvent;
import utils.ktsmate.docket.KTSDocketStateListener;
import utils.ktsmate.gui.ConfigPopupDrawer;
import utils.ktsmate.gui.KTSConnectionScreen;
import utils.ktsmate.gui.configuration.KTSConfig;
import utils.ktsmate.gui.milestones.KTSMilestoneMonitorPool;
import utils.ktsmate.gui.summary.KTSSummaryPanel;
import utils.ktsmate.gui.views.AbstractDocketListView;
import utils.ktsmate.gui.views.BumpedView;
import utils.ktsmate.gui.views.HoldView;
import utils.ktsmate.gui.views.live.LiveView;
import utils.ktsmate.summary.KTSSummaryPipeline;
import utils.ktsmate.summary.KTSSummaryStrategyFactory;
import utils.ktsmate.summary.LocalKTSDocketSource;
import utils.ktsmate.summary.SalesItemSummaryGroupCollection;
import waitermate.guikit.ScreenResource;
import waitermate.guikit.components.DrawerToggleButton;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.PopupWindow;

public class KTSFrame
extends JFrame
implements KTSDocketStateListener {
    private static final Dimension DEFAULT_DIMENSION = new Dimension(1024, 768);
    private LiveView liveView;
    private AbstractDocketListView dialogedView = null;
    private ConfigPopupDrawer configDrawer;
    private DrawerToggleButton configButton;
    private Signal<KTSCommand, ?, ?, ?, ?> gotCommand;
    private KTSSummaryPipeline summaryPipeline = new KTSSummaryPipeline();
    private KTSSummaryPanel summaryPanel;
    private boolean started = false;
    private KTSConnectionScreen ktsConnectionScreen;

    public KTSFrame() {
        this.setSize(DEFAULT_DIMENSION);
        this.setDefaultCloseOperation(3);
        this.setTitle("TouchPrep XPress" + OrderMate.VERSION);
        this.getContentPane().setLayout(new BorderLayout());
        ScreenResource.GlassPanel glass = new ScreenResource.GlassPanel();
        this.setGlassPane(glass);
        glass.setVisible(true);
        this.setDefaultCloseOperation(3);
        if (!Config.isDebuging()) {
            this.setExtendedState(6);
            this.setUndecorated(true);
        }
        this.gotCommand = Signals.createSignal(KTSCommand.class, (String)"command");
        this.gotCommand.disconnectAll();
        this.gotCommand.connect((Object)this, "gotCommand");
        KTSMate.getKtsCommand().pushSignal(this.gotCommand);
        KTSMate.getListController().addDocketStateListener(this);
        KTSMate.setPolicy();
        ArrayList<Image> icons = new ArrayList<Image>();
        icons.add(IconLoader.get((String)"/ordermate/images/ktsmate_icon_16.png").getImage());
        icons.add(IconLoader.get((String)"/ordermate/images/ktsmate_icon_24.png").getImage());
        icons.add(IconLoader.get((String)"/ordermate/images/ktsmate_icon_32.png").getImage());
        icons.add(IconLoader.get((String)"/ordermate/images/ktsmate_icon_48.png").getImage());
        icons.add(IconLoader.get((String)"/ordermate/images/ktsmate_icon_256.png").getImage());
        this.setIconImages(icons);
        this.summaryPanel = new KTSSummaryPanel(new LocalKTSDocketSource(), this.summaryPipeline);
    }

    public void start() {
        this.setupLiveView();
        this.liveView.display();
        this.validate();
        this.setupSummary();
        this.validate();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                KTSFrame.this.refresh();
                KTSFrame.this.refresh();
            }
        });
        this.started = true;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void refresh() {
        this.setupSummary();
        this.getLiveView().setUp();
        this.repaint();
    }

    private void setupLiveView() {
        DefaultKTSListController controller = KTSMate.getListController();
        this.liveView = new LiveView(controller, controller);
        this.configButton = this.liveView.getNavBar().constructDrawerToggleButton("Configuration", IconLoader.get((String)"/utils/ktsmate/images/config.png"), IconLoader.get((String)"/utils/ktsmate/images/config.png"));
        this.configDrawer = new ConfigPopupDrawer();
        this.configButton.setDrawer(this.configDrawer);
        this.configDrawer.setBorder(new LineBorder(Color.GRAY, 2, true));
        this.liveView.getNavBar().addLeft(this.configButton, 0);
        this.configDrawer.colours.connect((Object)this, "gotColours");
        this.configDrawer.exit.connect((Object)this, "gotExit");
        this.configDrawer.fonts.connect((Object)this, "gotFonts");
        this.configDrawer.general.connect((Object)this, "gotGeneral");
        this.configDrawer.timers.connect((Object)this, "gotTimers");
        this.configDrawer.summary.connect((Object)this, "gotSummaryConfig");
        ScreenResource.setTargetFrameBorderLayout(this);
        this.liveView.showBump.disconnectAll();
        this.liveView.showBump.connect((Object)this, "gotShowBumped");
        this.liveView.showOnHold.disconnectAll();
        this.liveView.showOnHold.connect((Object)this, "gotShowHold");
        KTSMilestoneMonitorPool.getInstance().getMonitorFor(KTSDocketState.Live).setView(this.liveView);
    }

    private void setupSummary() {
        KTSSummaryStrategyFactory factory = new KTSSummaryStrategyFactory();
        this.summaryPipeline.setAggregationStrategy((GenericPipe<Collection<KTSDocket>, Collection<SalesItemSummary>>)factory.createAggregationStrategy());
        this.summaryPipeline.setGroupStrategy((GenericPipe<Collection<SalesItemSummary>, Collection<SalesItemSummaryCollection<?>>>)factory.createGroupingStrategy(KTSMate.getLocalPrinter().getSummaryGroupStrategy()));
        this.summaryPipeline.setGroupSortingStrategy((GenericPipe<Collection<SalesItemSummaryCollection<?>>, List<SalesItemSummaryCollection<?>>>)factory.createGroupSortingStrategy());
        this.summaryPipeline.setItemSortingStrategy((GenericPipe<List<SalesItemSummaryGroupCollection<?>>, List<SalesItemSummaryGroupCollection<?>>>)factory.createItemSortingStrategy(KTSMate.getLocalPrinter().getSummaryItemSortStrategy()));
        this.liveView.setShowBumpOutPanel(KTSMate.getLocalPrinter().getEnableSummaryPanel());
        this.liveView.setBumpOutPanelWidth(KTSMate.getLocalPrinter().getSummaryPanelColumns());
        if (KTSMate.getLocalPrinter().getEnableSummaryPanel()) {
            if (!this.liveView.isBumpOutPanelVisible()) {
                this.liveView.setBumpOutPanelContents(this.summaryPanel);
                this.liveView.viewParametersChanged();
            }
            this.summaryPanel.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gotShowBumped() {
        this.showView(new BumpedView(KTSMate.getListController()));
        boolean doBumped = false;
        if (!doBumped) {
            return;
        }
        EventList<KTSDocket> bumpedDockets = KTSMate.getListController().getDocketList(KTSDocketState.Bump);
        if (bumpedDockets.size() > 20) {
            bumpedDockets.getReadWriteLock().writeLock().lock();
            try {
                int count = 20;
                for (KTSDocket docket : bumpedDockets) {
                    if (count > 0) {
                        --count;
                        continue;
                    }
                    docket.collapse();
                }
            }
            catch (Exception ex) {
                OrderMate.LOG.error("cannot collapse bumped dockets", (Throwable)ex);
            }
            finally {
                bumpedDockets.getReadWriteLock().writeLock().unlock();
            }
        }
    }

    public void gotShowHold() {
        this.showView(new HoldView(KTSMate.getListController()));
    }

    private void showView(AbstractDocketListView toShow) {
        if (KTSMilestoneMonitorPool.getInstance().getMonitorFor(toShow.getViewState()) != null) {
            KTSMilestoneMonitorPool.getInstance().getMonitorFor(toShow.getViewState()).setView(toShow);
        }
        this.dialogedView = toShow;
        PopupWindow window = new PopupWindow(toShow.getNavBar(), false);
        window.setComponent(toShow.getMainArea());
        window.start();
        this.dialogedView = null;
        toShow.uncoupleListView();
        if (KTSMilestoneMonitorPool.getInstance().getMonitorFor(toShow.getViewState()) != null) {
            KTSMilestoneMonitorPool.getInstance().getMonitorFor(toShow.getViewState()).setView(null);
        }
    }

    public void gotColours() {
        this.doConfig(KTSConfig.KTSConfigState.Colours);
    }

    public void gotFonts() {
        this.doConfig(KTSConfig.KTSConfigState.Fonts);
    }

    public void gotGeneral() {
        this.doConfig(KTSConfig.KTSConfigState.General);
    }

    public void gotTimers() {
        this.doConfig(KTSConfig.KTSConfigState.Timers);
    }

    private void doConfig(KTSConfig.KTSConfigState state) {
        this.configButton.closeDrawer();
        KTSConfig.startState(state);
        this.refresh();
        KTSMilestoneMonitorPool.getInstance().getMonitorFor(KTSDocketState.Live).setView(this.liveView);
        this.liveView.viewParametersChanged();
        this.liveView.display();
    }

    public void gotExit() {
        this.configButton.closeDrawer();
        if (Dialogs.displayChoiceDialog("Exit?", "<html>This will close the KTSMate Application<br><br><b>Do you really wish to exit?</b></html>", true)) {
            System.exit(0);
        }
    }

    public void gotSummaryConfig() {
        this.doConfig(KTSConfig.KTSConfigState.Summary);
        this.summaryPanel.refresh();
        this.liveView.viewParametersChanged();
    }

    LiveView getLiveView() {
        return this.liveView;
    }

    AbstractDocketListView getCurrentView() {
        if (this.dialogedView == null) {
            return this.liveView;
        }
        return this.dialogedView;
    }

    public void gotCommand(KTSCommand command) {
        if (KTSCommand.Configuration.equals((Object)command)) {
            boolean isConfigOpen = this.configButton.isSelected();
            if (isConfigOpen) {
                this.configButton.closeDrawer();
            } else {
                this.configButton.openDrawer();
                this.configDrawer.focusFirstButton();
            }
            this.configButton.setSelected(!isConfigOpen);
        } else if (this.dialogedView != null) {
            this.dialogedView.doCommand(command);
        } else if (this.configButton.isSelected()) {
            this.doConfigCommand(command);
        } else if (KTSConfig.getCurrentConfig() != null) {
            KTSConfig.getCurrentConfig().doCommand(command);
        } else if (ScreenResource.isDialogShowing()) {
            this.dialogResponse(command);
        } else {
            this.liveView.doCommand(command);
        }
    }

    private void doConfigCommand(KTSCommand command) {
        if (KTSCommand.Cancel.equals((Object)command)) {
            this.configButton.closeDrawerSlamShut();
            this.configButton.setSelected(false);
        } else if (KTSCommand.Up.equals((Object)command)) {
            this.configDrawer.cycleFocus(true);
        } else if (KTSCommand.Down.equals((Object)command)) {
            this.configDrawer.cycleFocus(false);
        } else if (KTSCommand.Ok.equals((Object)command)) {
            this.configDrawer.fireFocussedButton();
        }
    }

    private void dialogResponse(KTSCommand command) {
        Component comp;
        JDialog dog = ScreenResource.getDialogs().iterator().next();
        if (dog != null && (comp = dog.getContentPane().getComponent(0)) instanceof PopupWindow) {
            if (KTSCommand.Ok.equals((Object)command)) {
                ((PopupWindow)comp).getNavBar().ok.emit();
            } else if (KTSCommand.Cancel.equals((Object)command)) {
                ((PopupWindow)comp).getNavBar().cancel.emit();
            }
        }
    }

    ConfigPopupDrawer getConfigDrawer() {
        return this.configDrawer;
    }

    @Override
    public void docketStateChanged(KTSDocketStateEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                KTSFrame.this.refresh();
            }
        });
    }

    public void showDisconnectionPanel(KTSConnectionScreen theScreen) {
        if (theScreen != null) {
            this.ktsConnectionScreen = theScreen;
            ScreenResource.startModalWindow(theScreen);
        } else if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ScreenResource.stopWindow(KTSFrame.this.ktsConnectionScreen);
                    KTSFrame.this.validate();
                    KTSFrame.this.repaint();
                }
            });
        } else {
            ScreenResource.stopWindow(this.ktsConnectionScreen);
            this.validate();
            this.repaint();
        }
    }
}

