/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.gui;

import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.HtmlBuilder;
import au.com.ordermate.util.StringUtils;
import java.awt.Color;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import ordermate.OrderMate;
import ordermate.database.hardware.physical.kts.KTSDocketPrinter;
import ordermate.database.hardware.physical.kts.KTSProperty;
import ordermate.database.hardware.physical.kts.KTSPropertyType;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.Customer;
import ordermate.database.sales.OnlineAccount;
import ordermate.database.sales.PhoneAccount;
import ordermate.internationalization.Internationalization;
import utils.ktsmate.KTSMate;
import utils.ktsmate.docket.KTSDocket;

public class KTSUIHelper {
    private static final String DRIVE_THRU = "Drive Thru";
    private static final String PHONE_PICKUP = "Phone Pickup";
    private static final String PHONE_DELIVERY = "Phone Delivery";
    private static final String ONLINE_PICKUP = "Online Pickup";
    private static final String ONLINE_DELIVERY = "Online Delivery";
    private static final String BAR_TAB = "BarTab: ";
    private static final String DINE_IN = "D/I #";
    private static final String TAKEAWAY = "T/A #";
    private static final String TABLE = "Table";
    private static final String ONLINE_TABLE = "Online Table";
    private static final DateTimeUtils.ThreadLocalDateFormat TIME_FORMAT = new DateTimeUtils.ThreadLocalDateFormat((DateFormat)new SimpleDateFormat("h:mm a"));
    private static final DateTimeUtils.ThreadLocalDateFormat TIME_DATE_FORMAT = new DateTimeUtils.ThreadLocalDateFormat((DateFormat)new SimpleDateFormat("dd-MM h:mm a"));
    private static KTSUIHelper instance;
    private KTSDocketPrinter printer;
    private Map<String, List<KTSProperty>> propMap = new HashMap<String, List<KTSProperty>>();

    public static final KTSUIHelper getInstance() {
        if (instance == null) {
            instance = new KTSUIHelper();
        }
        return instance;
    }

    public static DateTimeUtils.ThreadLocalDateFormat getTimeDateFormat() {
        return TIME_DATE_FORMAT;
    }

    public static final void reinitialise() {
        instance = null;
    }

    private KTSUIHelper() {
        this.printer = KTSMate.getLocalPrinter();
        if (this.printer != null) {
            for (KTSProperty prop : this.printer.getKtsProperties()) {
                String key = prop.getKey();
                List<KTSProperty> propList = this.propMap.get(key);
                if (propList == null) {
                    propList = new ArrayList<KTSProperty>();
                    this.propMap.put(key, propList);
                }
                propList.add(prop);
            }
        }
    }

    public List<KTSProperty> getProperties(String key) {
        return this.propMap.get(key);
    }

    public static final String makeTimeString(long time) {
        StringBuilder SB = new StringBuilder();
        int minutes = (int)(time / 60L);
        if (minutes < 10) {
            SB.append("0");
        }
        SB.append(minutes);
        SB.append(":");
        int seconds = (int)(time % 60L);
        if (seconds < 10) {
            SB.append("0");
        }
        SB.append(seconds);
        return SB.toString();
    }

    public static final String makeDueTimeString(Date time) {
        return KTSUIHelper.makeDueTimeString(TIME_FORMAT, time);
    }

    public static final String makeDueTimeString(DateTimeUtils.ThreadLocalDateFormat format, Date time) {
        return ((DateFormat)format.get()).format(time);
    }

    public void applyOrderNumber(JLabel label, Account account) {
        if (this.shouldDisplayOrderNumber(account)) {
            List<KTSProperty> ktsProperties = this.propMap.get("Header Order Number " + account.getType());
            label.setText(this.getOrderNumber(account));
            this.applyLabelProps(label, ktsProperties);
        } else {
            label.setText("");
        }
    }

    public void applyAccountNumber(JLabel label, Account account) {
        if (this.shouldDisplayAccountNumber(account)) {
            List<KTSProperty> ktsProperties = this.propMap.get("Header Account Number");
            label.setText(this.getAccountNumber(account));
            this.applyLabelProps(label, ktsProperties);
        } else {
            label.setText("");
        }
    }

    public void applyDueTime(JLabel dueLabel, Account account) {
        if (this.shouldDisplayDueTime()) {
            List<KTSProperty> ktsProperties = this.propMap.get("Header Time Due");
            dueLabel.setText(this.getDueData(account));
            this.applyLabelProps(dueLabel, ktsProperties);
        } else {
            dueLabel.setText("");
        }
    }

    private String getDueData(Account account) {
        AccountType type = account.getAccountType();
        String text = null;
        if ((PhoneAccount.TYPE.equals((Object)type) || AccountType.onlineDeliveryType.equals((Object)type) || AccountType.onlinePickupType.equals((Object)type) || PhoneAccount.DELIVERY_TYPE.equals((Object)type)) && ((PhoneAccount)account).hasTimeDue()) {
            Date d = account.getDateDue();
            if (d == null) {
                d = account.getCreationDateTime();
            }
            text = !DateTimeUtils.dateIsToday((Date)d) ? "<html><b>Due:</b> " + KTSUIHelper.makeDueTimeString(KTSUIHelper.getTimeDateFormat(), DateTimeUtils.combineDateAndTime((Date)d, (Date)account.getTimeDue())) + "</html>" : "<html><b>Due:</b> " + KTSUIHelper.makeDueTimeString(((PhoneAccount)account).getTimeDue()) + "</html>";
        }
        return text;
    }

    public void applyUserName(JLabel label, KTSDocket myDocket) {
        if (this.shouldDisplayUserName()) {
            List<KTSProperty> ktsProperties = this.propMap.get("Header User Name");
            label.setText(this.getUserName(myDocket));
            this.applyLabelProps(label, ktsProperties);
        } else {
            label.setText("");
        }
    }

    public void applyETA(JLabel etaLabel, Account account) {
        if (this.shouldDisplayETA()) {
            String ETA = "ETA";
            AccountType incomingAccountType = account.getAccountType();
            Collection onlineAccountTypes = AccountType.getOnlineAccountTypes();
            if (onlineAccountTypes.contains(incomingAccountType)) {
                String key = "Header Account Name " + incomingAccountType.toString();
                KTSDocketPrinter docketPrinter = KTSMate.getLocalPrinter();
                List ktsProperties = docketPrinter.getKtsProperties();
                for (KTSProperty property : ktsProperties) {
                    String value = property.getValue();
                    if (!key.equals(property.getKey()) || !"ETA".equalsIgnoreCase(value) || account.getEta() == null) continue;
                    HtmlBuilder builder = new HtmlBuilder();
                    builder.appendBold("ETA: ").append(KTSUIHelper.makeDueTimeString(KTSUIHelper.getTimeDateFormat(), account.getEta()));
                    etaLabel.setText(builder.toString());
                    etaLabel.setVisible(true);
                }
            }
        } else {
            etaLabel.setText("");
            etaLabel.setVisible(false);
        }
    }

    public void applyTicketData(JLabel ticketDataLabel, Account account) {
        if (this.shouldDisplayTicketData()) {
            this.setTicketDataLabel(ticketDataLabel, account);
        } else {
            ticketDataLabel.setText("");
            ticketDataLabel.setVisible(false);
        }
    }

    private void setTicketDataLabel(JLabel ticketDataLabel, Account account) {
        if (account.hasTicketData()) {
            List data = account.getTicketData();
            StringBuilder SB = new StringBuilder();
            for (String nextData : data) {
                SB.append(nextData).append(" ");
            }
            String ticketDataString = KTSUIHelper.getInstance().applyProps(SB.toString(), KTSUIHelper.getInstance().getProperties("Ticket Data Name"));
            ticketDataLabel.setText(ticketDataString);
            ticketDataLabel.setVisible(!StringUtils.isEmpty((String)ticketDataString.trim()));
        } else {
            ticketDataLabel.setText("");
            ticketDataLabel.setVisible(false);
        }
    }

    public void applyCustomer(JLabel customerLabel, JLabel addressStreetLabel, JLabel addressSuburbLabel, Account account) {
        if (this.shouldDisplayCustomerInfo()) {
            this.setCustomerLabels(customerLabel, addressStreetLabel, addressSuburbLabel, account);
        } else {
            customerLabel.setText("");
            addressStreetLabel.setText("");
            addressSuburbLabel.setText("");
            customerLabel.setVisible(false);
            addressStreetLabel.setVisible(false);
            addressSuburbLabel.setVisible(false);
        }
    }

    private void setCustomerLabels(JLabel customerLabel, JLabel addressStreetLabel, JLabel addressSuburbLabel, Account account) {
        if (account.getCustomer() != null) {
            String line = KTSUIHelper.getInstance().getCustomerLine(account);
            customerLabel.setText(line);
            customerLabel.setVisible(!StringUtils.isEmpty((String)line));
        } else {
            customerLabel.setVisible(false);
        }
        if (account.isDeliverable()) {
            StringBuilder SB = new StringBuilder("");
            KTSUIHelper.getInstance().appendCustomerStreetAddress(SB, account);
            addressStreetLabel.setText(SB.toString());
            addressStreetLabel.setVisible(true);
            SB = new StringBuilder("");
            KTSUIHelper.getInstance().appendCustomerSuburbAddress(SB, account);
            addressSuburbLabel.setText(SB.toString());
            addressSuburbLabel.setVisible(true);
        } else {
            addressStreetLabel.setText("");
            addressStreetLabel.setVisible(false);
            addressSuburbLabel.setText("");
            addressSuburbLabel.setVisible(false);
        }
    }

    public void applyOrderExtId(JLabel label, Account account) {
        if (this.shouldDisplayExtOrderId(account)) {
            List<KTSProperty> ktsProperties = this.propMap.get("Header Order External Ref");
            label.setText(this.getExtOrderId(account));
            this.applyLabelProps(label, ktsProperties);
        } else {
            label.setText("");
        }
    }

    public void applyOrderAlternateId(JLabel label, Account account) {
        if (this.shouldDisplayExtOrderAltId(account)) {
            List<KTSProperty> ktsProperties = this.propMap.get("Header Order Alternate Ref");
            String href = account.getExtHRef();
            if (!StringUtils.isEmpty((String)account.getExtOrderID()) && href.contains(account.getExtOrderID())) {
                label.setText("Ref: " + account.getExtOrderID());
            } else {
                label.setText("Ref: " + href);
                this.applyLabelProps(label, ktsProperties);
            }
        } else {
            label.setText("");
        }
    }

    public void applyAccountName(JLabel label, Account account) {
        String text;
        AccountType type = account.getAccountType();
        String propsKey = "Header Account Name " + account.getType();
        List<KTSProperty> props = this.getProperties(propsKey);
        if (AccountType.phoneType.equals((Object)type)) {
            text = this.applyProps(PHONE_PICKUP, props);
        } else if (AccountType.deliveryType.equals((Object)type)) {
            text = this.applyProps(PHONE_DELIVERY, props);
        } else if (AccountType.onlinePickupType.equals((Object)type)) {
            text = this.applyProps(ONLINE_PICKUP, props);
        } else if (AccountType.onlineDeliveryType.equals((Object)type)) {
            text = this.applyProps(ONLINE_DELIVERY, props);
        } else if (AccountType.driveThruType.equals((Object)type)) {
            text = this.applyProps(DRIVE_THRU, props);
        } else if (AccountType.onlineTableType.equals((Object)type)) {
            text = this.applyProps(account.getLabel(), props);
        } else if (AccountType.tableType.equals((Object)type)) {
            text = this.applyProps(account.getLabel(), props);
        } else if (AccountType.barTabType.equals((Object)type)) {
            StringBuilder SB = new StringBuilder();
            SB.append(BAR_TAB).append(account.getLabel());
            text = this.applyProps(SB.toString(), props);
        } else if (AccountType.takeawayType.equals((Object)type)) {
            StringBuilder SB = new StringBuilder();
            SB.append(TAKEAWAY).append(account.getLabel());
            text = this.applyProps(SB.toString(), props);
        } else if (AccountType.quickSaleDineInType.equals((Object)type)) {
            StringBuilder SB = new StringBuilder();
            SB.append(DINE_IN).append(account.getLabel());
            text = this.applyProps(SB.toString(), props);
        } else {
            text = this.getGenericAccountString(account);
        }
        label.setText(text);
        this.applyLabelProps(label, props);
    }

    private void applyLabelProps(JLabel label, List<KTSProperty> props) {
        if (props == null || props.isEmpty()) {
            return;
        }
        for (KTSProperty prop : props) {
            switch (prop.getType()) {
                case FG: {
                    Color fgColor = this.getColour(prop.getValue());
                    if (fgColor == null) break;
                    label.setForeground(fgColor);
                    break;
                }
                case BG: {
                    Color bgColor = this.getColour(prop.getValue());
                    if (bgColor != null) {
                        label.setBackground(bgColor);
                    }
                    label.setOpaque(bgColor != null);
                    break;
                }
            }
        }
    }

    private Color getColour(String value) {
        if (value == null) {
            return null;
        }
        try {
            return new Color(Integer.parseInt(value));
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Cannot cast to integer or out of range", (Throwable)ex);
            return null;
        }
    }

    private boolean isShow(String ktsPropertyName, boolean showByDefault) {
        List<KTSProperty> ktsProperties = this.propMap.get(ktsPropertyName);
        if (ktsProperties != null && ktsProperties.size() > 0) {
            for (KTSProperty ktsProperty : ktsProperties) {
                String value;
                if (ktsProperty.getType() != KTSPropertyType.Show || (value = ktsProperty.getValue()) == null) continue;
                return Boolean.TRUE.toString().equalsIgnoreCase(ktsProperty.getValue());
            }
        }
        return showByDefault;
    }

    private boolean shouldDisplayOrderNumber(Account account) {
        if (this.isShow("Header Order Number " + account.getType(), false)) {
            return true;
        }
        return this.isShow("Header Order Number " + AccountType.allType.getType(), false);
    }

    private boolean shouldDisplayAccountNumber(Account account) {
        return this.isShow("Header Account Number", false);
    }

    private boolean shouldDisplayUserName() {
        return this.isShow("Header User Name", true);
    }

    private boolean shouldDisplayETA() {
        return this.isShow("Header ETA", true);
    }

    private boolean shouldDisplayCustomerInfo() {
        return this.isShow("Header Customer Info", true);
    }

    private boolean shouldDisplayTicketData() {
        return this.isShow("Ticket Data Name", true);
    }

    private boolean shouldDisplayDueTime() {
        return this.isShow("Header Time Due", true);
    }

    private boolean shouldDisplayExtOrderId(Account account) {
        if (account.getExtOrderID() == null || account.getExtOrderID().isEmpty()) {
            return false;
        }
        return this.isShow("Header Order External Ref", true);
    }

    private boolean shouldDisplayExtOrderAltId(Account account) {
        if (StringUtils.isEmpty((String)account.getExtHRef())) {
            return false;
        }
        return this.isShow("Header Order Alternate Ref", false);
    }

    private String getOrderNumber(Account account) {
        return Internationalization.getLiteralFor((String)"ORDER") + " : " + account.getOrderNumber();
    }

    private String getAccountNumber(Account account) {
        return String.valueOf(account.getID());
    }

    private String getUserName(KTSDocket myDocket) {
        String text = myDocket.getAccount() instanceof OnlineAccount ? "<html><b>From:</b> " + ((OnlineAccount)myDocket.getAccount()).getSource() + "</html>" : "<html><b>User:</b> " + myDocket.getUser() + "</html>";
        return text;
    }

    private String getExtOrderId(Account account) {
        return Internationalization.getLiteralFor((String)"ORDER_EXT_REF") + " : " + account.getExtOrderID();
    }

    private String getGenericAccountString(Account account) {
        StringBuilder SB = new StringBuilder();
        SB.append(this.applyProps(account.getLabel(), this.getProperties("Header Account Name ")));
        List<KTSProperty> props = this.getProperties("Header Account Number");
        if (props != null) {
            SB.append(this.applyProps(" #" + account.getOrderNumber(), props));
        }
        return SB.toString();
    }

    private void appendCustomer(StringBuilder SB, Account account) {
        Customer customer = account.getCustomer();
        if (customer != null) {
            this.appendIfNotNull(SB, customer.getFirstName());
            this.appendIfNotNull(SB, " " + customer.getLastName());
        } else {
            SB.append("No Customer");
        }
    }

    public void appendCustomerStreetAddress(StringBuilder sb, Account account) {
        Customer customer = account.getCustomer();
        if (customer != null) {
            if (customer.getRoomAptNumber() != null && !customer.getRoomAptNumber().trim().equals("")) {
                sb.append(customer.getRoomAptNumber() + "/");
            }
            this.appendIfNotNull(sb, customer.getHouseNumber() + " ");
            this.appendIfNotNull(sb, customer.getStreetName() + " ");
            this.appendIfNotNull(sb, customer.getStreetType());
        }
    }

    public void appendCustomerSuburbAddress(StringBuilder sb, Account account) {
        Customer customer = account.getCustomer();
        if (customer != null) {
            this.appendIfNotNull(sb, customer.getSuburb() + " ");
            this.appendIfNotNull(sb, customer.getPostcode());
        }
    }

    private void appendIfNotNull(StringBuilder sb, String toAppend) {
        if (toAppend != null && !toAppend.trim().equals("")) {
            sb.append(toAppend);
        }
    }

    public String applyProps(String string, List<KTSProperty> props) {
        if (string == null || props == null || props.isEmpty()) {
            return string;
        }
        String modified = string;
        for (KTSProperty prop : props) {
            String value = prop.getValue();
            switch (prop.getType()) {
                case Prefix: {
                    modified = value + modified;
                    break;
                }
                case Suffix: {
                    modified = modified + value;
                    break;
                }
                case Replace: {
                    String[] replace = value.split("=");
                    if (replace.length != 2) break;
                    modified = modified.replace(replace[0], replace[1]);
                    break;
                }
                case Show: {
                    if (!Boolean.FALSE.toString().equalsIgnoreCase(prop.getValue())) break;
                    return "";
                }
            }
        }
        return modified;
    }

    public String getCustomerLine(Account account) {
        StringBuilder SB = new StringBuilder("<html><b>Cust:</b> ");
        KTSUIHelper.getInstance().appendCustomer(SB, account);
        SB.append("</html>");
        return this.applyProps(SB.toString(), this.getProperties("Customer Name"));
    }

    public KTSProperty getPropertyFor(String key, KTSPropertyType type) {
        List<KTSProperty> props = this.propMap.get(key);
        if (props != null && !props.isEmpty()) {
            for (KTSProperty prop : props) {
                if (!type.equals((Object)prop.getType())) continue;
                return prop;
            }
        }
        return null;
    }
}

