/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.gui;

import java.awt.Color;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractButton;
import javax.swing.SwingUtilities;

public class NavButtonFlasher {
    private Timer timer;
    private boolean flashUp = true;
    private Color color;
    private AbstractButton button;

    public NavButtonFlasher(AbstractButton yourComponent) {
        this.button = yourComponent;
    }

    public void startFlashing(Color newColor) {
        if (newColor == null) {
            this.stop();
        } else if (!newColor.equals(this.color)) {
            this.stop();
            this.color = newColor;
            this.timer = new Timer();
            this.button.putClientProperty("substancelaf.componentFlat", Boolean.FALSE);
            this.button.setBorderPainted(false);
            this.button.setContentAreaFilled(false);
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (NavButtonFlasher.this.button.isDisplayable()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (NavButtonFlasher.this.flashUp) {
                                    NavButtonFlasher.this.button.setContentAreaFilled(true);
                                    NavButtonFlasher.this.button.setBackground(NavButtonFlasher.this.color);
                                } else {
                                    NavButtonFlasher.this.button.setContentAreaFilled(false);
                                    NavButtonFlasher.this.button.setBackground(null);
                                }
                                NavButtonFlasher.this.flashUp = !NavButtonFlasher.this.flashUp;
                            }
                        });
                    } else {
                        NavButtonFlasher.this.stop();
                    }
                }
            }, 500L, 500L);
        }
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
            this.button.setBackground(null);
            this.button.setContentAreaFilled(false);
            this.button.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
            this.timer = null;
            this.color = null;
            this.flashUp = true;
        }
    }
}

