/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.gui.configuration;

import au.com.ordermate.util.image.IconLoader;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import ordermate.database.hardware.physical.kts.KTSCommand;
import utils.ktsmate.KTSMate;
import utils.ktsmate.gui.configuration.ColoursConfigPanel;
import utils.ktsmate.gui.configuration.FontsConfigPanel;
import utils.ktsmate.gui.configuration.GeneralConfigPanel;
import utils.ktsmate.gui.configuration.KTSConfigPanel;
import utils.ktsmate.gui.configuration.SummaryConfigPanel;
import utils.ktsmate.gui.configuration.TimersConfigPanel;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.PopupWindow;

public class KTSConfig
extends AbstractScreen {
    public static KTSConfig currentConfig;
    private NavBar nav;
    private KTSConfigPanel mainPanel;
    private KTSConfigState state;
    private JButton okButton;
    private JButton cancelButton;

    private KTSConfig(KTSConfigState theState) {
        this.state = theState;
        this.setupComponents();
        this.mainPanel.setPrinter(KTSMate.getLocalPrinter());
    }

    private void setupComponents() {
        this.nav = new NavBar();
        this.nav.ok.connect((Object)this, "gotOk");
        this.nav.cancel.connect((Object)this, "gotCancel");
        this.okButton = this.nav.constructButton((Icon)IconLoader.get((String)"/utils/ktsmate/images/ok.png"), "", "okButton", this.nav.ok);
        this.cancelButton = this.nav.constructButton((Icon)IconLoader.get((String)"/utils/ktsmate/images/back.png"), "", "backButton", this.nav.cancel);
        this.nav.addLeft(this.cancelButton);
        this.nav.addRight(this.okButton);
        if (this.state.equals((Object)KTSConfigState.General)) {
            this.mainPanel = new GeneralConfigPanel();
        } else if (this.state.equals((Object)KTSConfigState.Colours)) {
            this.mainPanel = new ColoursConfigPanel();
        } else if (this.state.equals((Object)KTSConfigState.Fonts)) {
            this.mainPanel = new FontsConfigPanel();
        } else if (this.state.equals((Object)KTSConfigState.Timers)) {
            this.mainPanel = new TimersConfigPanel();
        } else if (this.state.equals((Object)KTSConfigState.Summary)) {
            this.mainPanel = new SummaryConfigPanel();
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.mainPanel.setPreferredSize(new Dimension(Math.min((int)((double)screenSize.width * 0.8), 800), Math.min((int)((double)screenSize.height * 0.8), 500)));
    }

    public boolean doCommand(KTSCommand command) {
        if (KTSCommand.Ok.equals((Object)command)) {
            this.okButton.doClick();
            return true;
        }
        if (KTSCommand.Cancel.equals((Object)command)) {
            this.cancelButton.doClick();
            return true;
        }
        this.mainPanel.doCommand(command);
        return false;
    }

    @Override
    public JComponent getMainArea() {
        return this.mainPanel;
    }

    @Override
    public NavBar getNavBar() {
        return this.nav;
    }

    public void gotOk() {
        currentConfig = null;
        this.mainPanel.getBindingHelper().saveObject();
        KTSMate.getLocalPrinter().save();
        KTSMate.refreshPrinter();
    }

    public void gotCancel() {
        currentConfig = null;
        KTSMate.refreshPrinter();
    }

    public static KTSConfig getCurrentConfig() {
        return currentConfig;
    }

    public static void startState(KTSConfigState state) {
        if (state != null) {
            KTSConfig config = new KTSConfig(state);
            PopupWindow popup = new PopupWindow(config.getNavBar());
            popup.setComponent(config.getMainArea());
            currentConfig = config;
            popup.start();
        }
    }

    public static enum KTSConfigState {
        General,
        Colours,
        Fonts,
        Timers,
        Summary;

    }
}

