/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.gui.configuration;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.hardware.physical.kts.KTSCommand;
import ordermate.database.hardware.physical.kts.KTSDocketPrinter;
import ordermate.gui.LimitedColorSelector;
import ordermate.gui.PlusMinusPanel;
import ordermate.gui.binding.BindingHelper;
import ordermate.gui.themes.OrderMateTheme;
import org.jdesktop.beansbinding.AutoBinding;

abstract class KTSConfigPanel
extends JPanel {
    private BindingHelper<KTSDocketPrinter> helper = new BindingHelper(AutoBinding.UpdateStrategy.READ_WRITE);
    protected static final Font DEF_FONT = new Font("SansSerif", 0, 18);

    public KTSConfigPanel() {
        this.setupComponents();
    }

    protected abstract void setupComponents();

    protected JComponent createIntegerPanel(PropertiedObject.Property property, Integer lowerBound, Integer upperBound) {
        return this.createIntegerPanel(property, lowerBound, upperBound, 1);
    }

    protected JComponent createIntegerPanel(PropertiedObject.Property property, Integer lowerBound, Integer upperBound, int increment) {
        PlusMinusPanel panel = new PlusMinusPanel(lowerBound, upperBound);
        panel.setIncrement(increment);
        panel.setFont(DEF_FONT);
        this.helper.createBinding(property, (Object)panel, "value");
        panel.setPlusMinusText(null, null);
        panel.setPlusMinusIcons((Icon)IconLoader.get((String)"/ordermate/images/plus.png"), (Icon)IconLoader.get((String)"/ordermate/images/minus.png"));
        return panel;
    }

    protected JComponent createColourChooser(PropertiedObject.Property property) {
        LimitedColorSelector selector = new LimitedColorSelector(false);
        selector.allowNull(true);
        selector.setFont(DEF_FONT);
        this.helper.createBinding(property, selector.getComboBox(), "selectedItem");
        selector.setAvailableColors(null);
        selector.setColorChooserVisible(true);
        selector.setColorChooserEnabled(true);
        return selector;
    }

    protected JComponent createBooleanComponent(PropertiedObject.Property property) {
        JCheckBox box = new JCheckBox();
        OrderMateTheme.setupTransparentButton((AbstractButton)box);
        box.setFont(DEF_FONT);
        this.helper.createBinding(property, (Object)box, "selected");
        return box;
    }

    protected JComboBox createChoiceComponent(PropertiedObject.Property property, Object[] choices) {
        JComboBox<Object> box = new JComboBox<Object>(choices);
        box.setFont(OrderMateTheme.getLargeFont());
        box.setPreferredSize(new Dimension(300, 60));
        box.setMaximumRowCount(5);
        this.helper.createBinding(property, box, "selectedItem");
        return box;
    }

    protected JLabel makeDefaultLabel(String name) {
        JLabel label = new JLabel(name);
        label.setFont(DEF_FONT);
        return label;
    }

    protected BindingHelper<KTSDocketPrinter> getBindingHelper() {
        return this.helper;
    }

    public void setPrinter(KTSDocketPrinter localPrinter) {
        this.helper.setObject((Object)localPrinter);
    }

    public void doCommand(KTSCommand command) {
        if (KTSCommand.Up.equals((Object)command)) {
            if (!this.isFocusable()) {
                this.setFocusable(true);
            }
            if (!this.hasFocus()) {
                this.requestFocusInWindow();
            }
            this.transferFocusBackward();
        } else if (KTSCommand.Down.equals((Object)command)) {
            this.transferFocus();
        }
    }
}

