/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.gui.milestones;

import ca.odell.glazedlists.EventList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JComponent;
import ordermate.database.hardware.physical.kts.KTSDocketState;
import ordermate.database.hardware.physical.kts.KTSMilestoneAction;
import utils.ktsmate.docket.KTSDocket;
import utils.ktsmate.docket.KTSListController;
import utils.ktsmate.gui.NavButtonFlasher;
import utils.ktsmate.gui.milestones.highlighter.HighlightController;
import utils.ktsmate.gui.milestones.highlighter.LineBorderHighlighter;
import utils.ktsmate.gui.milestones.highlighter.ToggledHighlightController;
import utils.ktsmate.gui.views.AbstractDocketListView;
import utils.ktsmate.milestones.KTSMilestoneManager;
import utils.ktsmate.milestones.Milestone;

public class KTSMilestoneMonitor<T extends AbstractDocketListView> {
    private static final int HIGHLIGHT_UPDATE_DELAY = 500;
    private T myView = null;
    private final KTSDocketState myState;
    private final KTSMilestoneManager manager;
    private final List<KTSDocket> docketList;
    private Map<Milestone, HighlightController> highlighterMap;
    private Milestone highestMilestone;
    private NavButtonFlasher nextButtonFlasher;
    private NavButtonFlasher prevButtonFlasher;
    private KTSListController listController;

    public KTSMilestoneMonitor(KTSDocketState yourState, KTSListController ktsListController) {
        this.myState = yourState;
        if (this.myState == null) {
            throw new IllegalStateException("Cannot have a null state monitor.");
        }
        this.manager = KTSMilestoneManager.getInstance();
        if (this.manager == null) {
            throw new IllegalStateException("The Milestones Manager must be setup before a monitor can be used.");
        }
        this.listController = ktsListController;
        if (this.listController == null) {
            throw new IllegalStateException("The ListController cannot be null. From where will the dockets come?");
        }
        this.highlighterMap = new HashMap<Milestone, HighlightController>();
        this.makeHighlighters();
        this.docketList = new ArrayList<KTSDocket>();
    }

    public void setView(T yourView) {
        if (yourView == null) {
            this.myView = null;
            if (this.nextButtonFlasher != null) {
                this.nextButtonFlasher.stop();
                this.prevButtonFlasher.stop();
                this.nextButtonFlasher = null;
                this.prevButtonFlasher = null;
            }
        } else if (this.myState.equals((Object)((AbstractDocketListView)yourView).getViewState())) {
            this.myView = yourView;
            this.nextButtonFlasher = new NavButtonFlasher(((AbstractDocketListView)this.myView).getNavBar().getNextButton());
            this.prevButtonFlasher = new NavButtonFlasher(((AbstractDocketListView)this.myView).getNavBar().getPreviousButton());
        } else {
            throw new IllegalArgumentException("Cannot set the view for a different state. My state:" + this.myState + " View's state:" + ((AbstractDocketListView)yourView).getViewState());
        }
    }

    private void makeHighlighters() {
        List<Milestone> milestones = this.manager.getMilestones();
        for (Milestone milestone : milestones) {
            LineBorderHighlighter highlighter = new LineBorderHighlighter(milestone.getColor(), milestone.getThickness());
            if (KTSMilestoneAction.Flash.equals((Object)milestone.getAction())) {
                this.highlighterMap.put(milestone, new ToggledHighlightController(highlighter));
                continue;
            }
            this.highlighterMap.put(milestone, new HighlightController(highlighter));
        }
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                for (HighlightController controller : KTSMilestoneMonitor.this.highlighterMap.values()) {
                    controller.performHighlight();
                }
            }
        }, 500L, 500L);
    }

    void renderMilestones() {
        this.docketList.clear();
        EventList<KTSDocket> dockets = this.listController.getDocketList(this.myState);
        dockets.getReadWriteLock().writeLock().lock();
        this.docketList.addAll((Collection<KTSDocket>)this.listController.getDocketList(this.myState));
        dockets.getReadWriteLock().writeLock().unlock();
        if (this.myView != null) {
            this.updateRenderers();
        }
        this.updateHighestMilestone();
    }

    private void updateRenderers() {
        Milestone previousPageMilestone = null;
        Milestone nextPageMilestone = null;
        for (KTSDocket docket : this.docketList) {
            Milestone milestone = this.manager.getMilestoneForDocket(docket);
            Integer page = ((AbstractDocketListView)this.myView).getRelativePageFor(docket);
            if (page == null) continue;
            if (page == 0) {
                this.updateRenderer(docket, milestone);
                continue;
            }
            if (page < 0) {
                if (previousPageMilestone != null && (milestone == null || previousPageMilestone.getMilliSeconds() >= milestone.getMilliSeconds())) continue;
                previousPageMilestone = milestone;
                continue;
            }
            if (nextPageMilestone != null && (milestone == null || nextPageMilestone.getMilliSeconds() >= milestone.getMilliSeconds())) continue;
            nextPageMilestone = milestone;
        }
        this.updatePageMilestones(previousPageMilestone, nextPageMilestone);
    }

    private void updateRenderer(KTSDocket docket, Milestone milestone) {
        JComponent component = ((AbstractDocketListView)this.myView).getRendererFor(docket);
        HighlightController controller = this.highlighterMap.get(milestone);
        if (controller != null && !controller.isHighlightingComponent(component)) {
            for (HighlightController nextController : this.highlighterMap.values()) {
                nextController.stopHighlightingComponent(component);
            }
            controller.startHighlightingComponent(component);
        }
    }

    private void updatePageMilestones(Milestone prevStone, Milestone nextStone) {
        if (this.nextButtonFlasher != null) {
            this.nextButtonFlasher.startFlashing(nextStone == null ? null : nextStone.getColor());
        }
        if (this.prevButtonFlasher != null) {
            this.prevButtonFlasher.startFlashing(prevStone == null ? null : prevStone.getColor());
        }
    }

    private void updateHighestMilestone() {
        this.highestMilestone = null;
        for (KTSDocket docket : this.docketList) {
            Milestone milestone = this.manager.getMilestoneForDocket(docket);
            if (this.highestMilestone != null && (milestone == null || milestone.getMilliSeconds() <= this.highestMilestone.getMilliSeconds())) continue;
            this.highestMilestone = milestone;
        }
    }

    public Milestone getHighestMilestone() {
        return this.highestMilestone;
    }

    protected T getListView() {
        return this.myView;
    }

    Map<Milestone, HighlightController> getMilestoneHighlighterMap() {
        return this.highlighterMap;
    }
}

