/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.gui.milestones;

import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import ordermate.database.hardware.physical.kts.KTSDocketState;
import utils.ktsmate.gui.milestones.KTSMilestoneMonitor;

public class KTSMilestoneMonitorPool {
    private final Map<KTSDocketState, KTSMilestoneMonitor> pool = new HashMap<KTSDocketState, KTSMilestoneMonitor>();
    private static final KTSMilestoneMonitorPool instance = new KTSMilestoneMonitorPool();

    private KTSMilestoneMonitorPool() {
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                for (KTSMilestoneMonitor monitor : KTSMilestoneMonitorPool.this.pool.values()) {
                    monitor.renderMilestones();
                }
            }
        }, 1000L, 1000L);
    }

    public static final KTSMilestoneMonitorPool getInstance() {
        return instance;
    }

    public KTSMilestoneMonitor getMonitorFor(KTSDocketState state) {
        return this.pool.get(state);
    }

    public void registerMonitorFor(KTSDocketState state, KTSMilestoneMonitor monitor) {
        if (this.pool.containsKey(state)) {
            throw new IllegalStateException("Cannot set a milestonesMonitor more than once.");
        }
        this.pool.put(state, monitor);
    }
}

