/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.gui.milestones.highlighter;

import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import utils.ktsmate.gui.milestones.highlighter.ComponentHighlighter;

public class HighlightController {
    private ComponentHighlighter myHL;
    private Set<JComponent> myComponents;
    private Set<JComponent> toHighlight;

    public HighlightController(ComponentHighlighter highlighter) {
        this.myHL = highlighter;
        this.myComponents = new HashSet<JComponent>();
        this.toHighlight = new HashSet<JComponent>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startHighlightingComponent(JComponent component) {
        if (component != null) {
            Set<JComponent> set = this.myComponents;
            synchronized (set) {
                this.myComponents.add(component);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopHighlightingComponent(JComponent component) {
        Set<JComponent> set = this.myComponents;
        synchronized (set) {
            this.myComponents.remove(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performHighlight() {
        Set<JComponent> set = this.myComponents;
        synchronized (set) {
            this.toHighlight.addAll(this.myComponents);
        }
        for (JComponent component : this.toHighlight) {
            if (component.isDisplayable()) {
                this.doComponentHighlight(component);
                continue;
            }
            this.stopHighlightingComponent(component);
        }
        this.toHighlight.clear();
    }

    protected void doComponentHighlight(JComponent component) {
        this.getHighlighter().doHighlight(component);
    }

    protected ComponentHighlighter getHighlighter() {
        return this.myHL;
    }

    protected Set<JComponent> getComponentsToHighlight() {
        return this.toHighlight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHighlightingComponent(JComponent component) {
        Set<JComponent> set = this.myComponents;
        synchronized (set) {
            return this.myComponents.contains(component);
        }
    }
}

