/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.gui.milestones.highlighter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import javax.swing.JComponent;
import utils.ktsmate.gui.milestones.highlighter.ComponentHighlighter;

public class LineBorderHighlighter
implements ComponentHighlighter {
    private final Color lineColor;
    private final Stroke stroke;
    private int offset;

    public LineBorderHighlighter(Color color, int lineThickness) {
        this.lineColor = color;
        this.stroke = new BasicStroke(lineThickness);
        this.offset = (int)((double)lineThickness / 2.0);
    }

    @Override
    public void doHighlight(JComponent component) {
        Graphics2D g2 = (Graphics2D)component.getGraphics();
        g2.setStroke(this.stroke);
        g2.setColor(this.lineColor);
        int width = component.getWidth() - this.offset;
        int height = component.getHeight() - this.offset;
        g2.drawLine(this.offset, this.offset, this.offset, height);
        g2.drawLine(this.offset, this.offset, width, this.offset);
        g2.drawLine(this.offset, height, width, height);
        g2.drawLine(width, this.offset, width, height);
    }
}

