/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.gui.renderer;

import ordermate.database.gui.FontAttributes;
import ordermate.database.sales.SalesItemSummary;
import ordermate.database.sales.printSummary.DocketSummary;
import ordermate.database.sales.printSummary.SalesItemSummaryGroup;
import utils.ktsmate.KTSMate;
import utils.ktsmate.docket.KTSDocket;
import utils.ktsmate.docket.line.DocketSummaryLine;
import utils.ktsmate.docket.line.GroupHeaderLine;
import utils.ktsmate.docket.line.KTSAdjustment;
import utils.ktsmate.docket.line.KTSLine;
import utils.ktsmate.docket.line.SummaryGroupLine;
import utils.ktsmate.docket.line.SummaryItemLine;
import utils.ktsmate.docket.line.notifier.KTSNotifyPrinterLine;
import utils.ktsmate.gui.renderer.LineRenderer;
import utils.ktsmate.gui.renderer.LineRendererFactory;

public abstract class AbstractLineRendererFactory
implements LineRendererFactory {
    @Override
    public LineRenderer createRenderer(KTSDocket docket, KTSLine line, boolean includeCourse) {
        LineRenderer renderer;
        if (line instanceof SummaryItemLine) {
            renderer = this.createSummaryRenderer(docket, (SummaryItemLine)line, includeCourse);
        } else if (line instanceof SummaryGroupLine) {
            renderer = this.createSummaryGroupRenderer(docket, (SummaryGroupLine)line, includeCourse);
        } else if (line instanceof GroupHeaderLine) {
            renderer = this.createGroupHeaderRenderer(docket, (GroupHeaderLine)line, KTSMate.getLocalPrinter().getGroupAttributes(), includeCourse);
        } else {
            if (line instanceof DocketSummaryLine) {
                return null;
            }
            if (line.getData() instanceof KTSAdjustment) {
                renderer = this.createAdjustmentLineRenderer(docket, line);
            } else if (line.getData() instanceof String) {
                FontAttributes attributes = line instanceof KTSNotifyPrinterLine ? KTSMate.getLocalPrinter().getNotifyAttributes() : KTSMate.getLocalPrinter().getNotesAttributes();
                renderer = this.createStringLineRenderer(docket, line, attributes);
            } else {
                throw new IllegalArgumentException("Unknown KTSLine passed to LineRendererFactory");
            }
        }
        return renderer;
    }

    public abstract LineRenderer createGroupHeaderRenderer(KTSDocket var1, GroupHeaderLine var2, FontAttributes var3, boolean var4);

    public abstract LineRenderer<SalesItemSummary> createSummaryRenderer(KTSDocket var1, SummaryItemLine var2, boolean var3);

    public abstract LineRenderer<SalesItemSummaryGroup> createSummaryGroupRenderer(KTSDocket var1, SummaryGroupLine var2, boolean var3);

    public abstract LineRenderer<DocketSummary> createDocketSummaryRenderer(KTSDocket var1, DocketSummaryLine var2);

    public abstract LineRenderer<KTSAdjustment> createAdjustmentLineRenderer(KTSDocket var1, KTSLine<KTSAdjustment> var2);

    public abstract LineRenderer createStringLineRenderer(KTSDocket var1, KTSLine var2, FontAttributes var3);
}

