/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.gui.renderer;

import java.awt.Color;
import ordermate.database.gui.FontAttributes;
import utils.ktsmate.docket.line.KTSAdjustment;
import utils.ktsmate.docket.line.KTSLine;
import utils.ktsmate.gui.renderer.CompletableLineRenderer;

public class AdjustmentLineRenderer
extends CompletableLineRenderer<KTSAdjustment> {
    private Color adjColour = null;

    public AdjustmentLineRenderer(KTSLine<KTSAdjustment> toRender, Color completeColor, FontAttributes attributes, Color adjustmentColour) {
        super(toRender, completeColor, null, attributes);
        this.adjColour = adjustmentColour;
    }

    @Override
    public void refreshRenderingComponent() {
        this.getLabel().setOpaque(this.adjColour != null);
        this.getLabel().setBackground(this.adjColour);
        super.refreshRenderingComponent();
    }

    @Override
    protected String stringifyDataObject(KTSAdjustment toStringify) {
        StringBuilder SB = new StringBuilder(toStringify.getType()).append(" ").append(toStringify.getQuantity().negate()).append(" items");
        if (toStringify.getDestinationAccount() != null) {
            SB.append(" to ").append(toStringify.getDestinationAccount().getLabel());
        }
        return SB.toString();
    }
}

