/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.gui.renderer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import ordermate.database.gui.FontAttributes;
import utils.ktsmate.docket.line.KTSLine;
import utils.ktsmate.gui.renderer.LineRenderer;
import utils.ktsmate.gui.renderer.LineRendererHelper;
import utils.ktsmate.gui.renderer.StrikeoutLabel;

abstract class CommaSeparatedLineRenderer<T>
implements LineRenderer<T> {
    protected final List<KTSLine<T>> lines;
    private final String prefix;
    private final Color completeColour;
    private final Color deletedColour;
    private final FontAttributes fontAttributes;
    private final KTSLine<T> myLine;
    private final int DEFAULT_BORDER = 20;
    private final int TOTAL_HORIZONTAL_BORDER_WIDTH = 40;
    protected JComponent renderer;
    protected List<StrikeoutLabel> labels = new ArrayList<StrikeoutLabel>();

    public CommaSeparatedLineRenderer(List<KTSLine<T>> toRender, String thePrefix, Color complete, Color delete, FontAttributes attributes) {
        this.lines = toRender;
        this.completeColour = complete;
        this.deletedColour = delete;
        this.fontAttributes = attributes;
        this.myLine = this.lines.get(0);
        this.prefix = thePrefix != null ? thePrefix : "";
    }

    protected abstract String stringifyDataObject(T var1);

    @Override
    public KTSLine<T> getRenderedLine() {
        return this.myLine;
    }

    @Override
    public JComponent getRenderingComponent() {
        if (this.renderer == null) {
            this.renderer = this.createRenderer();
        }
        return this.renderer;
    }

    protected JComponent createRenderer() {
        JPanel holder = new JPanel(new FlowLayout(0, 0, 0));
        holder.setOpaque(false);
        holder.setBorder(null);
        for (int i = 0; i < this.lines.size(); ++i) {
            StringBuilder SB = new StringBuilder();
            if (i == 0) {
                SB.append(this.prefix);
            }
            SB.append(this.stringifyDataObject(this.lines.get(i).getData()));
            if (i < this.lines.size() - 1) {
                SB.append(", ");
            }
            StrikeoutLabel label = new StrikeoutLabel(SB.toString());
            label.setBackground(null);
            label.setOpaque(false);
            label.setBorder(null);
            label.setStrikeoutColour(null);
            label.setFont(this.fontAttributes.generateFont());
            label.setHorizontalAlignment(2);
            label.setAlignmentX(0.0f);
            this.labels.add(label);
            holder.add(label);
        }
        JPanel spacedContainer = new JPanel(new BorderLayout());
        spacedContainer.setOpaque(false);
        spacedContainer.setBorder(new EmptyBorder(0, 0, 0, 20));
        spacedContainer.add(Box.createHorizontalStrut(20), "West");
        spacedContainer.add((Component)holder, "Center");
        return spacedContainer;
    }

    @Override
    public void adjustRendererHeightToFit(int width) {
        StrikeoutLabel lastLabel = this.labels.get(this.labels.size() - 1);
        int labelHeight = lastLabel.getHeight();
        int preferredHeight = LineRendererHelper.getPreferredHeightFromNewWidth(labelHeight, 40, labelHeight, width, this.labels);
        this.renderer.setPreferredSize(new Dimension(width, preferredHeight));
        this.renderer.invalidate();
    }

    @Override
    public void refreshRenderingComponent() {
        Color colorSet = null;
        Stroke strokeSet = null;
        if (this.getRenderedLine().isComplete()) {
            colorSet = this.completeColour;
            strokeSet = StrikeoutLabel.SOLID;
        } else if (this.getRenderedLine().isDeleted()) {
            colorSet = this.deletedColour;
            strokeSet = StrikeoutLabel.WIGGLE;
        }
        for (StrikeoutLabel nextLabel : this.labels) {
            nextLabel.setStrikeoutColour(colorSet);
            nextLabel.setStrikeoutStroke(strokeSet);
            nextLabel.validate();
            nextLabel.repaint();
        }
    }

    protected FontAttributes getFontAttributes() {
        return this.fontAttributes;
    }
}

