/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.gui.renderer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import ordermate.database.gui.FontAttributes;
import utils.ktsmate.docket.line.KTSLine;
import utils.ktsmate.gui.renderer.LineRenderer;
import utils.ktsmate.gui.renderer.StrikeoutLabel;

public abstract class CompletableLineRenderer<T>
implements LineRenderer<T> {
    private JComponent renderingComponent;
    private StrikeoutLabel label;
    private KTSLine<T> renderedLine;
    private FontAttributes fontAttributes;
    private Color completedColor;
    private Color deletedColor;
    private String prefix;

    public CompletableLineRenderer(KTSLine<T> toRender, Color completeColor, Color deleteColor, FontAttributes attributes) {
        this(toRender, completeColor, deleteColor, attributes, "");
    }

    public CompletableLineRenderer(KTSLine<T> toRender, Color completeColor, Color deleteColor, FontAttributes attributes, String prefix) {
        this.renderedLine = toRender;
        this.completedColor = completeColor;
        this.deletedColor = deleteColor;
        this.fontAttributes = attributes;
        this.prefix = prefix;
    }

    private JComponent createRenderer() {
        this.label = new StrikeoutLabel(this.prefix + this.stringifyDataObject(this.renderedLine.getData()));
        this.label.setOpaque(false);
        this.label.setBorder(null);
        this.label.setStrikeoutColour(null);
        this.label.setFont(this.fontAttributes.generateFont());
        this.label.setHorizontalAlignment(2);
        this.label.setAlignmentX(0.0f);
        JPanel holder = new JPanel(new FlowLayout(0, 0, 0));
        holder.setBorder(null);
        holder.add(this.label);
        holder.setOpaque(false);
        return holder;
    }

    protected abstract String stringifyDataObject(T var1);

    protected StrikeoutLabel getLabel() {
        return this.label;
    }

    @Override
    public KTSLine<T> getRenderedLine() {
        return this.renderedLine;
    }

    @Override
    public JComponent getRenderingComponent() {
        if (this.renderingComponent == null) {
            this.renderingComponent = this.createRenderer();
            this.refreshRenderingComponent();
        }
        return this.renderingComponent;
    }

    @Override
    public void refreshRenderingComponent() {
        if (this.renderedLine.isComplete()) {
            this.label.setStrikeoutColour(this.completedColor);
            this.label.setStrikeoutStroke(StrikeoutLabel.SOLID);
        } else if (this.renderedLine.isDeleted()) {
            this.label.setStrikeoutColour(this.deletedColor);
            this.label.setStrikeoutStroke(StrikeoutLabel.WIGGLE);
        } else {
            this.label.setStrikeoutColour(null);
        }
        this.renderingComponent.setOpaque(this.renderedLine.isHighlighted());
        this.label.validate();
        this.label.repaint();
        this.renderingComponent.validate();
        this.renderingComponent.repaint();
    }

    @Override
    public void adjustRendererHeightToFit(int width) {
        this.renderingComponent.setPreferredSize(new Dimension(width, this.label.getHeight()));
        this.renderingComponent.invalidate();
    }
}

