/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.gui.renderer;

import java.awt.Color;
import ordermate.database.gui.FontAttributes;
import ordermate.database.hardware.physical.kts.KTSDocketPrinter;
import ordermate.database.sales.SalesItemSummary;
import ordermate.database.sales.printSummary.DocketSummary;
import ordermate.database.sales.printSummary.SalesItemSummaryGroup;
import utils.ktsmate.KTSMate;
import utils.ktsmate.docket.KTSDocket;
import utils.ktsmate.docket.line.DocketSummaryLine;
import utils.ktsmate.docket.line.GroupHeaderLine;
import utils.ktsmate.docket.line.KTSAdjustment;
import utils.ktsmate.docket.line.KTSLine;
import utils.ktsmate.docket.line.SummaryGroupLine;
import utils.ktsmate.docket.line.SummaryItemLine;
import utils.ktsmate.gui.renderer.AbstractLineRendererFactory;
import utils.ktsmate.gui.renderer.AdjustmentLineRenderer;
import utils.ktsmate.gui.renderer.DefaultSalesItemSummaryGroupRenderer;
import utils.ktsmate.gui.renderer.DefaultSalesItemSummaryRenderer;
import utils.ktsmate.gui.renderer.DocketSummaryLineRenderer;
import utils.ktsmate.gui.renderer.GroupHeaderLineRenderer;
import utils.ktsmate.gui.renderer.LineRenderer;
import utils.ktsmate.gui.renderer.StringLineRenderer;

public class DefaultLineRendererFactory
extends AbstractLineRendererFactory {
    @Override
    public LineRenderer<SalesItemSummary> createSummaryRenderer(KTSDocket docket, SummaryItemLine line, boolean includeCourse) {
        return new DefaultSalesItemSummaryRenderer(docket, line, includeCourse);
    }

    @Override
    public LineRenderer<SalesItemSummaryGroup> createSummaryGroupRenderer(KTSDocket docket, SummaryGroupLine line, boolean includeCourse) {
        return new DefaultSalesItemSummaryGroupRenderer(docket, line, includeCourse);
    }

    @Override
    public LineRenderer<DocketSummary> createDocketSummaryRenderer(KTSDocket docket, DocketSummaryLine line) {
        return new DocketSummaryLineRenderer(docket, line);
    }

    @Override
    public LineRenderer<KTSAdjustment> createAdjustmentLineRenderer(KTSDocket docket, KTSLine<KTSAdjustment> line) {
        KTSDocketPrinter printer = KTSMate.getLocalPrinter();
        Color adjColour = "MOVED".equals(line.getData().getType()) ? printer.getTransferColour() : printer.getDeletedColour();
        AdjustmentLineRenderer newRenderer = new AdjustmentLineRenderer(line, printer.getCompletedColour(), printer.getItemAttributes(), adjColour);
        return newRenderer;
    }

    @Override
    public LineRenderer createStringLineRenderer(KTSDocket docket, KTSLine line, FontAttributes font) {
        return new StringLineRenderer(line, font);
    }

    @Override
    public LineRenderer createGroupHeaderRenderer(KTSDocket docket, GroupHeaderLine line, FontAttributes headerAttributes, boolean includeCourse) {
        return new GroupHeaderLineRenderer(line, headerAttributes, includeCourse);
    }
}

