/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.gui.renderer;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import ordermate.database.hardware.physical.kts.KTSDocketPrinter;
import ordermate.database.sales.printSummary.SalesItemSummaryGroup;
import utils.ktsmate.KTSMate;
import utils.ktsmate.docket.KTSDocket;
import utils.ktsmate.docket.line.KTSLine;
import utils.ktsmate.docket.line.SummaryGroupLine;
import utils.ktsmate.docket.line.SummaryItemLine;
import utils.ktsmate.docket.line.notifier.KTSNotifyGroupLine;
import utils.ktsmate.gui.renderer.AbstractItemSummaryRenderer;
import utils.ktsmate.gui.renderer.DefaultSalesItemSummaryRenderer;
import utils.ktsmate.gui.renderer.LineRenderer;
import utils.ktsmate.gui.renderer.SummaryGroupLineRenderer;

public class DefaultSalesItemSummaryGroupRenderer
extends AbstractItemSummaryRenderer<SalesItemSummaryGroup> {
    private JPanel panel;
    private KTSDocket docket;
    private SummaryGroupLine line;
    private boolean includeCourse;
    private List<LineRenderer> renderers;

    public DefaultSalesItemSummaryGroupRenderer(KTSDocket docket, SummaryGroupLine line, boolean includeCourse) {
        this.docket = docket;
        this.line = line;
        this.includeCourse = includeCourse;
        this.setupRenderers();
    }

    @Override
    public KTSLine<SalesItemSummaryGroup> getRenderedLine() {
        return this.line;
    }

    @Override
    public JComponent getRenderingComponent() {
        return this.panel;
    }

    @Override
    public void refreshRenderingComponent() {
        for (LineRenderer renderer : this.renderers) {
            renderer.refreshRenderingComponent();
        }
    }

    private void setupRenderers() {
        this.renderers = new ArrayList<LineRenderer>();
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        if (this.includeCourse) {
            this.panel.add(this.createCourseLine());
        }
        KTSDocketPrinter printer = KTSMate.getLocalPrinter();
        boolean isNotify = this.line instanceof KTSNotifyGroupLine;
        SummaryGroupLineRenderer renderer = new SummaryGroupLineRenderer(this.line, printer.getCompletedColour(), printer.getDeletedColour(), printer.getTransferColour(), isNotify ? printer.getNotifyItemsAttributes() : printer.getItemAttributes(), this.docket);
        this.renderers.add(renderer);
        this.panel.add(renderer.getRenderingComponent());
        if (!isNotify) {
            for (KTSLine subline : this.line.getChildren()) {
                DefaultSalesItemSummaryRenderer subrenderer = new DefaultSalesItemSummaryRenderer(this.docket, (SummaryItemLine)subline, false, true);
                this.renderers.add(subrenderer);
                this.panel.add(subrenderer.getRenderingComponent());
            }
        }
    }

    @Override
    public void adjustRendererHeightToFit(int width) {
        super.adjustRendererHeightToFit(width);
        for (LineRenderer renderer : this.renderers) {
            renderer.adjustRendererHeightToFit(width);
        }
    }

    @Override
    public KTSDocket getDocket() {
        return this.docket;
    }

    @Override
    public List<LineRenderer> getLineRenderers() {
        return this.renderers;
    }

    @Override
    public LineRenderer getLineRendererForComponent(Component component) {
        for (LineRenderer renderer : this.renderers) {
            if (renderer.getRenderingComponent() != component) continue;
            return renderer;
        }
        return null;
    }

    @Override
    public void refreshRenderers() {
        this.refreshRenderingComponent();
    }

    @Override
    protected int getCourse() {
        return this.getRenderedLine().getData().getSummary().getSalesItem().getCourse();
    }
}

