/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.gui.renderer;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import ordermate.database.hardware.physical.kts.KTSDocketPrinter;
import ordermate.database.hardware.physical.kts.KTSModLines;
import ordermate.database.inventory.InventoryOptionGroup;
import ordermate.database.sales.AbstractSalesRemove;
import ordermate.database.sales.SalesAdd;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItemSummary;
import ordermate.database.sales.SalesOption;
import utils.ktsmate.KTSMate;
import utils.ktsmate.docket.KTSDocket;
import utils.ktsmate.docket.line.KTSLine;
import utils.ktsmate.docket.line.SalesComponentLine;
import utils.ktsmate.docket.line.SummaryItemLine;
import utils.ktsmate.gui.renderer.AbstractItemSummaryRenderer;
import utils.ktsmate.gui.renderer.CommaSeparatedLineRenderer;
import utils.ktsmate.gui.renderer.CompletableLineRenderer;
import utils.ktsmate.gui.renderer.LineRenderer;
import utils.ktsmate.gui.renderer.SummaryItemLineRenderer;

public class DefaultSalesItemSummaryRenderer
extends AbstractItemSummaryRenderer<SalesItemSummary> {
    private SummaryItemLine renderedLine;
    private JComponent renderer;
    private KTSDocket myDocket;
    private boolean includeCourse;
    private boolean isChildLine;
    private final List<LineRenderer> lineRenderers = new ArrayList<LineRenderer>();

    public DefaultSalesItemSummaryRenderer(KTSDocket docket, SummaryItemLine toRender, boolean shouldIncludeCourse) {
        this(docket, toRender, shouldIncludeCourse, false);
    }

    public DefaultSalesItemSummaryRenderer(KTSDocket docket, SummaryItemLine toRender, boolean shouldIncludeCourse, boolean isChildLine) {
        this.renderedLine = toRender;
        this.includeCourse = shouldIncludeCourse;
        if (this.renderedLine == null) {
            throw new IllegalArgumentException("Cannot render a null item");
        }
        this.myDocket = docket;
        this.isChildLine = isChildLine;
        this.renderer = this.createRendererComponent();
    }

    @Override
    public List<LineRenderer> getLineRenderers() {
        return Collections.unmodifiableList(this.lineRenderers);
    }

    @Override
    public LineRenderer getLineRendererForComponent(Component comp) {
        for (LineRenderer nextRenderer : this.lineRenderers) {
            if (nextRenderer.getRenderingComponent() != comp) continue;
            return nextRenderer;
        }
        return null;
    }

    protected JComponent createRendererComponent() {
        JPanel holder = new JPanel();
        holder.setLayout(new BoxLayout(holder, 1));
        this.lineRenderers.clear();
        if (this.includeCourse) {
            holder.add(this.createCourseLine());
        }
        this.createSummaryLine();
        for (LineRenderer nextLine : this.lineRenderers) {
            holder.add(nextLine.getRenderingComponent());
        }
        holder.setOpaque(false);
        holder.setBackground(null);
        this.refreshRenderers();
        return holder;
    }

    private void createSummaryLine() {
        KTSDocketPrinter printer = KTSMate.getLocalPrinter();
        if (!this.isChildLine) {
            SummaryItemLineRenderer summaryRenderer = new SummaryItemLineRenderer(this.renderedLine, printer.getCompletedColour(), printer.getDeletedColour(), printer.getTransferColour(), printer.getItemAttributes(), this.myDocket);
            this.lineRenderers.add(summaryRenderer);
        }
        List<SalesComponentLine> components = this.renderedLine.getSalesComponentLines();
        for (SalesComponentLine line : components) {
            this.createComponentPanel(line);
        }
        KTSLine<String> notes = this.renderedLine.getNotes();
        if (notes != null) {
            this.createStringPanel(notes);
        }
    }

    @Override
    public void refreshRenderers() {
        for (LineRenderer nextLine : this.lineRenderers) {
            nextLine.refreshRenderingComponent();
        }
    }

    private void createComponentPanel(SalesComponentLine componentLine) {
        KTSDocketPrinter printer = KTSMate.getLocalPrinter();
        if (!((SalesComponent)componentLine.getData()).getUnit().getPortion().getFraction().equals("1") && !this.isChildLine) {
            CompletableLineRenderer<SalesComponent> compLineRenderer = new CompletableLineRenderer<SalesComponent>((KTSLine)componentLine, printer.getCompletedColour(), printer.getDeletedColour(), printer.getItemAttributes()){

                @Override
                protected String stringifyDataObject(SalesComponent toStringify) {
                    StringBuilder SB = new StringBuilder("  ");
                    String fraction = toStringify.getUnit().getPortion().getFraction();
                    if (!fraction.equals("1")) {
                        SB.append(fraction);
                    }
                    SB.append(" ").append(toStringify.getUnit().getSize().getShortName()).append(" ").append(toStringify.getInventoryItem().getLabel());
                    return SB.toString();
                }
            };
            this.lineRenderers.add(compLineRenderer);
        }
        String optionsPrefix = "  ";
        String plusPrefix = "  ";
        String minusPrefix = "  ";
        if (this.isChildLine) {
            if (!componentLine.getOptionLines().isEmpty()) {
                optionsPrefix = this.renderedLine.getQuantity().toString() + " ";
            } else if (!componentLine.getPlusLines().isEmpty()) {
                plusPrefix = this.renderedLine.getQuantity().toString() + " ";
            } else if (!componentLine.getMinusLines().isEmpty()) {
                minusPrefix = this.renderedLine.getQuantity().toString();
            }
        }
        this.createOptionPanel(componentLine.getOptionLines(), optionsPrefix);
        this.createPlusPanel(componentLine.getPlusLines(), plusPrefix);
        this.createMinusPanel(componentLine.getMinusLines(), minusPrefix);
    }

    private void createOptionPanel(List<KTSLine<SalesOption>> optionLines, String qtyPrefix) {
        if (optionLines == null || optionLines.size() == 0) {
            return;
        }
        KTSDocketPrinter printer = KTSMate.getLocalPrinter();
        if (KTSModLines.PerType.equals((Object)printer.getModLines())) {
            CommaSeparatedLineRenderer<SalesOption> newRenderer = new CommaSeparatedLineRenderer<SalesOption>(optionLines, qtyPrefix, printer.getCompletedColour(), printer.getDeletedColour(), printer.getOptionsAttributes()){

                @Override
                protected String stringifyDataObject(SalesOption toStringify) {
                    return toStringify.getLabel();
                }
            };
            this.lineRenderers.add(newRenderer);
        } else if (KTSModLines.PerGroup.equals((Object)printer.getModLines())) {
            ArrayList<KTSLine<SalesOption>> groupOptions = null;
            InventoryOptionGroup group = null;
            for (KTSLine<SalesOption> optionLine : optionLines) {
                if (group == null || !group.equals((Object)optionLine.getData().getOption().getOptionGroup())) {
                    if (groupOptions != null) {
                        CommaSeparatedLineRenderer<SalesOption> newRenderer = new CommaSeparatedLineRenderer<SalesOption>(groupOptions, qtyPrefix, printer.getCompletedColour(), printer.getDeletedColour(), printer.getOptionsAttributes()){

                            @Override
                            protected String stringifyDataObject(SalesOption toStringify) {
                                return toStringify.getLabel();
                            }
                        };
                        this.lineRenderers.add(newRenderer);
                    }
                    groupOptions = new ArrayList<KTSLine<SalesOption>>();
                    group = optionLine.getData().getOption().getOptionGroup();
                }
                groupOptions.add(optionLine);
            }
            CommaSeparatedLineRenderer<SalesOption> newRenderer = new CommaSeparatedLineRenderer<SalesOption>(groupOptions, qtyPrefix, printer.getCompletedColour(), printer.getDeletedColour(), printer.getOptionsAttributes()){

                @Override
                protected String stringifyDataObject(SalesOption toStringify) {
                    return toStringify.getLabel();
                }
            };
            this.lineRenderers.add(newRenderer);
        } else if (KTSModLines.PerMod.equals((Object)printer.getModLines())) {
            boolean displayedPrefix = false;
            for (KTSLine<SalesOption> nextOption : optionLines) {
                String linePrefix = "     ";
                if (!displayedPrefix) {
                    linePrefix = "   " + qtyPrefix;
                    displayedPrefix = true;
                } else if (!qtyPrefix.trim().isEmpty()) {
                    linePrefix = "      ";
                }
                CompletableLineRenderer<SalesOption> newRenderer = new CompletableLineRenderer<SalesOption>(nextOption, printer.getCompletedColour(), printer.getDeletedColour(), printer.getOptionsAttributes(), linePrefix){

                    @Override
                    protected String stringifyDataObject(SalesOption toStringify) {
                        return toStringify.getLabel();
                    }
                };
                this.lineRenderers.add(newRenderer);
            }
        } else {
            throw new IllegalStateException("Unknown modLines:" + printer.getModLines());
        }
    }

    private void createPlusPanel(List<KTSLine<SalesAdd>> plusLines, String qtyPrefix) {
        if (plusLines == null || plusLines.size() == 0) {
            return;
        }
        KTSDocketPrinter printer = KTSMate.getLocalPrinter();
        if (!KTSModLines.PerMod.equals((Object)printer.getModLines())) {
            CommaSeparatedLineRenderer<SalesAdd> newRenderer = new CommaSeparatedLineRenderer<SalesAdd>(plusLines, qtyPrefix + "+ ", printer.getCompletedColour(), printer.getDeletedColour(), printer.getPlusAttributes()){

                @Override
                protected String stringifyDataObject(SalesAdd toStringify) {
                    StringBuilder SB = new StringBuilder();
                    if (toStringify.getModificationSize() != null) {
                        SB.append(toStringify.getModificationSize().getAbbreviatedName()).append(" ");
                    }
                    SB.append(toStringify.getLabel());
                    return SB.toString();
                }
            };
            this.lineRenderers.add(newRenderer);
        } else {
            boolean displayedPrefix = false;
            for (KTSLine<SalesAdd> nextAdd : plusLines) {
                String linePrefix = "     ";
                if (!displayedPrefix) {
                    linePrefix = "   " + qtyPrefix;
                    displayedPrefix = true;
                }
                CompletableLineRenderer<SalesAdd> newRenderer = new CompletableLineRenderer<SalesAdd>(nextAdd, printer.getCompletedColour(), printer.getDeletedColour(), printer.getPlusAttributes(), linePrefix){

                    @Override
                    protected String stringifyDataObject(SalesAdd toStringify) {
                        StringBuilder SB = new StringBuilder("+");
                        if (toStringify.getModificationSize() != null) {
                            SB.append(toStringify.getModificationSize().getAbbreviatedName()).append(" ");
                        }
                        SB.append(toStringify.getLabel());
                        return SB.toString();
                    }
                };
                this.lineRenderers.add(newRenderer);
            }
        }
    }

    private void createMinusPanel(List<KTSLine<AbstractSalesRemove>> minusLines, String qtyPrefix) {
        if (minusLines == null || minusLines.size() == 0) {
            return;
        }
        KTSDocketPrinter printer = KTSMate.getLocalPrinter();
        if (!KTSModLines.PerMod.equals((Object)printer.getModLines())) {
            CommaSeparatedLineRenderer<AbstractSalesRemove> newRenderer = new CommaSeparatedLineRenderer<AbstractSalesRemove>(minusLines, qtyPrefix + " - ", printer.getCompletedColour(), printer.getDeletedColour(), printer.getMinusAttributes()){

                @Override
                protected String stringifyDataObject(AbstractSalesRemove toStringify) {
                    StringBuilder SB = new StringBuilder();
                    if (toStringify.getModificationSize() != null) {
                        SB.append(toStringify.getModificationSize().getAbbreviatedName()).append(" ");
                    }
                    SB.append(toStringify.getLabel());
                    return SB.toString();
                }
            };
            this.lineRenderers.add(newRenderer);
        } else {
            boolean displayedPrefix = false;
            for (KTSLine<AbstractSalesRemove> nextMinus : minusLines) {
                String linePrefix = "     ";
                if (!displayedPrefix) {
                    linePrefix = "   " + qtyPrefix;
                    displayedPrefix = true;
                }
                CompletableLineRenderer<AbstractSalesRemove> newRenderer = new CompletableLineRenderer<AbstractSalesRemove>(nextMinus, printer.getCompletedColour(), printer.getDeletedColour(), printer.getMinusAttributes(), linePrefix){

                    @Override
                    protected String stringifyDataObject(AbstractSalesRemove toStringify) {
                        StringBuilder SB = new StringBuilder(" -");
                        if (toStringify.getModificationSize() != null) {
                            SB.append(toStringify.getModificationSize().getAbbreviatedName()).append(" ");
                        }
                        SB.append(toStringify.getLabel());
                        return SB.toString();
                    }
                };
                this.lineRenderers.add(newRenderer);
            }
        }
    }

    private void createStringPanel(KTSLine<String> stringLine) {
        KTSDocketPrinter printer = KTSMate.getLocalPrinter();
        this.lineRenderers.add(new CompletableLineRenderer<String>(stringLine, printer.getCompletedColour(), printer.getDeletedColour(), printer.getNotesAttributes()){

            @Override
            protected String stringifyDataObject(String toStringify) {
                return "  " + String.valueOf(toStringify);
            }
        });
    }

    @Override
    public JComponent getRenderingComponent() {
        return this.renderer;
    }

    @Override
    public final KTSDocket getDocket() {
        return this.myDocket;
    }

    @Override
    public void refreshRenderingComponent() {
        for (LineRenderer nextRenderer : this.lineRenderers) {
            nextRenderer.refreshRenderingComponent();
        }
    }

    public SummaryItemLine getRenderedLine() {
        return this.renderedLine;
    }

    @Override
    public void adjustRendererHeightToFit(int width) {
        super.adjustRendererHeightToFit(width);
        for (LineRenderer nextRenderer : this.lineRenderers) {
            nextRenderer.adjustRendererHeightToFit(width);
        }
    }

    @Override
    protected int getCourse() {
        return this.renderedLine.getData().getSalesItem().getCourse();
    }
}

