/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.gui.renderer;

import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import ordermate.database.sales.printSummary.DocketSummary;
import utils.ktsmate.KTSMate;
import utils.ktsmate.docket.KTSDocket;
import utils.ktsmate.docket.line.DocketSummaryLine;
import utils.ktsmate.docket.line.KTSLine;
import utils.ktsmate.gui.renderer.LineRenderer;
import utils.ktsmate.gui.renderer.StringLineRenderer;

public class DocketSummaryLineRenderer
implements LineRenderer<DocketSummary> {
    private KTSDocket docket;
    private DocketSummaryLine line;
    private JPanel panel;

    public DocketSummaryLineRenderer(KTSDocket docket, DocketSummaryLine line) {
        this.docket = docket;
        this.line = line;
        this.refreshRenderingComponent();
    }

    @Override
    public KTSLine<DocketSummary> getRenderedLine() {
        return this.line;
    }

    @Override
    public JComponent getRenderingComponent() {
        return this.panel;
    }

    @Override
    public void refreshRenderingComponent() {
        StringLineRenderer renderer;
        KTSLine<String> stringLine;
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        for (String option : ((DocketSummary)this.line.getData()).getOptions()) {
            stringLine = new KTSLine<String>(option, null);
            renderer = new StringLineRenderer(stringLine, KTSMate.getLocalPrinter().getOptionsAttributes());
            this.panel.add(renderer.getRenderingComponent());
        }
        for (String plus : ((DocketSummary)this.line.getData()).getPluses()) {
            stringLine = new KTSLine<String>(plus, null);
            renderer = new StringLineRenderer(stringLine, KTSMate.getLocalPrinter().getPlusAttributes());
            this.panel.add(renderer.getRenderingComponent());
        }
        for (String minus : ((DocketSummary)this.line.getData()).getMinuses()) {
            stringLine = new KTSLine<String>(minus, null);
            renderer = new StringLineRenderer(stringLine, KTSMate.getLocalPrinter().getMinusAttributes());
            this.panel.add(renderer.getRenderingComponent());
        }
    }

    @Override
    public void adjustRendererHeightToFit(int width) {
    }
}

