/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.gui.renderer;

import au.com.ordermate.util.StringUtils;
import java.util.Collection;
import java.util.List;
import ordermate.database.gui.FontAttributes;
import ordermate.database.sales.printSummary.SalesItemSummaryGroup;
import utils.ktsmate.docket.line.GroupHeaderLine;
import utils.ktsmate.docket.line.KTSLine;
import utils.ktsmate.gui.KTSUIHelper;
import utils.ktsmate.gui.renderer.SimpleLineRenderer;

public class GroupHeaderLineRenderer
extends SimpleLineRenderer<SalesItemSummaryGroup> {
    public GroupHeaderLineRenderer(GroupHeaderLine toRender, FontAttributes attributes, boolean shouldIncludeCourse) {
        super(toRender, attributes, shouldIncludeCourse);
    }

    @Override
    protected String getText(KTSLine<SalesItemSummaryGroup> line) {
        if (line != null && line.getData() != null && line.getData().getHeaders() != null) {
            if (line.getData().getComboQuantityIndex() < 0) {
                return KTSUIHelper.getInstance().applyProps(StringUtils.mergeToStringWithSeparator((Collection)line.getData().getHeaders(), (String)" ", null), KTSUIHelper.getInstance().getProperties("Group Header")).replace("null", "");
            }
            StringBuilder SB = new StringBuilder();
            List headers = line.getData().getHeaders();
            for (int i = 0; i < headers.size(); ++i) {
                Object header = headers.get(i);
                if (header == null) continue;
                if (i == line.getData().getComboQuantityIndex() && line.getData().getComboQuantity() != null) {
                    SB.append(line.getData().getComboQuantity()).append(" x ");
                }
                SB.append(header);
                if (i >= headers.size() - 1 || headers.get(i + 1) == null) continue;
                SB.append(", ");
            }
            return KTSUIHelper.getInstance().applyProps(SB.toString(), KTSUIHelper.getInstance().getProperties("Group Header"));
        }
        return "";
    }
}

