/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.gui.renderer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import ordermate.database.gui.FontAttributes;
import ordermate.database.inventory.InventoryOptionGroup;
import ordermate.database.sales.SalesOption;
import utils.ktsmate.docket.line.KTSLine;
import utils.ktsmate.gui.renderer.CommaSeparatedLineRenderer;
import utils.ktsmate.gui.renderer.StrikeoutLabel;

public class OptionGroupCommaLineRenderer
extends CommaSeparatedLineRenderer<SalesOption> {
    private List<JPanel> groupHolders;

    public OptionGroupCommaLineRenderer(List<KTSLine<SalesOption>> toRender, String thePrefix, Color complete, Color delete, FontAttributes attributes) {
        super(toRender, thePrefix, complete, delete, attributes);
    }

    @Override
    protected JComponent createRenderer() {
        this.groupHolders = new ArrayList<JPanel>();
        JPanel holder = new JPanel();
        holder.setBackground(null);
        holder.setOpaque(false);
        holder.setBorder(null);
        InventoryOptionGroup group = null;
        JPanel groupHolder = null;
        for (int i = 0; i < this.lines.size(); ++i) {
            StringBuilder SB = new StringBuilder();
            InventoryOptionGroup currentGroup = ((SalesOption)((KTSLine)this.lines.get(i)).getData()).getOption().getOptionGroup();
            if (group == null || !group.equals((Object)currentGroup)) {
                group = currentGroup;
                SB.append(group.getLabel()).append(":");
                groupHolder = new JPanel(new FlowLayout(0, 0, 0));
                holder.add(groupHolder);
                this.groupHolders.add(groupHolder);
            }
            SB.append(((SalesOption)((KTSLine)this.lines.get(i)).getData()).getLabel());
            if (i < this.lines.size() - 1) {
                SB.append(", ");
            }
            StrikeoutLabel label = new StrikeoutLabel(SB.toString());
            label.setBackground(null);
            label.setOpaque(false);
            label.setBorder(null);
            label.setStrikeoutColour(null);
            label.setFont(this.getFontAttributes().generateFont());
            label.setHorizontalAlignment(2);
            label.setAlignmentX(0.0f);
            this.labels.add(label);
            groupHolder.add(label);
        }
        JPanel spacedContainer = new JPanel(new BorderLayout());
        spacedContainer.add(Box.createHorizontalStrut(20), "West");
        spacedContainer.add((Component)holder, "Center");
        spacedContainer.setBackground(null);
        spacedContainer.setOpaque(false);
        return spacedContainer;
    }

    @Override
    public void adjustRendererHeightToFit(int width) {
        int height = 0;
        for (JComponent jComponent : this.groupHolders) {
            height = height + jComponent.getComponents()[jComponent.getComponentCount() - 1].getY() + jComponent.getComponents()[jComponent.getComponentCount() - 1].getHeight();
        }
        JComponent lastLabel = this.groupHolders.get(this.groupHolders.size() - 1);
        this.renderer.setPreferredSize(new Dimension(width, height));
        this.renderer.invalidate();
    }

    @Override
    protected String stringifyDataObject(SalesOption toStringify) {
        return toStringify.getLabel();
    }
}

