/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.gui.renderer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import ordermate.database.gui.FontAttributes;
import ordermate.database.misc.Course;
import ordermate.database.sales.printSummary.SalesItemSummaryGroup;
import utils.ktsmate.KTSMate;
import utils.ktsmate.docket.line.GroupHeaderLine;
import utils.ktsmate.docket.line.KTSLine;
import utils.ktsmate.gui.renderer.LineRenderer;

public class SimpleLineRenderer<T>
implements LineRenderer<T> {
    private KTSLine<T> line;
    private JComponent renderer;
    private JTextArea label;
    private FontAttributes fontAttributes;
    private boolean courseInclude;

    public SimpleLineRenderer(KTSLine<T> toRender, FontAttributes attributes, boolean includeCourse) {
        this.line = toRender;
        this.fontAttributes = attributes;
        this.courseInclude = includeCourse;
        this.renderer = this.createRenderer();
        this.renderer.setOpaque(false);
    }

    protected String getText(KTSLine<T> line) {
        return String.valueOf(line.getData());
    }

    private JComponent createRenderer() {
        this.label = new JTextArea(){

            @Override
            public void setBorder(Border border) {
            }
        };
        this.label.setName("lblLine");
        this.label.setBorder(null);
        this.label.setFont(this.fontAttributes.generateFont());
        this.label.setEditable(false);
        this.label.setLineWrap(true);
        this.label.setWrapStyleWord(true);
        this.label.setText(this.getText(this.line));
        this.label.setEnabled(false);
        this.label.setBackground(Color.GREEN);
        this.label.setOpaque(false);
        this.label.setBackground(null);
        this.label.validate();
        JPanel holder = new JPanel();
        holder.setLayout(new BoxLayout(holder, 1));
        if (this.courseInclude) {
            holder.add(this.createCourseLine());
        }
        JPanel container = new JPanel(new FlowLayout(0, 0, 0));
        container.setOpaque(false);
        container.add(this.label);
        container.setBorder(null);
        holder.add(container);
        holder.setOpaque(false);
        holder.setBackground(null);
        return holder;
    }

    protected JComponent createCourseLine() {
        JPanel holdingPanel = new JPanel(new FlowLayout(1));
        holdingPanel.setOpaque(false);
        StringBuilder courseText = new StringBuilder("* ").append(((Course)Course.getCourses().get(this.getCourse())).toString()).append(" Course *");
        JLabel courseLabel = new JLabel(courseText.toString());
        courseLabel.setName("lblCourse");
        courseLabel.setHorizontalTextPosition(0);
        Font font = KTSMate.getLocalPrinter().getCourseAttributes().generateFont();
        courseLabel.setFont(font);
        holdingPanel.add(courseLabel);
        return holdingPanel;
    }

    protected int getCourse() {
        if (this.line instanceof GroupHeaderLine) {
            GroupHeaderLine gpHeaderLine = (GroupHeaderLine)this.line;
            return ((SalesItemSummaryGroup)gpHeaderLine.getData()).getSummary().getSalesItem().getCourse();
        }
        return 0;
    }

    @Override
    public KTSLine getRenderedLine() {
        return this.line;
    }

    @Override
    public JComponent getRenderingComponent() {
        if (this.renderer == null) {
            this.renderer = this.createRenderer();
            this.refreshRenderingComponent();
        }
        return this.renderer;
    }

    @Override
    public void refreshRenderingComponent() {
        this.renderer.validate();
        this.renderer.repaint();
        this.renderer.setOpaque(this.line.isHighlighted());
    }

    @Override
    public void adjustRendererHeightToFit(int width) {
        int adjustedWidth = (int)((double)width / 1.1);
        this.label.setPreferredSize(this.getPreferredDimensions(adjustedWidth));
        this.renderer.setPreferredSize(new Dimension(this.getPreferredDimensions(width)));
        this.renderer.invalidate();
    }

    private Dimension getPreferredDimensions(int width) {
        FontMetrics metrics = this.label.getFontMetrics(this.label.getFont());
        int maxHeightPerLine = metrics.getHeight() + 2;
        String text = this.label.getText();
        double charWidth = metrics.charsWidth(text.toCharArray(), 0, text.length());
        double labelWidth = this.label.getWidth();
        double lines = charWidth / labelWidth;
        double finalLineCount = Math.ceil(lines);
        return new Dimension(width, (int)(finalLineCount * (double)maxHeightPerLine));
    }
}

